% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbGetQueryArrow.R
\name{dbGetQueryArrow}
\alias{dbGetQueryArrow}
\title{Retrieve results from a query as an Arrow object}
\usage{
dbGetQueryArrow(conn, statement, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbGetQueryArrow()} always returns an object coercible to a \link{data.frame}, with
as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Returns the result of a query as an Arrow object.
\code{dbGetQueryArrow()} comes with a default implementation
(which should work with most backends) that calls
\code{\link[=dbSendQueryArrow]{dbSendQueryArrow()}}, then \code{\link[=dbFetchArrow]{dbFetchArrow()}}, ensuring that
the result is always freed by \code{\link[=dbClearResult]{dbClearResult()}}.
For passing query parameters,
see \code{\link[=dbSendQueryArrow]{dbSendQueryArrow()}}, in particular
the "The data retrieval flow for Arrow streams" section.
For retrieving results as a data frame, see \code{\link[=dbGetQuery]{dbGetQuery()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbGetQueryArrow")}
}
\details{
This method is for \code{SELECT} queries only
(incl. other SQL statements that return a \code{SELECT}-alike result,
e.g., execution of a stored procedure or data manipulation queries
like \verb{INSERT INTO ... RETURNING ...}).
To execute a stored procedure that does not return a result set,
use \code{\link[=dbExecute]{dbExecute()}}.

Some backends may
support data manipulation statements through this method.
However, callers are strongly advised to use
\code{\link[=dbExecute]{dbExecute()}} for data manipulation statements.
}
\section{Implementation notes}{

Subclasses should override this method only if they provide some sort of
performance optimization.
}

\section{Failure modes}{


An error is raised when issuing a query over a closed
or invalid connection,
if the syntax of the query is invalid,
or if the query is not a non-\code{NA} string.
The object returned by \code{dbGetQueryArrow()} can also be passed to
\code{\link[nanoarrow:as_nanoarrow_array_stream]{nanoarrow::as_nanoarrow_array_stream()}} to create a nanoarrow
array stream object that can be used to read the result set
in batches.
The chunk size is implementation-specific.

}

\section{Additional arguments}{


The following arguments are not part of the \code{dbGetQueryArrow()} generic
(to improve compatibility across backends)
but are part of the DBI specification:
\itemize{
\item \code{params} (default: \code{NULL})
\item \code{immediate} (default: \code{NULL})
}

They must be provided as named arguments.
See the "Specification" and "Value" sections for details on their usage.

The \code{param} argument allows passing query parameters, see \code{\link[DBI:dbBind]{DBI::dbBind()}} for details.

}

\section{Specification for the \code{immediate} argument}{



The \code{immediate} argument supports distinguishing between "direct"
and "prepared" APIs offered by many database drivers.
Passing \code{immediate = TRUE} leads to immediate execution of the
query or statement, via the "direct" API (if supported by the driver).
The default \code{NULL} means that the backend should choose whatever API
makes the most sense for the database, and (if relevant) tries the
other API if the first attempt fails. A successful second attempt
should result in a message that suggests passing the correct
\code{immediate} argument.
Examples for possible behaviors:
\enumerate{
\item DBI backend defaults to \code{immediate = TRUE} internally
\enumerate{
\item A query without parameters is passed: query is executed
\item A query with parameters is passed:
\enumerate{
\item \code{params} not given: rejected immediately by the database
because of a syntax error in the query, the backend tries
\code{immediate = FALSE} (and gives a message)
\item \code{params} given: query is executed using \code{immediate = FALSE}
}
}
\item DBI backend defaults to \code{immediate = FALSE} internally
\enumerate{
\item A query without parameters is passed:
\enumerate{
\item simple query: query is executed
\item "special" query (such as setting a config options): fails,
the backend tries \code{immediate = TRUE} (and gives a message)
}
\item A query with parameters is passed:
\enumerate{
\item \code{params} not given: waiting for parameters via \code{\link[DBI:dbBind]{DBI::dbBind()}}
\item \code{params} given: query is executed
}
}
}

}

\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE) && requireNamespace("nanoarrow", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Retrieve data as arrow table
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
dbGetQueryArrow(con, "SELECT * FROM mtcars")

dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\seealso{
For updates: \code{\link[=dbSendStatement]{dbSendStatement()}} and \code{\link[=dbExecute]{dbExecute()}}.

Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbAppendTableArrow}()},
\code{\link{dbCreateTable}()},
\code{\link{dbCreateTableArrow}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbQuoteIdentifier}()},
\code{\link{dbReadTable}()},
\code{\link{dbReadTableArrow}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendQueryArrow}()},
\code{\link{dbSendStatement}()},
\code{\link{dbUnquoteIdentifier}()},
\code{\link{dbWriteTable}()},
\code{\link{dbWriteTableArrow}()}

Other data retrieval generics: 
\code{\link{dbBind}()},
\code{\link{dbClearResult}()},
\code{\link{dbFetch}()},
\code{\link{dbFetchArrow}()},
\code{\link{dbFetchArrowChunk}()},
\code{\link{dbGetQuery}()},
\code{\link{dbHasCompleted}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendQueryArrow}()}
}
\concept{DBIConnection generics}
\concept{data retrieval generics}
