% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-DBIConnection.R
\docType{class}
\name{DBIConnection-class}
\alias{DBIConnection-class}
\title{DBIConnection class}
\description{
This virtual class encapsulates the connection to a DBMS, and it provides
access to dynamic queries, result sets, DBMS session management
(transactions), etc.
}
\section{Implementation note}{

Individual drivers are free to implement single or multiple simultaneous
connections.
}

\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- dbConnect(RSQLite::SQLite(), ":memory:")
con
dbDisconnect(con)
\dontrun{
con <- dbConnect(RPostgreSQL::PostgreSQL(), "username", "passsword")
con
dbDisconnect(con)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other DBI classes: 
\code{\link{DBIConnector-class}},
\code{\link{DBIDriver-class}},
\code{\link{DBIObject-class}},
\code{\link{DBIResult-class}}

Other DBIConnection generics: 
\code{\link{dbAppendTable}()},
\code{\link{dbCreateTable}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbReadTable}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendStatement}()},
\code{\link{dbWriteTable}()}
}
\concept{DBI classes}
\concept{DBIConnection generics}
