% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbListObjects.R
\name{dbListObjects}
\alias{dbListObjects}
\title{List remote objects}
\usage{
dbListObjects(conn, prefix = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{prefix}{A fully qualified path in the database's namespace, or \code{NULL}.
This argument will be processed with \code{\link[=dbUnquoteIdentifier]{dbUnquoteIdentifier()}}.
If given the method will return all objects accessible through this prefix.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbListObjects()}
returns a data frame
with columns
\code{table} and \code{is_prefix} (in that order),
optionally with other columns with a dot (\code{.}) prefix.
The \code{table} column is of type list.
Each object in this list is suitable for use as argument in \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.
The \code{is_prefix} column is a logical.
This data frame contains one row for each object (schema, table
and view)
accessible from the prefix (if passed) or from the global namespace
(if prefix is omitted).
Tables added with \code{\link[=dbWriteTable]{dbWriteTable()}}
are part of the data frame.
As soon a table is removed from the database,
it is also removed from the data frame of database objects.

The same applies to temporary objects if supported by the database.

The returned names are suitable for quoting with \code{dbQuoteIdentifier()}.
}
\description{
Returns the names of remote objects accessible through this connection
as a data frame.
This should include temporary objects, but not all database backends
(in particular \pkg{RMariaDB} and \pkg{RMySQL}) support this.
Compared to \code{\link[=dbListTables]{dbListTables()}}, this method also enumerates tables and views
in schemas, and returns fully qualified identifiers to access these objects.
This allows exploration of all database objects available to the current
user, including those that can only be accessed by giving the full
namespace.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbListObjects")}
}
\section{Failure modes}{


An error is raised when calling this method for a closed
or invalid connection.

}

\section{Specification}{


The \code{prefix} column indicates if the \code{table} value refers to a table
or a prefix.
For a call with the default \code{prefix = NULL}, the \code{table}
values that have \code{is_prefix == FALSE} correspond to the tables
returned from \code{\link[=dbListTables]{dbListTables()}},

The \code{table} object can be quoted with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.
The result of quoting can be passed to \code{\link[=dbUnquoteIdentifier]{dbUnquoteIdentifier()}}.
(We have to assume that the resulting identifier is a table, because one
cannot always tell from a quoted identifier alone whether it is a table
or a schema for example. As a consequence, the quote-unquote roundtrip
only works for tables (possibly schema-qualified), but not for other
database objects like schemata or columns.)
The unquoted results are equal to the original \code{table} object.
(For backends it may be convenient to use the \link{Id} class, but this is
not required.)

Values in \code{table} column that have \code{is_prefix == TRUE} can be
passed as the \code{prefix} argument to another call to \code{dbListObjects()}.
For the data frame returned from a \code{dbListObject()} call with the
\code{prefix} argument set, all \code{table} values where \code{is_prefix} is
\code{FALSE} can be used in a call to \code{\link[=dbExistsTable]{dbExistsTable()}} which returns
\code{TRUE}.

}

\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbListObjects(con)
dbWriteTable(con, "mtcars", mtcars)
dbListObjects(con)

dbDisconnect(con)
}
\seealso{
Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbCreateTable}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbReadTable}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendStatement}()},
\code{\link{dbWriteTable}()}
}
\concept{DBIConnection generics}
