% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictDiscrete.R
\name{predictDiscrete}
\alias{predictDiscrete}
\title{Conditional expectation for a copula-based estimation of mixed regression models for discrete response}
\usage{
predictDiscrete(object, newdata, m = 100)
}
\arguments{
\item{object}{Object of class ``EstDiscrete`` generated by EstDiscrete.}

\item{newdata}{List of variables for be predicted (``clu`` for clusters, ``xc`` for the copula covariates, and ``xm`` for the margins covariates). The covariates can be NULL.}

\item{m}{Number of points for the numerical integration (default is 100).}
}
\value{
\item{mest}{Conditional expectations (conditional probabilities for the multinomial case}
}
\description{
Compute the conditional expectation of a copula-based  2-level hierarchical model for disctrete response.
}
\examples{
data(out.poisson)
pred= predictDiscrete(out.poisson,list(clu=c(1:50),xm=rep(0.4,50)),)
}
\references{
Krupskii, Nasri & Remillard (2023). On factor copula-based mixed regression models
}
\author{
Pavel Krupskii and Bruno N. Remillard, January 20, 2023
}
