% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidNChooseB}
\alias{stopOnInvalidNChooseB}
\title{Parameter Function stopOnInvalidNChooseB}
\usage{
stopOnInvalidNChooseB(paramCheckResult, n, b)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{n}{represents the number of players}

\item{b}{number of players in subset}
}
\description{
stopOnInvalidNChooseB checks if definition of n choose b is 
specified correctly and causes stop otherwise.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1080 \tab Number of players 'n' is 'NULL' \cr
1081 \tab Number of involved players 'b' is 'NULL' \cr
1082 \tab Number of players 'n' is not 'numeric' \cr
1083 \tab Number of involved players 'b' is not 'numeric \cr
1084 \tab Number of involved players 'b' is greater than of players 'n'}
}

\examples{
library(CoopGame)
paramCheckResult=getEmptyParamCheckResult()
validN = 3
validAndConsistentB = 2
stopOnInvalidNChooseB(paramCheckResult, n=validN, b=validAndConsistentB)

}
\seealso{
Other ParameterChecks_CoopGame: 
\code{\link{getEmptyParamCheckResult}()},
\code{\link{stopOnInconsistentEstateAndClaimsVector}()},
\code{\link{stopOnInvalidAllocation}()},
\code{\link{stopOnInvalidBoolean}()},
\code{\link{stopOnInvalidClaimsVector}()},
\code{\link{stopOnInvalidCoalitionS}()},
\code{\link{stopOnInvalidDictator}()},
\code{\link{stopOnInvalidEstate}()},
\code{\link{stopOnInvalidGameVector}()},
\code{\link{stopOnInvalidGrandCoalitionN}()},
\code{\link{stopOnInvalidIndex}()},
\code{\link{stopOnInvalidLeftRightGloveGame}()},
\code{\link{stopOnInvalidNumberOfPlayers}()},
\code{\link{stopOnInvalidNumber}()},
\code{\link{stopOnInvalidQuota}()},
\code{\link{stopOnInvalidVetoPlayer}()},
\code{\link{stopOnInvalidWeightVector}()},
\code{\link{stopOnParamCheckError}()}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
\concept{ParameterChecks_CoopGame}
