% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JohnstonConcept.R
\name{johnstonIndex}
\alias{johnstonIndex}
\title{Compute Johnston index}
\usage{
johnstonIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Johnston index for a specified simple game
}
\description{
johnstonIndex calculates the Johnston index for a simple game.
}
\examples{
library(CoopGame)
johnstonIndex(c(0,0,0,1,0,0,1))

\donttest{
#player 1 has 3 votes
#player 2 has 2 votes
#player 3 has 1 vote
#majority for the decision is 4 (quota)

library(CoopGame)
#function call generating the game vector:
v <- weightedVotingGameVector(n = 3, w = c(3,2,1), q = 4)

johnstonIndex(v)
#[1] 0.6666667 0.1666667 0.1666667
}

}
\references{
Johnston R.J. (1978) "On the measurement of power: Some reactions to Laver", Environment and Planning A, pp. 907--914

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, p. 124
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Michael Maerz

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
