% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcomppareto.R
\name{rwdcomppareto}
\alias{rwdcomppareto}
\title{Generating random number from a discrete composite distribution with Pareto tail}
\usage{
rwdcomppareto(n, spec, alpha = 1, theta = 1, ...)
}
\arguments{
\item{n}{number of observations}

\item{spec}{The selection of the lower tail (head) distribution}

\item{alpha}{The shape parameter of the Pareto distribution}

\item{theta}{The scale parameter of Pareto, also serve as the location parameter of the composite model}

\item{...}{The parameter of the lower tail (head) distribution}
}
\value{
an object of the same length of n
}
\description{
\code{rwdcomppareto} returns a random sample of a discrete composite distribution with a Pareto upper tail, with a specified distribution at the lower tail.
}
\examples{
n<-10
rcomppareto(n,"weibull", alpha = 1.5, theta = 1.5, shape = 2, scale = 2)
}
