% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convrg_func.R
\name{extract_pi_quantiles}
\alias{extract_pi_quantiles}
\title{Extract quantiles of pi parameters}
\usage{
extract_pi_quantiles(model_out, probs = c(0.05, 0.5, 0.95))
}
\arguments{
\item{model_out}{Output of CNVRG modeling functions, including cnvrg_HMC and cnvrg_VI}

\item{probs}{A vector of quantiles}
}
\value{
A list specifying quantiles for each feature in each treatment group.
}
\description{
Provides quantiles of pi parameters for each feature and treatment group.
}
\examples{
#simulate an OTU table
com_demo <-matrix(0, nrow = 10, ncol = 10)
com_demo[1:5,] <- c(rep(3,5), rep(7,5)) #Alternates 3 and 7
com_demo[6:10,] <- c(rep(7,5), rep(3,5)) #Reverses alternation
fornames <- NA
for(i in 1:length(com_demo[1,])){
fornames[i] <- paste("otu_", i, sep = "")
}
sample_vec <- NA
for(i in 1:length(com_demo[,1])){
sample_vec[i] <- paste("sample", i, sep = "_")
}
com_demo <- data.frame(sample_vec, com_demo)
names(com_demo) <- c("sample", fornames)

out <- cnvrg_VI(com_demo,starts = c(1,6), ends=c(5,10))
extract_pi_quantiles(model_out = out, probs = c(0.05,0.5,0.95))
}
