% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPkgDependencyGraph.R
\name{subgraphByDegree}
\alias{subgraphByDegree}
\title{Subset graph by degree}
\usage{
subgraphByDegree(g, pkg, degree = 1, ...)
}
\arguments{
\item{g}{an igraph graph, typically created by
\code{\link{buildPkgDependencyIgraph}}}

\item{pkg}{character(1) package name from which to
measure degree.}

\item{degree}{integer(1) degree, limit search for
adjacent vertices to this degree.}

\item{...}{passed on to \code{\link[igraph]{distances}}}
}
\value{
An igraph graph, with only nodes and their
edges within degree of the named package
}
\description{
While the \code{\link{inducedSubgraphByPkgs}}
returns the subgraph with the minimal connections
between named packages, this function takes a vector of
package names, a degree (1 or more) and returns the
subgraph(s) that are within \code{degree} of the
package named.
}
\examples{

g = buildPkgDependencyIgraph(buildPkgDependencyDataFrame())
g2 = subgraphByDegree(g, 'GEOquery')
plot(g2)

}
