% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPkgDependencyGraph.R
\name{inducedSubgraphByPkgs}
\alias{inducedSubgraphByPkgs}
\title{Return a minimal subgraph based on package name(s)}
\usage{
inducedSubgraphByPkgs(g, pkgs, pkg_color = "red")
}
\arguments{
\item{g}{an igraph graph, typically created by
\code{\link{buildPkgDependencyIgraph}}}

\item{pkgs}{character() vector of packages to
include. Package names not included in
the graph are ignored.}

\item{pkg_color}{character(1) giving color of named
packages. Other packages in the graph that fall in
connecting paths will be colored as the igraph default.}
}
\description{
Find the subgraph induced by including
specific packages. The induced subgraph is
the graph that includes the named packages
and all edges connecting them. This is useful
for a developer, for example, to examine her packages
and their intervening dependencies.
}
\examples{
library(igraph)
g <- buildPkgDependencyIgraph(buildPkgDependencyDataFrame())
## subgraph of only the first 10 packages maintained by Bioconductor
biocmaintained <- head(biocMaintained()[["Package"]], 10L)
g2 <- inducedSubgraphByPkgs(g, pkgs = biocmaintained)
g2
V(g2)

plot(g2)

## subgraph of a package's strong Bioconductor package dependencies
maedeps <- unlist(pkgBiocDeps(
    "MultiAssayExperiment", which = "strong",
    recursive = TRUE, only.bioc = TRUE
), use.names = FALSE)
g3 <- inducedSubgraphByPkgs(g, pkgs = maedeps)
plot(g3)

## same subgraph with networkD3::forceNetwork
library(networkD3)
wt <- cluster_walktrap(g3)
members <- membership(wt)
ndg3 <- igraph_to_networkD3(g3, group = members)
forceNetwork(
    Links = ndg3$links, Nodes = ndg3$nodes, Source = 'source',
    Target = 'target', NodeID = 'name', Group = 'group', zoom = TRUE,
    linkDistance = 200, fontSize = 20, opacity = 0.9, opacityNoHover = 0.9
)
}
