% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFs.R
\name{BFs}
\alias{BFs}
\title{Sceptical Bayes factor}
\usage{
BFs(to, so, tr, sr, truncate = FALSE, zo = NULL, zr = NULL, c = NULL)
}
\arguments{
\item{to}{Original effect estimate}

\item{so}{Standard error of the original effect estimate}

\item{tr}{Replication effect estimate}

\item{sr}{Standard error of the replication effect estimate}

\item{truncate}{Logical indicating whether advocacy prior should be truncated
to direction of the original effect estimate (i.e., a one-sided test).
Defaults to \code{FALSE}}

\item{zo}{Original \emph{z}-value \code{zo} = \code{to}/\code{so} (alternative
parametrization for \code{to} and \code{so})}

\item{zr}{Replication \emph{z}-value \code{zr} = \code{tr}/\code{sr} (alternative
parametrization for \code{tr} and \code{sr})}

\item{c}{Relative variance \code{c = so^2/sr^2} (alternative parametrization
for \code{so} and \code{sr})}
}
\value{
The sceptical Bayes factor \eqn{\mathrm{BF}_{\mathrm{S}}}{BF_S}.
\eqn{\mathrm{BF}_{\mathrm{S}} < 1}{BF_S < 1} indicates replication
success, the smaller the value of \eqn{\mathrm{BF}_{\mathrm{S}}}{BF_S}
the higher the degree of replication success. It is possible that the
result of the replication is so inconclusive that replication success
cannot be established at any level. In this case, the sceptical Bayes
factor does not exist and the function returns \code{NaN}.
}
\description{
Computes the sceptical Bayes factor
}
\details{
The sceptical Bayes factor is a summary measure of the following
two-step reverse-Bayes procedure for assessing replication success:
\enumerate{
\item Use the data from the original study to determine the standard deviation
\eqn{\tau_{\gamma}}{tau_gamma} of a sceptical normal prior \eqn{\theta \sim
\mathrm{N}(0, \tau_{\gamma}^2)}{HS: theta ~ N(0, tau_gamma^2)} such that the
Bayes factor contrasting the null hypothesis \eqn{H_0: \theta = 0}{H0: theta
= 0} to the sceptic's hypothesis \eqn{H_{\mathrm{S}}: \theta \sim
\mathrm{N}(0, \tau_{\gamma}^2)}{HS: theta ~ N(0, tau_gamma^2)} equals a
specified level \eqn{\gamma \in (0, 1]}{gamma in (0 1]}. This prior
represents a sceptic who remains unconvinced about the presence of an effect
at level \eqn{\gamma}{gamma}.
\item Use the data from the replication study to compare the sceptic's
hypothesis \eqn{H_{\mathrm{S}}: \theta \sim \mathrm{N}(0,
\tau_{\gamma}^2)}{HS: theta ~ N(0, tau_gamma^2)} to the advocate's hypothesis
\eqn{H_{\mathrm{A}}: \theta \sim f(\theta \, | \,
\mathrm{original~study})}{HA: theta ~ f(theta | original study)}. The prior of
the effect size under \eqn{H_{\mathrm{A}}}{HA} is its posterior based on the
original study and a uniform prior, thereby representing the position of an
advocate of the original study. Replication success at level
\eqn{\gamma}{gamma} is achieved if the Bayes factor contrasting
\eqn{H_{\mathrm{S}}}{HS} to \eqn{H_{\mathrm{A}}}{HA} is smaller than
\eqn{\gamma}{gamma}, which means that the replication data favour the
advocate over the sceptic at a higher level than the sceptic's initial
objection. The sceptical Bayes factor \eqn{\mathrm{BF}_{\mathrm{S}}}{BF_S} is
the smallest level \eqn{\gamma}{gamma} at which replication success can be
established.
}

The function can be used with two input parametrizations, either on the
absolute effect scale (\code{to}, \code{so}, \code{tr}, \code{sr}) or
alternatively on the relative \emph{z}-scale (\code{zo}, \code{zr}, \code{c}). If
an argument on the effect scale is missing, the \emph{z}-scale is automatically
used and the other non-missing arguments on the effect scale ignored.
}
\examples{
to <- 2
tr <- 2.5
so <- 1
sr <- 1
BFs(to = to, so = so, tr = tr, sr = sr)
BFs(zo = to/so, zr = tr/sr, c = so^2/sr^2)

}
\references{
Pawel, S. and Held, L. (2022). The sceptical Bayes factor for the
assessment of replication success. Journal of the Royal Statistical
Society Series B: Statistical Methodology, 84(3): 879-911.
\doi{10.1111/rssb.12491}
}
\seealso{
\code{\link{BFsSMD}}, \code{\link{BFslogOR}}
}
\author{
Samuel Pawel
}
