% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSRPexact.R
\docType{data}
\name{SSRPexact}
\alias{SSRPexact}
\title{Data from the Social Sciences Replication Project}
\format{
A data frame with 21 rows and 16 variables
}
\source{
The data were manually extracted from the Bayesian supplement of the
SSRP (\url{https://osf.io/nsxgj/}). The data are licensed under CC0 1.0
Universal.
}
\usage{
data(SSRPexact)
}
\description{
Data from the Social Sciences Replication Project.
The variables are as follows:
\describe{
\item{\code{study}}{Authors, year, and journal of the original study}
\item{\code{type}}{Type of effect size. Either \code{"logOR"} for log oddds ratio effect
size, \code{"SMD1"} for standardized mean difference from one-sample or paired
\eqn{t}-test, or \code{"SMD2"} for standardized mean difference from two-sample
\eqn{t}-test}
\item{\code{to}}{\eqn{t}-statistic from the original study
(only available for \code{"SMD1"} and \code{"SMD2"})}
\item{\code{n1o}}{Sample size in group 1 of the original study
(only available for \code{"SMD1"} and \code{"SMD2"})}
\item{\code{n2o}}{Sample size in group 2 of the original study
(only available for \code{"SMD2"})}
\item{\code{tr}}{\eqn{t}-statistic from the replication study
(only available for \code{"SMD1"} and \code{"SMD2"})}
\item{\code{n1r}}{Sample size in group 1 of the replication study
(only available for \code{"SMD1"} and \code{"SMD2"})}
\item{\code{n2r}}{Sample size in group 2 of the replication study
(only available for \code{"SMD2"})}
\item{\code{ao}}{Number of cases in original study treatment group
(only available for \code{"logOR"})}
\item{\code{bo}}{Number of non-cases in original study treatment group
(only available for \code{"logOR"})}
\item{\code{co}}{Number of cases in original study control group
(only available for \code{"logOR"})}
\item{\code{do}}{Number of non-cases in original study control group
(only available for \code{"logOR"})}
\item{\code{ar}}{Number of cases in replication study treatment group
(only available for \code{"logOR"})}
\item{\code{br}}{Number of cases in replication study control group
(only available for \code{"logOR"})}
\item{\code{cr}}{Number of cases in replication study control group
(only available for \code{"logOR"})}
\item{\code{dr}}{Number of non-cases in replication study control group
(only available for \code{"logOR"})}
}
}
\references{
Camerer, C. F., Dreber, A., Holzmeister, F., Ho, T.-H., Huber,
J., Johannesson, M., ... Wu, H. (2018). Evaluating the replicability of
social science experiments in Nature and Science between 2010 and 2015.
Nature Human Behaviour, 2, 637-644. \doi{10.1038/s41562-018-0399-z}
}
\author{
Samuel Pawel
}
\keyword{data}
