% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/58_fcast_plot.R
\name{plot.bvar_fcast}
\alias{plot.bvar_fcast}
\title{Plotting method for Bayesian VAR predictions}
\usage{
\method{plot}{bvar_fcast}(
  x,
  vars = NULL,
  col = "#737373",
  t_back = 1,
  area = FALSE,
  fill = "#808080",
  variables = NULL,
  orientation = c("vertical", "horizontal"),
  mar = c(2, 2, 2, 0.5),
  ...
)
}
\arguments{
\item{x}{A \code{bvar_fcast} object, obtained from \code{\link{predict.bvar}}.}

\item{vars}{Optional numeric or character vector. Used to subset the plot to
certain variables by position or name (must be available). Defaults to
\code{NULL}, i.e. all variables.}

\item{col}{Character vector. Colour(s) of the lines delineating credible
intervals. Single values will be recycled if necessary. Recycled HEX color
codes are varied in transparency if not provided (e.g. "#737373FF"). Lines
can be bypassed by setting this to \code{"transparent"}.}

\item{t_back}{Integer scalar. Number of observed datapoints to plot ahead of
the forecast.}

\item{area}{Logical scalar. Whether to fill the credible intervals using
\code{\link[graphics]{polygon}}.}

\item{fill}{Character vector. Colour(s) to fill the credible intervals with.
See \emph{col} for more information.}

\item{variables}{Optional character vector. Names of all variables in the
object. Used to subset and title. Taken from \code{x$variables} if available.}

\item{orientation}{String indicating the orientation of the plots. Defaults
to \code{"v"} (i.e. vertical); may be set to \code{"h"} (i.e. horizontal).}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}
}
\value{
Returns \emph{x} invisibly.
}
\description{
Plotting method for forecasts obtained from \code{\link{predict.bvar}}.
Forecasts of all or a subset of the available variables can be plotted.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Store predictions ex-post
predict(x) <- predict(x)

# Plot forecasts for all available variables
plot(predict(x))

# Subset to variables in positions 1 and 3 via their name
plot(predict(x), vars = c("CPI", "FED"))

# Subset via position, increase the plotted forecast horizon and past data
plot(predict(x, horizon = 20), vars = c(1, 3), t_back = 10)

# Adjust confidence bands and the plot's orientation
plot(predict(x, conf_bands = 0.25), orientation = "h")

# Draw areas inbetween the confidence bands and skip drawing lines
plot(predict(x), col = "transparent", area = TRUE)

# Plot a conditional forecast (with a constrained second variable).
plot(predict(x, cond_path = c(1, 1, 1, 1, 1, 1), cond_var = 2))
}
}
\seealso{
\code{\link{bvar}}; \code{\link{predict.bvar}}
}
\keyword{BVAR}
\keyword{analysis}
\keyword{forecast}
\keyword{plot}
