/* ============================================================
* QupZilla - WebKit based browser
* Copyright (C) 2010-2014  David Rosca <nowrep@gmail.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* ============================================================ */
#include "aboutdialog.h"
#include "ui_aboutdialog.h"
#include "browserwindow.h"
#include "mainapplication.h"
#include "tabbedwebview.h"
#include "webpage.h"
#include "qtwin.h"

#if QT_VERSION < 0x050000
#include "qwebkitversion.h"
#else
#include <QWebPage>
#endif

AboutDialog::AboutDialog(QWidget* parent)
    : QDialog(parent),
      ui(new Ui::AboutDialog)
{
    ui->setupUi(this);
#ifdef Q_OS_WIN
    if (QtWin::isCompositionEnabled()) {
        QtWin::extendFrameIntoClientArea(this);
        ui->verticalLayout->setContentsMargins(0, 0, 0, 0);
    }
#endif

    connect(ui->buttonBox, SIGNAL(clicked(QAbstractButton*)), this, SLOT(close()));
    connect(ui->authorsButton, SIGNAL(clicked()), this, SLOT(buttonClicked()));

    showAbout();

#ifdef Q_OS_WIN
    resize(300, height());
#endif
}

void AboutDialog::buttonClicked()
{
    if (ui->authorsButton->text() == tr("Authors and Contributors")) {
        showAuthors();
    }
    else if (ui->authorsButton->text() == tr("< About QupZilla")) {
        showAbout();
    }
}

void AboutDialog::showAbout()
{
    ui->authorsButton->setText(tr("Authors and Contributors"));
    if (m_aboutHtml.isEmpty()) {
        m_aboutHtml += "<center><div style='margin:10px;'>";
        m_aboutHtml += tr("<p><b>Application version %1</b><br/>").arg(
#ifdef GIT_REVISION
                           QString("%1 (%2)").arg(Qz::VERSION, GIT_REVISION)
#else
                           Qz::VERSION
#endif
                       );
        m_aboutHtml += tr("<b>WebKit version %1</b></p>").arg(qWebKitVersion());
        m_aboutHtml += QString("<p>&copy; %1 %2<br/>").arg(Qz::COPYRIGHT, Qz::AUTHOR);
        m_aboutHtml += tr("<small>Build time: %1 </small></p>").arg(Qz::BUILDTIME);
        m_aboutHtml += QString("<p><a href=%1>%1</a></p>").arg(Qz::WWWADDRESS);
        m_aboutHtml += "<p>" + (mApp->windowCount() > 0 ? mApp->getWindow()->weView()->page()->userAgentForUrl(QUrl()) : QString()) + "</p>";
        m_aboutHtml += "</div></center>";
    }
    ui->textBrowser->setHtml(m_aboutHtml);
}

void AboutDialog::showAuthors()
{
    ui->authorsButton->setText(tr("< About QupZilla"));
    if (m_authorsHtml.isEmpty()) {
        m_authorsHtml += "<center><div style='margin:10px;'>";
        m_authorsHtml += tr("<p><b>Main developer:</b><br/>%1 &lt;%2&gt;</p>").arg(Qz::AUTHOR, "<a href=mailto:nowrep@gmail.com>nowrep@gmail.com</a>");
        m_authorsHtml += tr("<p><b>Contributors:</b><br/>%1</p>").arg(
                             QString::fromUtf8("Mladen Pejaković<br/>"
                                               "Alexander Samilov<br/>"
                                               "Seyyed Razi Alavizadeh<br/>"
                                               "Franz Fellner<br/>"
                                               "Bryan M Dunsmore<br/>"
                                               "Mariusz Fik<br/>"
                                               "Jan Rajnoha<br/>"
                                               "Daniele Cocca")
                         );

        m_authorsHtml += tr("<p><b>Translators:</b><br/>%1</p>").arg(
                             QString::fromUtf8("Heimen Stoffels<br/>"
                                               "Peter Vacula<br/>"
                                               "Jonathan Hooverman<br/>"
                                               "Federico Fabiani<br/>"
                                               "Francesco Marinucci<br/>"
                                               "Jorge Sevilla<br/>"
                                               "Ștefan Comănescu<br/>"
                                               "Michał Szymanowski<br/>"
                                               "Mariusz Fik<br/>"
                                               "Jérôme Giry<br/>"
                                               "Nicolas Ourceau<br/>"
                                               "Vasilis Tsivikis<br/>"
                                               "Rustam Salakhutdinov<br/>"
                                               "Oleg Brezhnev<br/>"
                                               "Sérgio Marques<br/>"
                                               "Alexandre Carvalho<br/>"
                                               "Mladen Pejaković<br/>"
                                               "Unink-Lio<br/>"
                                               "Wu Cheng-Hong<br/>"
                                               "Widya Walesa<br/>"
                                               "Beqa Arabuli<br/>"
                                               "Daiki Noda<br/>"
                                               "Gábor Oberle<br/>"
                                               "Piccoro McKay Lenz<br/>"
                                               "Stanislav Kuznietsov<br/>"
                                               "Seyyed Razi Alavizadeh<br/>"
                                               "Guillem Prats<br/>"
                                               "Clara Villalba<br/>"
                                               "Yu Hai<br/>"
                                               "Muhammad Fawwaz Orabi<br/>"
                                               "Lasso Kante<br/>"
                                               "Kizito Birabwa<br/>"
                                               "Juan Carlos Sánchez<br/>"
                                               "Xabier Aramendi")
                         );
        m_authorsHtml += "</div></center>";
    }

    ui->textBrowser->setHtml(m_authorsHtml);
}

AboutDialog::~AboutDialog()
{
    delete ui;
}
