;;;;English
LangString PRODUCT_DESC  ${LANG_ENGLISH} "QupZilla is a new, fast and secure open-source WWW browser. QupZilla is licensed under GPL version 3 or (at your option) any later version. It is based on WebKit core and Qt Framework."
;
LangString TITLE_SecMain ${LANG_ENGLISH} "Main Components"
LangString TITLE_SecTranslations ${LANG_ENGLISH} "Translations"
LangString TITLE_SecPlugins ${LANG_ENGLISH} "Plugins"
LangString TITLE_SecDesktop ${LANG_ENGLISH} "Desktop Icon"
LangString TITLE_SecExtensions ${LANG_ENGLISH} "File Associations"
LangString TITLE_SecThemes ${LANG_ENGLISH} "Themes"
LangString TITLE_SecSetASDefault ${LANG_ENGLISH} "Default Browser"
LangString TITLE_SecProtocols ${LANG_ENGLISH} "Protocol Associations"

LangString FILE_Htm ${LANG_ENGLISH} "HTM File"
LangString FILE_Html ${LANG_ENGLISH} "HTML File"
;
LangString DESC_SecMain ${LANG_ENGLISH} "Main components of application."
LangString DESC_SecTranslations ${LANG_ENGLISH} "Other translations available to install. Default is English."
LangString DESC_SecPlugins ${LANG_ENGLISH} "Other plugins available to install."
LangString DESC_SecDesktop ${LANG_ENGLISH} "Add launcher to desktop."
LangString DESC_SecExtensions ${LANG_ENGLISH} "Associate QupZilla with .htm(l) files"
LangString DESC_SecThemes ${LANG_ENGLISH} "Additional themes for QupZilla"
LangString DESC_SecSetASDefault ${LANG_ENGLISH} "Set QupZilla as default internet browser"
LangString DESC_SecProtocols ${LANG_ENGLISH} "Associate QupZilla with http(s) and ftp protocols"
;
LangString MSG_RunningInstance ${LANG_ENGLISH} "QupZilla is already running! Do you want the installer try to terminate it?"
LangString MSG_InstallationCanceled ${LANG_ENGLISH} "Process cancelled by user."
LangString MSG_InvalidInstallPath ${LANG_ENGLISH} "Install path invalid!"

;;;;Arabic
LangString PRODUCT_DESC  ${LANG_ARABIC} "كَبزيلّا متصفّح للوب جديد سريع وآمن ومفتوح المصدر. يُرخَّص استخدامه وفق الإصدار الثالث من رخصة جنو العمومية (GPL) أو أي إصدار أحدث من ذلك (اختر كما تشاء). يُبنى كَبزيلّا على محرّك العرض WebKitوإطار العمل Qt."
;
LangString TITLE_SecMain ${LANG_ARABIC} "المكونات الأساسية"
LangString TITLE_SecTranslations ${LANG_ARABIC} "الترجمات"
LangString TITLE_SecPlugins ${LANG_ARABIC} "الإضافات"
LangString TITLE_SecDesktop ${LANG_ARABIC} "رمز على سطح المكتب"
LangString TITLE_SecExtensions ${LANG_ARABIC} "ارتباطات الملفات"
LangString TITLE_SecThemes ${LANG_ARABIC} "السمات"
LangString TITLE_SecSetASDefault ${LANG_ARABIC} "المتصفح المبدئي"
LangString TITLE_SecProtocols ${LANG_ARABIC} "ارتباطات البروتوكولات"

LangString FILE_Htm ${LANG_ARABIC} "ملف HTM"
LangString FILE_Html ${LANG_ARABIC} "ملف HTML"
;
LangString DESC_SecMain ${LANG_ARABIC} "المكونات الرئيسية للبرنامج."
LangString DESC_SecTranslations ${LANG_ARABIC} "ترجمات أخرى متوفرة للتثبيت. اللغة المبدئية هي الإنكليزية."
LangString DESC_SecPlugins ${LANG_ARABIC} "إضافات أخرى متوفّرة للتنزيل."
LangString DESC_SecDesktop ${LANG_ARABIC} "أضف اختصارًا لتشغيل كَبزيلا من سطح المكتب."
LangString DESC_SecExtensions ${LANG_ARABIC} "اربط كَبزيلّا بملفات HTML ذات اللواحق .htm أو .html."
LangString DESC_SecThemes ${LANG_ARABIC} "سمات أخرى لكَبزيلّا"
LangString DESC_SecSetASDefault ${LANG_ARABIC} "اجعل كَبزيلا المتصفح المبدئيّ"
LangString DESC_SecProtocols ${LANG_ARABIC} "اربط كَبزيلّا ببروتوكولات HTTP وHTTPS وFTP."
;
LangString MSG_RunningInstance ${LANG_ARABIC} "كَبزيلّا مفتوح الآن! أتريد من المُثبِّت إنهاءه الآن؟"
LangString MSG_InstallationCanceled ${LANG_ARABIC} "ألغى المستخدم العملية."

;;;;Spanish
LangString PRODUCT_DESC  ${LANG_SPANISH} "QupZilla es un nuevo, rápido y seguro navegador web de código abierto. QupZilla está bajo licencia GPL versión 3 o (o en su opción) en cualquier versión. Está basado en el motor WebKit y en Qt Framework."
;
LangString TITLE_SecMain ${LANG_SPANISH} "Componentes iniciales"
LangString TITLE_SecTranslations ${LANG_SPANISH} "Traducciones"
LangString TITLE_SecPlugins ${LANG_SPANISH} "Plugins"
LangString TITLE_SecDesktop ${LANG_SPANISH} "Icono de escritorio"
LangString TITLE_SecExtensions ${LANG_SPANISH} "Asociación de archivos"
LangString TITLE_SecThemes ${LANG_SPANISH} "Temas"
LangString TITLE_SecSetASDefault ${LANG_SPANISH} "Navegador por defecto"
LangString TITLE_SecProtocols ${LANG_SPANISH} "Asociaciones de protocolo"

LangString FILE_Htm ${LANG_SPANISH} "Archivo HTM"
LangString FILE_Html ${LANG_SPANISH} "Archivo HTML"
;
LangString DESC_SecMain ${LANG_SPANISH} "Componentes iniciales de aplicación"
LangString DESC_SecTranslations ${LANG_SPANISH} "Otras traduciones disponibles al instalar. Por defecto en inglés."
LangString DESC_SecPlugins ${LANG_SPANISH} "Otros plugins disponibles al instalar."
LangString DESC_SecDesktop ${LANG_SPANISH} "Añade acceso directo al escritorio."
LangString DESC_SecExtensions ${LANG_SPANISH} "Asociar QupZilla con archivos .htm(l)"
LangString DESC_SecThemes ${LANG_SPANISH} "Temas adicionales para QupZilla"
LangString DESC_SecSetASDefault ${LANG_SPANISH} "Hacer QupZilla tu navegador web por defecto"
LangString DESC_SecProtocols ${LANG_SPANISH} "Asociar QupZilla con los protocolos http(s) y ftp"
;
LangString MSG_RunningInstance ${LANG_SPANISH} "QupZilla se está ejecutando, Quieres que el instalador intente finalizarlo?"
LangString MSG_InstallationCanceled ${LANG_SPANISH} "Proceso cancelado por usuario."

;;;;Czech
LangString TITLE_SecMain ${LANG_CZECH} "Hlavní komponenty"
LangString TITLE_SecTranslations ${LANG_CZECH} "Překlady"
LangString TITLE_SecPlugins ${LANG_CZECH} "Doplňky"
LangString TITLE_SecDesktop ${LANG_CZECH} "Zástupce na ploše"
LangString TITLE_SecExtensions ${LANG_CZECH} "Asociace souborů"
LangString TITLE_SecThemes ${LANG_CZECH} "Témata"

LangString FILE_Htm ${LANG_CZECH} "Soubor HTM"
LangString FILE_Html ${LANG_CZECH} "Soubor HTML"
;
LangString DESC_SecMain ${LANG_CZECH} "Hlavní komponenty aplikace."
LangString DESC_SecTranslations ${LANG_CZECH} "Ostatní překlady dostupné k instalaci. Angličtina je defaultní."
LangString DESC_SecPlugins ${LANG_CZECH} "Ostatní doplňky dostupné k instalaci."
LangString DESC_SecDesktop ${LANG_CZECH} "Přidat zástupce na plochu."
LangString DESC_SecExtensions ${LANG_CZECH} "Associovat QupZillu s .htm(l) soubory"
LangString DESC_SecThemes ${LANG_CZECH} "Dodatečná témata pro QupZillu"

LangString PRODUCT_DESC ${LANG_CZECH} "QupZilla je nový, rychlý a bezpečný open-source WWW prohlížeč. QupZilla je licencována pod GPL verze 3 nebo (podle vaší volby) jakékoliv vyšší verze. Prohlížeč je založen na jádru WebKit a Qt Frameworku."
LangString TITLE_SecSetASDefault ${LANG_CZECH} "Výchozí prohlížeč"
LangString TITLE_SecProtocols ${LANG_CZECH} "Asociace protokolů"
LangString DESC_SecSetASDefault ${LANG_CZECH} "Nastavit QupZillu jako výchozí internetový prohlížeč"
LangString DESC_SecProtocols ${LANG_CZECH} "Asociovat QupZillu s http(s) a ftp protokoly"
LangString MSG_RunningInstance ${LANG_CZECH} "QupZilla je právě spuštěna. Chcete aby ji instalátor zkusil ukončit?"
LangString MSG_InstallationCanceled ${LANG_CZECH} "Proces zrušen uživatelem."

;;;;Catalan
LangString PRODUCT_DESC  ${LANG_CATALAN} "El QupZilla és un navegador web de codi obert nou, ràpid i segur. QupZilla està llicenciat sota GPL versió 3.0 o (si ho preferiu) qualsevol versió posterior. Està basat en WebKit i Qt."
;
LangString TITLE_SecMain ${LANG_CATALAN} "Components principals"
LangString TITLE_SecTranslations ${LANG_CATALAN} "Traduccions"
LangString TITLE_SecPlugins ${LANG_CATALAN} "Complements"
LangString TITLE_SecDesktop ${LANG_CATALAN} "Icona de l'escriptori"
LangString TITLE_SecExtensions ${LANG_CATALAN} "Associacions de fitxers"
LangString TITLE_SecThemes ${LANG_CATALAN} "Temes"
LangString TITLE_SecSetASDefault ${LANG_CATALAN} "Navegador per defecte"
LangString TITLE_SecProtocols ${LANG_CATALAN} "Associacions de protocols"

LangString FILE_Htm ${LANG_CATALAN} "Fitxer HTM"
LangString FILE_Html ${LANG_CATALAN} "Fitxer HTML"
;
LangString DESC_SecMain ${LANG_CATALAN} "Components principals de l'aplicació."
LangString DESC_SecTranslations ${LANG_CATALAN} "Altres traduccions disponibles per instal·lar. L'idioma predeterminat és l'anglès."
LangString DESC_SecPlugins ${LANG_CATALAN} "Altres plugins disponibles per instal·lar."
LangString DESC_SecDesktop ${LANG_CATALAN} "Afegeix una drecera a l'escriptori."
LangString DESC_SecExtensions ${LANG_CATALAN} "Associa el QupZilla amb els fitxers .htm i .html"
LangString DESC_SecThemes ${LANG_CATALAN} "Temes addicionals per al QupZilla"
LangString DESC_SecSetASDefault ${LANG_CATALAN} "Fes que el QupZilla sigui el navegador predeterminat"
LangString DESC_SecProtocols ${LANG_CATALAN} "Associa el QupZilla amb els protocols http i https"
;
LangString MSG_RunningInstance ${LANG_CATALAN} "El QupZilla ja està actiu. Voleu que l'instal·lador provi d'aturar-lo?"
LangString MSG_InstallationCanceled ${LANG_CATALAN} "L'usuari ha cancel·lat el procés."

;;;;Slovak
LangString PRODUCT_DESC ${LANG_SLOVAK} "QupZilla je nový, rýchly a bezpečný open-source internetový prehliadač. QupZilla je licencovaná pod licenciou GPL verzie 3 alebo (podľa vášho uváženia) hocijakej novšej verzie. Je založená na jadre WebKit a frameworku Qt."
;
LangString TITLE_SecMain ${LANG_SLOVAK} "Hlavné komponenty"
LangString TITLE_SecTranslations ${LANG_SLOVAK} "Preklady"
LangString TITLE_SecPlugins ${LANG_SLOVAK} "Doplnky"
LangString TITLE_SecDesktop ${LANG_SLOVAK} "Odkaz na ploche"
LangString TITLE_SecExtensions ${LANG_SLOVAK} "Asociácia súborov"
LangString TITLE_SecThemes ${LANG_SLOVAK} "Témy"
LangString TITLE_SecSetASDefault ${LANG_SLOVAK} "Predvolený prehliadač"
LangString TITLE_SecProtocols ${LANG_SLOVAK} "Asociácie protokolov"

LangString FILE_Htm ${LANG_SLOVAK} "Súbor HTM"
LangString FILE_Html ${LANG_SLOVAK} "Súbor HTML"
;
LangString DESC_SecMain ${LANG_SLOVAK} "Hlavné komponenty programu."
LangString DESC_SecTranslations ${LANG_SLOVAK} "Ostatné preklady dostupné na inštaláciu. Angličtina je predvolená"
LangString DESC_SecPlugins ${LANG_SLOVAK} "Ostatné doplnky dustupné na inštaláciu"
LangString DESC_SecDesktop ${LANG_SLOVAK} "Pridať odkaz na plochu."
LangString DESC_SecExtensions ${LANG_SLOVAK} "Associovať QupZillu s .htm(l) súbormi"
LangString DESC_SecThemes ${LANG_SLOVAK} "Ďalšie témy vzhľadu pre QupZillu"
LangString DESC_SecSetASDefault ${LANG_SLOVAK} "Nastaviť Qupzillu ako predvolený internetový prehliadač"
LangString DESC_SecProtocols ${LANG_SLOVAK} "Asociovať QupZillu s http(s) a ftp protokolmi"
;
LangString MSG_RunningInstance ${LANG_SLOVAK} "QupZilla je už spustená! Chcete, aby sa inštalátor pokúsil ju násilne ukončiť?"
LangString MSG_InstallationCanceled ${LANG_SLOVAK} "Proces zrušený používateľom."

;;;;German
LangString PRODUCT_DESC  ${LANG_GERMAN} "QupZilla ist ein neuer, schneller und sicherer, quelloffener Web Browser. QupZilla ist lizensiert unter GPL Version 3 oder später. Er nutzt Webkit und das Qt Framework."
;
LangString TITLE_SecMain ${LANG_GERMAN} "Hauptkomponenten"
LangString TITLE_SecTranslations ${LANG_GERMAN} "Übersetzungen"
LangString TITLE_SecPlugins ${LANG_GERMAN} "Plugins"
LangString TITLE_SecDesktop ${LANG_GERMAN} "Desktop Symbol"
LangString TITLE_SecExtensions ${LANG_GERMAN} "Dateiverknüpfungen"
LangString TITLE_SecThemes ${LANG_GERMAN} "Themen"
LangString TITLE_SecSetASDefault ${LANG_GERMAN} "Standard-Browser"
LangString TITLE_SecProtocols ${LANG_GERMAN} "Protokollverknüpfungen"

LangString FILE_Htm ${LANG_GERMAN} "HTM-Datei"
LangString FILE_Html ${LANG_GERMAN} "HTML-Datei"

LangString DESC_SecMain ${LANG_GERMAN} "Hauptkomponenten der Anwendung."
LangString DESC_SecTranslations ${LANG_GERMAN} "Weitere Übersetzungen sind verfügbar. Die Standardsprache ist Englisch."
LangString DESC_SecPlugins ${LANG_GERMAN} "Weitere Plugins stehen zur Verfügung."
LangString DESC_SecDesktop ${LANG_GERMAN} "Starter zum Desktop hinzufügen."
LangString DESC_SecExtensions ${LANG_GERMAN} "Verknüpfe QupZilla mit *.htm(l) Dateien"
LangString DESC_SecThemes ${LANG_GERMAN} "Weitere Themen für QupZilla"
LangString DESC_SecSetASDefault ${LANG_GERMAN} "QupZilla als Standard-Browser verwenden"
LangString DESC_SecProtocols ${LANG_GERMAN} "Verknüpfe QupZilla mit HTTP(S)- und FTP-Protokoll"
;
LangString MSG_RunningInstance ${LANG_GERMAN} "QupZilla ist bereits gestartet! Soll die Installationsroutine versuchen, QupZilla zu beenden?"
LangString MSG_InstallationCanceled ${LANG_GERMAN} "Die Installation wurde vom Benutzer abgebrochen."

;;;;Dutch
LangString TITLE_SecMain ${LANG_DUTCH} "Hoofdonderdelen"
LangString TITLE_SecTranslations ${LANG_DUTCH} "Vertalingen"
LangString TITLE_SecPlugins ${LANG_DUTCH} "Plugins"
LangString TITLE_SecDesktop ${LANG_DUTCH} "Bureaublad-pictogram"
LangString TITLE_SecExtensions ${LANG_DUTCH} "Bestandsassociaties"
LangString TITLE_SecThemes ${LANG_DUTCH} "Thema's"

LangString FILE_Htm ${LANG_DUTCH} "HTM-bestand"
LangString FILE_Html ${LANG_DUTCH} "HTML-bestand"

LangString DESC_SecMain ${LANG_DUTCH} "Hoofdonderdelen van het programma."
LangString DESC_SecTranslations ${LANG_DUTCH} "Beschikbare vertalingen om te installeren. Standaardtaal is Engels."
LangString DESC_SecPlugins ${LANG_DUTCH} "Beschikbare plugins om te installeren."
LangString DESC_SecDesktop ${LANG_DUTCH} "Voeg starter toe op bureaublad."
LangString DESC_SecExtensions ${LANG_DUTCH} "Associeer QupZilla met .htm en .html-bestanden"
LangString DESC_SecThemes ${LANG_DUTCH} "Extra thema's voor QupZilla"

;;;;Portuguese
LangString PRODUCT_DESC  ${LANG_PORTUGUESE} "O QupZilla é um navegador web rápido, seguro e de código livre. O QupZilla está sujeito aos termos da GPL versão 3 ou (por opção) qualquer versão posterior. O QupZilla é baseado nas tecnologias WebKit e Qt."
;
LangString TITLE_SecMain ${LANG_PORTUGUESE} "Principais componentes"
LangString TITLE_SecTranslations ${LANG_PORTUGUESE} "Traduções"
LangString TITLE_SecPlugins ${LANG_PORTUGUESE} "Plugins"
LangString TITLE_SecDesktop ${LANG_PORTUGUESE} "Ícone no ambiente de trabalho"
LangString TITLE_SecExtensions ${LANG_PORTUGUESE} "Associação de ficheiros"
LangString TITLE_SecThemes ${LANG_PORTUGUESE} "Temas"
LangString TITLE_SecSetASDefault ${LANG_PORTUGUESE} "Navegador pré-definido"
LangString TITLE_SecProtocols ${LANG_PORTUGUESE} "Associações"

LangString FILE_Htm ${LANG_PORTUGUESE} "Ficheiro HTM"
LangString FILE_Html ${LANG_PORTUGUESE} "Ficheiro HTML"
;
LangString DESC_SecMain ${LANG_PORTUGUESE} "Principais componentes da aplicação"
LangString DESC_SecTranslations ${LANG_PORTUGUESE} "Outros idiomas disponíveis. O idioma padrão é inglês"
LangString DESC_SecPlugins ${LANG_PORTUGUESE} "Outros plugins disponíveis"
LangString DESC_SecDesktop ${LANG_PORTUGUESE} "Adicionar ícone ao ambiente de trabalho"
LangString DESC_SecExtensions ${LANG_PORTUGUESE} "Associar QupZilla aos ficheiros .htm e .html"
LangString DESC_SecThemes ${LANG_PORTUGUESE} "Temas extra para o QupZilla"
LangString DESC_SecSetASDefault ${LANG_PORTUGUESE} "Definir o QupZilla como navegador web padrão"
LangString DESC_SecProtocols ${LANG_PORTUGUESE} "Associar o QupZilla com os protocolos http e https"
;
LangString MSG_RunningInstance ${LANG_PORTUGUESE} "O QupZilla está em execução! Pretende que o instalador tente terminar o processo?"
LangString MSG_InstallationCanceled ${LANG_PORTUGUESE} "Processo cancelado pelo utilizador"
;
;;;;Greek
LangString TITLE_SecMain ${LANG_GREEK} "Κύρια στοιχεία"
LangString TITLE_SecTranslations ${LANG_GREEK} "Μεταφράσεις"
LangString TITLE_SecPlugins ${LANG_GREEK} "Πρόσθετα"
LangString TITLE_SecDesktop ${LANG_GREEK} "Εικονίδιο επιφάνειας"
LangString TITLE_SecExtensions ${LANG_GREEK} "Συσχετίσεις αρχείων"
LangString TITLE_SecThemes ${LANG_GREEK} "Θέματα"

LangString FILE_Htm ${LANG_GREEK} "Αρχείο HTM"
LangString FILE_Html ${LANG_GREEK} "Αρχείο HTML"

LangString DESC_SecMain ${LANG_GREEK} "Κυρια στοιχεία της εφαρμογής."
LangString DESC_SecTranslations ${LANG_GREEK} "Άλλες μεταφράσεις διαθέσιμες προς εγκατάσταση. Η προεπιλεγμένη είναι Αγγλικά."
LangString DESC_SecPlugins ${LANG_GREEK} "Άλλα πρόσθετα διαθέσιμα προς εγκατάσταση."
LangString DESC_SecDesktop ${LANG_GREEK} "Προσθήκη εκκινητή στην επιφάνεια."
LangString DESC_SecExtensions ${LANG_GREEK} "Συσχέτιση του QupZilla με αρχεία .htm και .html"
LangString DESC_SecThemes ${LANG_GREEK} "Πρόσθετα θέματα για το QupZilla"

;;;;French
LangString PRODUCT_DESC  ${LANG_FRENCH} "QupZilla est un nouveau navigateur Internet, libre, rapide et sûr. QupZilla est sous licence GPLv3 ou (selon votre version) une version plus récente. Il est basé sur WebKit et le framework Qt."

LangString TITLE_SecMain ${LANG_FRENCH} "Composants principaux"
LangString TITLE_SecTranslations ${LANG_FRENCH} "Langues"
LangString TITLE_SecPlugins ${LANG_FRENCH} "Plugins"
LangString TITLE_SecDesktop ${LANG_FRENCH} "Icône de Bureau"
LangString TITLE_SecExtensions ${LANG_FRENCH} "Associations de fichiers"
LangString TITLE_SecThemes ${LANG_FRENCH} "Thèmes"
LangString TITLE_SecSetASDefault ${LANG_FRENCH} "Navigateur par défaut"
LangString TITLE_SecProtocols ${LANG_FRENCH} "Associations de protocoles"

LangString FILE_Htm ${LANG_FRENCH} "Fichiers HTM "
LangString FILE_Html ${LANG_FRENCH} "Fichiers HTML"

LangString DESC_SecMain ${LANG_FRENCH} "Composants principaux de l'application."
LangString DESC_SecTranslations ${LANG_FRENCH} "Autres langues disponibles à l'installation. La langue par défaut est l'anglais."
LangString DESC_SecPlugins ${LANG_FRENCH} "Autres plugins disponibles pour l'installation."
LangString DESC_SecDesktop ${LANG_FRENCH} "Ajouter une icône sur le bureau."
LangString DESC_SecExtensions ${LANG_FRENCH} "Associer QupZilla aux fichiers .htm et .html"
LangString DESC_SecThemes ${LANG_FRENCH} "Thèmes supplémentaires pour QupZilla"
LangString DESC_SecSetASDefault ${LANG_FRENCH} "Utiliser QupZilla comme navigateur par défaut"
LangString DESC_SecProtocols ${LANG_FRENCH} "Associer QupZilla aux protocoles http(s) et ftp"

LangString MSG_RunningInstance ${LANG_FRENCH} "QupZilla est déjà en fonctionnement ! Voulez vous que l'installeur le ferme pour vous ?"
LangString MSG_InstallationCanceled ${LANG_FRENCH} "Processus annulé par l'utilisateur."

;;;;Italian
LangString TITLE_SecMain ${LANG_ITALIAN} "Componenti principali"
LangString TITLE_SecTranslations ${LANG_ITALIAN} "Traduzioni"
LangString TITLE_SecPlugins ${LANG_ITALIAN} "Plugins"
LangString TITLE_SecDesktop ${LANG_ITALIAN} "Icona Desktop"
LangString TITLE_SecExtensions ${LANG_ITALIAN} "Associazione file"
LangString TITLE_SecThemes ${LANG_ITALIAN} "Temi"

LangString FILE_Htm ${LANG_ITALIAN} "File HTM"
LangString FILE_Html ${LANG_ITALIAN} "File HTML"
;
LangString DESC_SecMain ${LANG_ITALIAN} "Componenti principali dell'applicazione."
LangString DESC_SecTranslations ${LANG_ITALIAN} "Altre traduzioni disponibili per l'installazione. Quella predefinita è l'Inglese."
LangString DESC_SecPlugins ${LANG_ITALIAN} "Altri plugins disponibili per l'installazione."
LangString DESC_SecDesktop ${LANG_ITALIAN} "Aggiunge il lanciatore al desktop."
LangString DESC_SecExtensions ${LANG_ITALIAN} "Associa QupZilla ai file .htm and .html"
LangString DESC_SecThemes ${LANG_ITALIAN} "Temi aggiuntivi per QupZilla"

;;;;Romanian
LangString TITLE_SecMain ${LANG_ROMANIAN} "Componente principale"
LangString TITLE_SecTranslations ${LANG_ROMANIAN} "Traduceri"
LangString TITLE_SecPlugins ${LANG_ROMANIAN} "Plugin-uri"
LangString TITLE_SecDesktop ${LANG_ROMANIAN} "Iconiță Desktop"
LangString TITLE_SecExtensions ${LANG_ROMANIAN} "Asocieri fișiere"
LangString TITLE_SecThemes ${LANG_ROMANIAN} "Teme"

LangString FILE_Htm ${LANG_ROMANIAN} "Fișier HTM"
LangString FILE_Html ${LANG_ROMANIAN} "Fișier HTML"
;
LangString DESC_SecMain ${LANG_ROMANIAN} "Componentele principale ale aplicației."
LangString DESC_SecTranslations ${LANG_ROMANIAN} "Alte traduceri disponibile pentru instalare. Predefinită este Engleza."
LangString DESC_SecPlugins ${LANG_ROMANIAN} "Alte plugin-uri sunt disponibile pentru instalare."
LangString DESC_SecDesktop ${LANG_ROMANIAN} "Adaugă scurtătură pe Desktop."
LangString DESC_SecExtensions ${LANG_ROMANIAN} "Asociază QupZilla cu .htm și fișiere .html"
LangString DESC_SecThemes ${LANG_ROMANIAN} "Teme adiționale pentru QupZilla"

;;;;Hongkongese
LangString PRODUCT_DESC  ${LANG_HONGKONG} "QupZilla是一個嶄新、快速、安全和開放原始碼的網頁瀏覽器。QupZilla基於GPL的3或（你意願下的）較新版本釋出授權。QupZilla使用WebKit核心和Qt框架。"
;
LangString TITLE_SecMain ${LANG_HONGKONG} "主要組件"
LangString TITLE_SecTranslations ${LANG_HONGKONG} "語言"
LangString TITLE_SecPlugins ${LANG_HONGKONG} "外掛程式"
LangString TITLE_SecDesktop ${LANG_HONGKONG} "桌面圖示"
LangString TITLE_SecExtensions ${LANG_HONGKONG} "檔案管理"
LangString TITLE_SecThemes ${LANG_HONGKONG} "主題"
LangString TITLE_SecSetASDefault ${LANG_HONGKONG} "預設瀏覽器"
LangString TITLE_SecProtocols ${LANG_HONGKONG} "網絡協定關聯"

LangString FILE_Htm ${LANG_HONGKONG} "HTM檔案"
LangString FILE_Html ${LANG_HONGKONG} "HTML檔案"
;
LangString DESC_SecMain ${LANG_HONGKONG} "程式主要組件。"
LangString DESC_SecTranslations ${LANG_HONGKONG} "可選用的語言，預設為英語。"
LangString DESC_SecPlugins ${LANG_HONGKONG} "可選用的外掛程式。"
LangString DESC_SecDesktop ${LANG_HONGKONG} "建立桌面捷徑。"
LangString DESC_SecExtensions ${LANG_HONGKONG} "預設QupZilla為開啟「.htm」和「.html」檔案的瀏覽器。"
LangString DESC_SecThemes ${LANG_HONGKONG} "其他QupZilla主題。"
LangString DESC_SecSetASDefault ${LANG_HONGKONG} "設定QupZilla為預設瀏覽器。"
LangString DESC_SecProtocols ${LANG_HONGKONG} "關聯QupZilla到http、https和ftp協定。"
;
LangString MSG_RunningInstance ${LANG_HONGKONG} "QupZilla啟用中。是否要求安裝程式代為關閉QupZilla？"
LangString MSG_InstallationCanceled ${LANG_HONGKONG} "用戶主動終止安裝。"

;;;;Traditional Chinese
LangString PRODUCT_DESC  ${LANG_TRADCHINESE} "QupZilla 是一個新穎、快速、安全且開放原始碼的 WWW 瀏覽器。QupZilla 以 GPLv3 或是 (在您的選擇下) 更新的版本釋出。QupZilla 是基於 WebKit 內核及 Qt 框架。"
;
LangString TITLE_SecMain ${LANG_TRADCHINESE} "主要組件"
LangString TITLE_SecTranslations ${LANG_TRADCHINESE} "語言版本"
LangString TITLE_SecPlugins ${LANG_TRADCHINESE} "外掛"
LangString TITLE_SecDesktop ${LANG_TRADCHINESE} "桌面圖示"
LangString TITLE_SecExtensions ${LANG_TRADCHINESE} "檔案管理"
LangString TITLE_SecThemes ${LANG_TRADCHINESE} "主題"
LangString TITLE_SecSetASDefault ${LANG_TRADCHINESE} "預設瀏覽器"
LangString TITLE_SecProtocols ${LANG_TRADCHINESE} "通訊協定關聯"

LangString FILE_Htm ${LANG_TRADCHINESE} "HTM 檔案"
LangString FILE_Html ${LANG_TRADCHINESE} "HTML 檔案"
;
LangString DESC_SecMain ${LANG_TRADCHINESE} "程式主要組件。"
LangString DESC_SecTranslations ${LANG_TRADCHINESE} "可安裝的語言版本，預設是英語。"
LangString DESC_SecPlugins ${LANG_TRADCHINESE} "可安裝的外掛。"
LangString DESC_SecDesktop ${LANG_TRADCHINESE} "在桌面新增啟動圖示。"
LangString DESC_SecExtensions ${LANG_TRADCHINESE} "將 QupZilla 做為預設開啟 .htm 以及 .html 檔案的瀏覽器。"
LangString DESC_SecThemes ${LANG_TRADCHINESE} "額外的 QupZilla 主題。"
LangString DESC_SecSetASDefault ${LANG_TRADCHINESE} "將 QupZilla 做為預設瀏覽器。"
LangString DESC_SecProtocols ${LANG_TRADCHINESE} "關聯 http、https 與 ftp 協定至 QupZilla。"
;
LangString MSG_RunningInstance ${LANG_TRADCHINESE} "正在執行 QupZilla。要求安裝程式嘗試終止它嗎？"
LangString MSG_InstallationCanceled ${LANG_TRADCHINESE} "使用者取消安裝。"

;;;;Simplified Chinese
LangString PRODUCT_DESC  ${LANG_SIMPCHINESE} "QupZilla 是新出、高速、安全的开源 WWW 浏览器。QupZilla 基于 GPL 协议第 3 版或（如果您需要）任何之后的版本。它使用 WebKit 排版引擎。"
;
LangString TITLE_SecMain ${LANG_SIMPCHINESE} "核心部件"
LangString TITLE_SecTranslations ${LANG_SIMPCHINESE} "翻译"
LangString TITLE_SecPlugins ${LANG_SIMPCHINESE} "应用扩展"
LangString TITLE_SecDesktop ${LANG_SIMPCHINESE} "桌面图标"
LangString TITLE_SecExtensions ${LANG_SIMPCHINESE} "文件管理"
LangString TITLE_SecThemes ${LANG_SIMPCHINESE} "皮肤"
LangString TITLE_SecSetASDefault ${LANG_SIMPCHINESE} "默认浏览器"
LangString TITLE_SecProtocols ${LANG_SIMPCHINESE} "关联协议"

LangString FILE_Htm ${LANG_SIMPCHINESE} "HTM 文件"
LangString FILE_Html ${LANG_SIMPCHINESE} "HTML 文件"
;
LangString DESC_SecMain ${LANG_SIMPCHINESE} "程序核心部件。"
LangString DESC_SecTranslations ${LANG_SIMPCHINESE} "可以安装其它翻译，默认为英文。"
LangString DESC_SecPlugins ${LANG_SIMPCHINESE} "可以安装其它应用扩展。"
LangString DESC_SecDesktop ${LANG_SIMPCHINESE} "在桌面新建启动图标。"
LangString DESC_SecExtensions ${LANG_SIMPCHINESE} "将 QupZilla 做为默认打开 .htm 以及 .html 文件的浏览器。"
LangString DESC_SecThemes ${LANG_SIMPCHINESE} "其它的 QupZilla 皮肤。"
LangString DESC_SecSetASDefault ${LANG_SIMPCHINESE} "将 QupZilla 做为默认浏览器。"
LangString DESC_SecProtocols ${LANG_SIMPCHINESE} "关联 http、https 与 ftp 协议至 QupZilla。"
;
LangString MSG_RunningInstance ${LANG_SIMPCHINESE} "正在使用 QupZilla。您希望安装程序试着结束它吗？"
LangString MSG_InstallationCanceled ${LANG_SIMPCHINESE} "用户撤销程序。"

;;;;Bahasa Indonesia
LangString TITLE_SecMain ${LANG_INDONESIAN} "Komponen Utama"
LangString TITLE_SecTranslations ${LANG_INDONESIAN} "Terjemahan"
LangString TITLE_SecPlugins ${LANG_INDONESIAN} "Pengaya"
LangString TITLE_SecDesktop ${LANG_INDONESIAN} "Ikon Desktop"
LangString TITLE_SecExtensions ${LANG_INDONESIAN} "Asosiasi Berkas"
LangString TITLE_SecThemes ${LANG_INDONESIAN} "Tema"

LangString FILE_Htm ${LANG_INDONESIAN} "Berkas HTM"
LangString FILE_Html ${LANG_INDONESIAN} "Berkas HTML"
;
LangString DESC_SecMain ${LANG_INDONESIAN} "Komponen utama dari aplikasi."
LangString DESC_SecTranslations ${LANG_INDONESIAN} "Tersedia terjemahan lain untuk diinstal. Default adalah Bahasa Inggris."
LangString DESC_SecPlugins ${LANG_INDONESIAN} "Tersedia pengaya lain untuk diinstal."
LangString DESC_SecDesktop ${LANG_INDONESIAN} "Tambahkan peluncur ke desktop."
LangString DESC_SecExtensions ${LANG_INDONESIAN} "Asosiasikan QupZilla dengan berkas .htm dan .html"
LangString DESC_SecThemes ${LANG_INDONESIAN} "Tema tambahan untuk QupZilla"

;;;;Georgian
LangString TITLE_SecMain ${LANG_GEORGIAN} "მთავარი კომპონენტები"
LangString TITLE_SecTranslations ${LANG_GEORGIAN} "თარგმანები"
LangString TITLE_SecPlugins ${LANG_GEORGIAN} "მოდულები"
LangString TITLE_SecDesktop ${LANG_GEORGIAN} "სამუშაო მაგიდის ხატულა"
LangString TITLE_SecExtensions ${LANG_GEORGIAN} "ფაილებთან ასოცირება"
LangString TITLE_SecThemes ${LANG_GEORGIAN} "თემები"

LangString FILE_Htm ${LANG_GEORGIAN} "HTM ფაილი"
LangString FILE_Html ${LANG_GEORGIAN} "HTML ფაილი"
;
LangString DESC_SecMain ${LANG_GEORGIAN} "პროგრამის მთავარი კომპონენტები."
LangString DESC_SecTranslations ${LANG_GEORGIAN} "სხვა ენები რომელთა დაყენებაც შესაძლებელია. ნაგულისხმევი არის ინგლისური."
LangString DESC_SecPlugins ${LANG_GEORGIAN} "სხვა მოდულები რომელთა დაყენებაც შესაძლებელია."
LangString DESC_SecDesktop ${LANG_GEORGIAN} "გამშვების დამატება სამუშაო მაგიდაზე."
LangString DESC_SecExtensions ${LANG_GEORGIAN} "QupZilla-ს ასოცირება .htm და .html ფაილებთან"
LangString DESC_SecThemes ${LANG_GEORGIAN} "დამატებითი თემები QupZilla-სთვის"

;;;;Japanese
LangString PRODUCT_DESC ${LANG_JAPANESE} "QupZilla は新しくて、高速で、安全なオープンソース WWW ブラウザです。 QupZilla は GPL version 3 (任意の)それ以降のバージョンでライセンスされています。WebKit コアと Qt Framework ベースで開発されています。"
;
LangString TITLE_SecMain ${LANG_JAPANESE} "メインコンポーネント"
LangString TITLE_SecTranslations ${LANG_JAPANESE} "言語ファイル"
LangString TITLE_SecPlugins ${LANG_JAPANESE} "エクステンション(拡張機能)"
LangString TITLE_SecDesktop ${LANG_JAPANESE} "デスクトップアイコン"
LangString TITLE_SecExtensions ${LANG_JAPANESE} "ファイルの関連付け"
LangString TITLE_SecThemes ${LANG_JAPANESE} "テーマ"
LangString TITLE_SecSetASDefault ${LANG_JAPANESE} "既定のブラウザ"
LangString TITLE_SecProtocols ${LANG_JAPANESE} "プロトコルの関連付け"

LangString FILE_Htm ${LANG_JAPANESE} "HTM ファイル"
LangString FILE_Html ${LANG_JAPANESE} "HTML ファイル"
;
LangString DESC_SecMain ${LANG_JAPANESE} "アプリケーションのメインとなる部分です。"
LangString DESC_SecTranslations ${LANG_JAPANESE} "他の言語でも QupZilla を使えるようになります。デフォルトでは英語です。"
LangString DESC_SecPlugins ${LANG_JAPANESE} "プラグイン(拡張機能)を追加してダウンロードします。"
LangString DESC_SecDesktop ${LANG_JAPANESE} "デスクトップにアイコンを作成します。"
LangString DESC_SecExtensions ${LANG_JAPANESE} "QupZilla に htm, html ファイルを関連付けます。"
LangString DESC_SecThemes ${LANG_JAPANESE} "QupZilla のデフォルトテーマ以外のテーマをダウンロードします。"
LangString DESC_SecSetASDefault ${LANG_JAPANESE} "QupZilla を既定の Web ブラウザに設定する。"
LangString DESC_SecProtocols ${LANG_JAPANESE} "QupZilla を http, https プロトコルに関連付けます。"
;
LangString MSG_RunningInstance ${LANG_JAPANESE} "QupZilla は起動中です！インストーラーによって終了させますか？"
LangString MSG_InstallationCanceled ${LANG_JAPANESE} "プロセスはユーザーによって中止されました。"

;;;;SWEDISH
LangString TITLE_SecMain ${LANG_SWEDISH} "Huvudkomponenter"
LangString DESC_SecMain ${LANG_SWEDISH} "Programmets viktigaste komponenter."
LangString TITLE_SecTranslations ${LANG_SWEDISH} "Översättningar"
LangString DESC_SecTranslations ${LANG_SWEDISH} "Andra översättningar tillgängliga för installation. Förval är Engelska."
LangString TITLE_SecPlugins ${LANG_SWEDISH} "Insticksmoduler"
LangString DESC_SecPlugins ${LANG_SWEDISH} "Andra insticksmoduler tillgängliga för installation."
LangString TITLE_SecDesktop ${LANG_SWEDISH} "Skrivbordsikon"
LangString DESC_SecDesktop ${LANG_SWEDISH} "Lägg till en ikon på skrivbordet."
LangString TITLE_SecExtensions ${LANG_SWEDISH} "Filbindningar"
LangString DESC_SecExtensions ${LANG_SWEDISH} "Associera QupZilla med .htm- och .html-filer"
LangString FILE_Htm ${LANG_SWEDISH} "HTM-fil"
LangString FILE_Html ${LANG_SWEDISH} "HTML-fil"
LangString TITLE_SecThemes ${LANG_SWEDISH} "Teman"
LangString DESC_SecThemes ${LANG_SWEDISH} "Ytterligare teman för QupZilla"

;;;;Polish
LangString TITLE_SecMain ${LANG_POLISH} "Składniki podstawowe"
LangString TITLE_SecTranslations ${LANG_POLISH} "Tłumaczenia"
LangString TITLE_SecPlugins ${LANG_POLISH} "Wtyczki"
LangString TITLE_SecDesktop ${LANG_POLISH} "Ikona pulpitu"
LangString TITLE_SecExtensions ${LANG_POLISH} "Skojarzenia plików"
LangString TITLE_SecThemes ${LANG_POLISH} "Motywy"

LangString FILE_Htm ${LANG_POLISH} "Plik HTM"
LangString FILE_Html ${LANG_POLISH} "Plik HTML"
;
LangString DESC_SecMain ${LANG_POLISH} "Podstawowe składniki programu."
LangString DESC_SecTranslations ${LANG_POLISH} "Instalacja dodatkowych wersji językowych. Domyślnie tylko język angielski."
LangString DESC_SecPlugins ${LANG_POLISH} "Instalacja dodatkowych wtyczek."
LangString DESC_SecDesktop ${LANG_POLISH} "Dodaj skrót do pulpitu."
LangString DESC_SecExtensions ${LANG_POLISH} "Skojarz przeglądarkę QupZilla z plikami .htm i .html"
LangString DESC_SecThemes ${LANG_POLISH} "Dodatkowe motywy dla przeglądarki QupZilla"

LangString MSG_InstallationCanceled ${LANG_POLISH} "Proces anulowany przez użytkownika."
LangString MSG_RunningInstance ${LANG_POLISH} "QupZilla jest już uruchomiona! Chcesz aby instalator spróbował ją wyłączyć?"
LangString DESC_SecProtocols ${LANG_POLISH} "Skojarz QupZille z linkami http(s) i protokołem ftp"
LangString DESC_SecSetASDefault ${LANG_POLISH} "Ustaw QupZille jako domyślną przeglądarke"
LangString TITLE_SecProtocols ${LANG_POLISH} "Protokół Skojarzeń"
LangString TITLE_SecSetASDefault ${LANG_POLISH} "Domyślna Przeglądarka"

LangString PRODUCT_DESC ${LANG_POLISH} "QupZilla jest nową, szybką i bezpieczną zbudowaną na otwartych źródłach przeglądarką . QupZilla podlega licencji GPL wersji 3 lub każdej późniejszej. Bazuje na silniku WebKit oraz Frameworku Qt."

;;;;Ukrainian
LangString TITLE_SecMain ${LANG_UKRAINIAN} "Основні компоненти"
LangString TITLE_SecTranslations ${LANG_UKRAINIAN} "Переклади"
LangString TITLE_SecPlugins ${LANG_UKRAINIAN} "Плаґіни"
LangString TITLE_SecDesktop ${LANG_UKRAINIAN} "Іконка на робочому столі"
LangString TITLE_SecExtensions ${LANG_UKRAINIAN} "Асоціювання файлів"
LangString TITLE_SecThemes ${LANG_UKRAINIAN} "Теми"

LangString FILE_Htm ${LANG_UKRAINIAN} "Файл HTM"
LangString FILE_Html ${LANG_UKRAINIAN} "Файл HTML"
;
LangString DESC_SecMain ${LANG_UKRAINIAN} "Основні компоненти програми."
LangString DESC_SecTranslations ${LANG_UKRAINIAN} "Доступні інші переклади для встановлення. Мова за умовчуванням - англійська."
LangString DESC_SecPlugins ${LANG_UKRAINIAN} "Доступні інші плаґіни для встановлення."
LangString DESC_SecDesktop ${LANG_UKRAINIAN} "Додати посилання на робочий стіл."
LangString DESC_SecExtensions ${LANG_UKRAINIAN} "Асоціювати QupZill'у з файлами .htm і .html"
LangString DESC_SecThemes ${LANG_UKRAINIAN} "Додаткові теми для QupZill'и"

;;;;Persian (Farsi)
LangString PRODUCT_DESC ${LANG_FARSI} "‫کوپزیلا مرورگر اینترنتی متن‌باز، جدید، سریع و ایمنی است. کوپزیلا تحت توافقنامه GPL نسخه ۳ یا هر نسخه جدیدتر آن است. کوپزیلا تحت هسته وب‌کیت و چارچوب کیوت می‌باشد.‬"
;
LangString TITLE_SecMain ${LANG_FARSI} "بخش اصلی"
LangString TITLE_SecTranslations ${LANG_FARSI} "برگردان‌ها"
LangString TITLE_SecPlugins ${LANG_FARSI} "افزونه‌ها"
LangString TITLE_SecDesktop ${LANG_FARSI} "آیکون میزکار"
LangString TITLE_SecExtensions ${LANG_FARSI} "تخصیص فایل"
LangString TITLE_SecThemes ${LANG_FARSI} "فرهشت‌ها"
LangString TITLE_SecSetASDefault ${LANG_FARSI} "مرورگر پیش‌فرض"
LangString TITLE_SecProtocols ${LANG_FARSI} "تخصیص پروتکل"

LangString FILE_Htm ${LANG_FARSI} "HTM File"
LangString FILE_Html ${LANG_FARSI} "HTML File"
;
LangString DESC_SecMain ${LANG_FARSI} "بخش اصلی نرم‌افزار."
LangString DESC_SecTranslations ${LANG_FARSI} "دیگر برگردان‌های دردسترس. پیش فرض انگلیسی است."
LangString DESC_SecPlugins ${LANG_FARSI} "افزونه‌های دیگر که برای نصب در دسترس هستند."
LangString DESC_SecDesktop ${LANG_FARSI} "افزودن میان‌برِ آغازگر به میزکار"
LangString DESC_SecExtensions ${LANG_FARSI} "کوپزیلا را برای بازکردن فایل‌های ‎.htm(l)‎ اختصاص می‌دهد."
LangString DESC_SecThemes ${LANG_FARSI} "فرهشت‌های اضافی برای کوپزیلا"
LangString DESC_SecSetASDefault ${LANG_FARSI} "تنظیم کوپزیلا به عنوان مرورگر پیش‌فرض"
LangString DESC_SecProtocols ${LANG_FARSI} "کوپزیلا را به پروتکل‌های http(s)‎ و ftp  اختصاص می‌دهد."
;
LangString MSG_RunningInstance ${LANG_FARSI} "کوپزیلا هم‌اکنون در حال اجراست! آیا می‌خواهید برنامه نصب تلاش کند به اجرای آن خاتمه دهد؟"
LangString MSG_InstallationCanceled ${LANG_FARSI} "فرایند توسط کاربر لغو گردید."

;;;;Serbian
LangString PRODUCT_DESC  ${LANG_SERBIAN} "Капзила је нови, брз и сигуран веб прегледач отвореног кода. Лиценцирана под ГПЛ в3 лиценцом или (по властитом нахођењу) каснијим издањем те лиценце. Заснована на ВебКит језгри и Кјут програмском окружењу."
;
LangString TITLE_SecMain ${LANG_SERBIAN} "Главне компоненте"
LangString TITLE_SecTranslations ${LANG_SERBIAN} "Преводи"
LangString TITLE_SecPlugins ${LANG_SERBIAN} "Проширења"
LangString TITLE_SecDesktop ${LANG_SERBIAN} "Икона на радној површи"
LangString TITLE_SecExtensions ${LANG_SERBIAN} "Придружења фајлова"
LangString TITLE_SecThemes ${LANG_SERBIAN} "Теме"
LangString TITLE_SecSetASDefault ${LANG_SERBIAN} "Подразумеван прегледач"
LangString TITLE_SecProtocols ${LANG_SERBIAN} "Придружења протокола"

LangString FILE_Htm ${LANG_SERBIAN} "ХТМ фајл"
LangString FILE_Html ${LANG_SERBIAN} "ХТМЛ фајл"
;
LangString DESC_SecMain ${LANG_SERBIAN} "Главне компоненте програма."
LangString DESC_SecTranslations ${LANG_SERBIAN} "Остали доступни преводи. Енглески је подразумеван."
LangString DESC_SecPlugins ${LANG_SERBIAN} "Остала проширења - прикључци."
LangString DESC_SecDesktop ${LANG_SERBIAN} "Покретач програма на радној површи."
LangString DESC_SecExtensions ${LANG_SERBIAN} "Отварај .htm(l) фајлове у Капзили."
LangString DESC_SecThemes ${LANG_SERBIAN} "Додатне теме за Капзилу"
LangString DESC_SecSetASDefault ${LANG_SERBIAN} "Постави Капзилу за подразумевани веб прегледач."
LangString DESC_SecProtocols ${LANG_SERBIAN} "Отварај http(s) и ftp протоколе у Капзили."
;
LangString MSG_RunningInstance ${LANG_SERBIAN} "Капзила је већ покренута! Желите ли да инсталатер покуша да је угаси?"
LangString MSG_InstallationCanceled ${LANG_SERBIAN} "Корисник је отказао процес."

;;;;SerbianLatin
LangString PRODUCT_DESC  ${LANG_SERBIANLATIN} "Kapzila je novi, brz i siguran veb pregledač otvorenog koda. Licencirana pod GPL v3 licencom ili (po vlastitom nahođenju) kasnijim izdanjem te licence. Zasnovana na VebKit jezgri i Kjut programskom okruženju."
;
LangString TITLE_SecMain ${LANG_SERBIANLATIN} "Glavne komponente"
LangString TITLE_SecTranslations ${LANG_SERBIANLATIN} "Prevodi"
LangString TITLE_SecPlugins ${LANG_SERBIANLATIN} "Proširenja"
LangString TITLE_SecDesktop ${LANG_SERBIANLATIN} "Ikona na radnoj površi"
LangString TITLE_SecExtensions ${LANG_SERBIANLATIN} "Pridruženja fajlova"
LangString TITLE_SecThemes ${LANG_SERBIANLATIN} "Teme"
LangString TITLE_SecSetASDefault ${LANG_SERBIANLATIN} "Podrazumevan pregledač"
LangString TITLE_SecProtocols ${LANG_SERBIANLATIN} "Pridruženja protokola"

LangString FILE_Htm ${LANG_SERBIANLATIN} "HTM fajl"
LangString FILE_Html ${LANG_SERBIANLATIN} "HTML fajl"
;
LangString DESC_SecMain ${LANG_SERBIANLATIN} "Glavne komponente programa."
LangString DESC_SecTranslations ${LANG_SERBIANLATIN} "Ostali dostupni prevodi. Engleski je podrazumevan."
LangString DESC_SecPlugins ${LANG_SERBIANLATIN} "Ostala proširenja - priključci."
LangString DESC_SecDesktop ${LANG_SERBIANLATIN} "Pokretač programa na radnoj površi."
LangString DESC_SecExtensions ${LANG_SERBIANLATIN} "Otvaraj .htm(l) fajlove u Kapzili."
LangString DESC_SecThemes ${LANG_SERBIANLATIN} "Dodatne teme za Kapzilu"
LangString DESC_SecSetASDefault ${LANG_SERBIANLATIN} "Postavi Kapzilu za podrazumevani veb pregledač."
LangString DESC_SecProtocols ${LANG_SERBIANLATIN} "Otvaraj http(s) i ftp protokole u Kapzili."
;
LangString MSG_RunningInstance ${LANG_SERBIANLATIN} "Kapzila je već pokrenuta! Želite li da instalater pokuša da je ugasi?"
LangString MSG_InstallationCanceled ${LANG_SERBIANLATIN} "Korisnik je otkazao proces."

;;;;Hebrew
LangString PRODUCT_DESC ${LANG_HEBREW} "QupZilla הינו דפדפן WWW קוד פתוח חדש, מהיר ומאובטח. QupZilla רשוי תחת הרשיון GPL גרסא 3 או (כאופציה השמורה לך) כל גרסא מאוחרת יותר. זה מבוסס על ליבת WebKit ועל Qt Framework."
;
LangString TITLE_SecMain ${LANG_HEBREW} "רכיבים עיקריים"
LangString TITLE_SecTranslations ${LANG_HEBREW} "תרגומים"
LangString TITLE_SecPlugins ${LANG_HEBREW} "תוספות"
LangString TITLE_SecDesktop ${LANG_HEBREW} "סמל שולחן עבודה"
LangString TITLE_SecExtensions ${LANG_HEBREW} "שיוכי קובץ"
LangString TITLE_SecThemes ${LANG_HEBREW} "ערכות נושא"
LangString TITLE_SecSetASDefault ${LANG_HEBREW} "דפדפן ברירת מחדל"
LangString TITLE_SecProtocols ${LANG_HEBREW} "שיוכי פרוטוקול"

LangString FILE_Htm ${LANG_HEBREW} "קובץ HTM"
LangString FILE_Html ${LANG_HEBREW} "קובץ HTML"
;
LangString DESC_SecMain ${LANG_HEBREW} "רכיבים עיקריים של יישום."
LangString DESC_SecTranslations ${LANG_HEBREW} "תרגומים אחרים זמינים להתקנה. ברירת מחדל הינה English."
LangString DESC_SecPlugins ${LANG_HEBREW} "תוספות אחרות זמינות להתקנה."
LangString DESC_SecDesktop ${LANG_HEBREW} "הוסף משגר אל שולחן עבודה."
LangString DESC_SecExtensions ${LANG_HEBREW} "שייך את QupZilla עם קבצי .htm(l)"
LangString DESC_SecThemes ${LANG_HEBREW} "ערכות נושא נוספות עבור QupZilla"
LangString DESC_SecSetASDefault ${LANG_HEBREW} "הגדר את QupZilla כדפדפן אינטרנט ברירת מחדל"
LangString DESC_SecProtocols ${LANG_HEBREW} "שייך את QupZilla עם פרוטוקול http(s) ופרוטוקול ftp"
;
LangString MSG_RunningInstance ${LANG_HEBREW} "QupZilla כבר מורץ כעת! האם ברצונך מהמתקין לנסות לסיימו?"
LangString MSG_InstallationCanceled ${LANG_HEBREW} "תהליך בוטל על ידי משתמש."

;;;;Basque
LangString PRODUCT_DESC  ${LANG_BASQUE} "QupZilla iturburu-irekiko WWW nabigatzaile berri, azkar eta seguru bat da. QupZilla GPL 3 bertsioa baimenpean dago edo (zure aukeran) edozein bertsio berriagoan. WebKit nukleoan eta Qt Framework-ean ohinarrituta dago."
;
LangString TITLE_SecMain ${LANG_BASQUE} "Osagai Nagusiak"
LangString TITLE_SecTranslations ${LANG_BASQUE} "Itzulpenak"
LangString TITLE_SecPlugins ${LANG_BASQUE} "Pluginak"
LangString TITLE_SecDesktop ${LANG_BASQUE} "Mahaigain Ikurra"
LangString TITLE_SecExtensions ${LANG_BASQUE} "Agiri Elkarketa"
LangString TITLE_SecThemes ${LANG_BASQUE} "Azalgaiak"
LangString TITLE_SecSetASDefault ${LANG_BASQUE} "Berezko Nabigatzailea"
LangString TITLE_SecProtocols ${LANG_BASQUE} "Protokolo Elkarketak"

LangString FILE_Htm ${LANG_BASQUE} "HTM Agiria"
LangString FILE_Html ${LANG_BASQUE} "HTML Agiria"
;
LangString DESC_SecMain ${LANG_BASQUE} "Aplikazioaren osagai nagusiak."
LangString DESC_SecTranslations ${LANG_BASQUE} "Ezartzeko eskuragarri dauden beste itzulpenak. Berezkoa Ingelera da."
LangString DESC_SecPlugins ${LANG_BASQUE} "Ezartzeko eskuragarri dauden beste pluginak."
LangString DESC_SecDesktop ${LANG_BASQUE} "Gehitu abiarazlea mahaigainean."
LangString DESC_SecExtensions ${LANG_BASQUE} "Elkartu QupZilla .htm(l) agiriekin"
LangString DESC_SecThemes ${LANG_BASQUE} "QupZilla-rentzako azalgai gehigarriak"
LangString DESC_SecSetASDefault ${LANG_BASQUE} "Ezarri QupZilla berezko internet nabigatzaile bezala"
LangString DESC_SecProtocols ${LANG_BASQUE} "Elkartu QupZilla http(s) eta ftp protokoloekin"
;
LangString MSG_RunningInstance ${LANG_BASQUE} "QupZilla jadanik ekinean dago! Nahi duzu ezartzaileak hura amaitzen saiatzea?"
LangString MSG_InstallationCanceled ${LANG_BASQUE} "Prozesua erabiltzaileak ezeztaturik."

;;;;Danish
LangString PRODUCT_DESC  ${LANG_DANISH} "QupZilla er en ny, hurtig og sikker open source WWW-browser. QupZilla er licenseret under GPL version 3 eller (efter eget valg) en senere version. Den er baseret på WebKit-kerne og Qt-framework."
;
LangString TITLE_SecMain ${LANG_DANISH} "Hovedkomponenter"
LangString TITLE_SecTranslations ${LANG_DANISH} "Oversættelser"
LangString TITLE_SecPlugins ${LANG_DANISH} "Plugins"
LangString TITLE_SecDesktop ${LANG_DANISH} "Skrivebordsikon"
LangString TITLE_SecExtensions ${LANG_DANISH} "Filtilknytninger"
LangString TITLE_SecThemes ${LANG_DANISH} "Temaer"
LangString TITLE_SecSetASDefault ${LANG_DANISH} "Standardbrowser"
LangString TITLE_SecProtocols ${LANG_DANISH} "Protokoltilknytninger"

LangString FILE_Htm ${LANG_DANISH} "HTM-fil"
LangString FILE_Html ${LANG_DANISH} "HTML-fil"
;
LangString DESC_SecMain ${LANG_DANISH} "Programmets hovedkomponenter."
LangString DESC_SecTranslations ${LANG_DANISH} "Andre oversættelser som kan installeres. Engelsk er standard."
LangString DESC_SecPlugins ${LANG_DANISH} "Andre plugins som kan installeres."
LangString DESC_SecDesktop ${LANG_DANISH} "Tilføj genvej på skrivebordet."
LangString DESC_SecExtensions ${LANG_DANISH} "Tilknyt QupZilla med .htm(l)-filer"
LangString DESC_SecThemes ${LANG_DANISH} "Yderligere temaer til QupZilla"
LangString DESC_SecSetASDefault ${LANG_DANISH} "Indstil QupZilla som standardinternetbrowser"
LangString DESC_SecProtocols ${LANG_DANISH} "Tilknyt QupZilla med http(s)- og ftp-protokoller"
;
LangString MSG_RunningInstance ${LANG_DANISH} "QupZilla kører allerede! Vil du have installationsprogrammet til at stoppe den?"
LangString MSG_InstallationCanceled ${LANG_DANISH} "Proces annulleret af bruger."

;;;;;;;;;
;;;;;;;;;
; Unfinished translations
;;;;;;;;;
;;;;;;;;;
LangString PRODUCT_DESC ${LANG_DUTCH} "QupZilla is a new, fast and secure open-source WWW browser. QupZilla is licensed under GPL version 3 or (at your option) any later version. It is based on WebKit core and Qt Framework."
LangString PRODUCT_DESC ${LANG_GREEK} "QupZilla is a new, fast and secure open-source WWW browser. QupZilla is licensed under GPL version 3 or (at your option) any later version. It is based on WebKit core and Qt Framework."
LangString PRODUCT_DESC ${LANG_ITALIAN} "QupZilla is a new, fast and secure open-source WWW browser. QupZilla is licensed under GPL version 3 or (at your option) any later version. It is based on WebKit core and Qt Framework."
LangString PRODUCT_DESC ${LANG_ROMANIAN} "QupZilla is a new, fast and secure open-source WWW browser. QupZilla is licensed under GPL version 3 or (at your option) any later version. It is based on WebKit core and Qt Framework."
LangString PRODUCT_DESC ${LANG_INDONESIAN} "QupZilla is a new, fast and secure open-source WWW browser. QupZilla is licensed under GPL version 3 or (at your option) any later version. It is based on WebKit core and Qt Framework."
LangString PRODUCT_DESC ${LANG_GEORGIAN} "QupZilla is a new, fast and secure open-source WWW browser. QupZilla is licensed under GPL version 3 or (at your option) any later version. It is based on WebKit core and Qt Framework."
LangString PRODUCT_DESC ${LANG_SWEDISH} "QupZilla is a new, fast and secure open-source WWW browser. QupZilla is licensed under GPL version 3 or (at your option) any later version. It is based on WebKit core and Qt Framework."
LangString PRODUCT_DESC ${LANG_UKRAINIAN} "QupZilla is a new, fast and secure open-source WWW browser. QupZilla is licensed under GPL version 3 or (at your option) any later version. It is based on WebKit core and Qt Framework."

LangString TITLE_SecSetASDefault ${LANG_DUTCH} "Default Browser"
LangString TITLE_SecSetASDefault ${LANG_GREEK} "Default Browser"
LangString TITLE_SecSetASDefault ${LANG_ITALIAN} "Default Browser"
LangString TITLE_SecSetASDefault ${LANG_ROMANIAN} "Default Browser"
LangString TITLE_SecSetASDefault ${LANG_INDONESIAN} "Default Browser"
LangString TITLE_SecSetASDefault ${LANG_GEORGIAN} "Default Browser"
LangString TITLE_SecSetASDefault ${LANG_SWEDISH} "Default Browser"
LangString TITLE_SecSetASDefault ${LANG_UKRAINIAN} "Default Browser"

LangString TITLE_SecProtocols ${LANG_DUTCH} "Protocol Associations"
LangString TITLE_SecProtocols ${LANG_GREEK} "Protocol Associations"
LangString TITLE_SecProtocols ${LANG_ITALIAN} "Protocol Associations"
LangString TITLE_SecProtocols ${LANG_ROMANIAN} "Protocol Associations"
LangString TITLE_SecProtocols ${LANG_INDONESIAN} "Protocol Associations"
LangString TITLE_SecProtocols ${LANG_GEORGIAN} "Protocol Associations"
LangString TITLE_SecProtocols ${LANG_SWEDISH} "Protocol Associations"
LangString TITLE_SecProtocols ${LANG_UKRAINIAN} "Protocol Associations"

LangString DESC_SecSetASDefault ${LANG_DUTCH} "Set QupZilla as default internet browser"
LangString DESC_SecSetASDefault ${LANG_GREEK} "Set QupZilla as default internet browser"
LangString DESC_SecSetASDefault ${LANG_ITALIAN} "Set QupZilla as default internet browser"
LangString DESC_SecSetASDefault ${LANG_ROMANIAN} "Set QupZilla as default internet browser"
LangString DESC_SecSetASDefault ${LANG_INDONESIAN} "Set QupZilla as default internet browser"
LangString DESC_SecSetASDefault ${LANG_GEORGIAN} "Set QupZilla as default internet browser"
LangString DESC_SecSetASDefault ${LANG_SWEDISH} "Set QupZilla as default internet browser"
LangString DESC_SecSetASDefault ${LANG_UKRAINIAN} "Set QupZilla as default internet browser"

LangString DESC_SecProtocols ${LANG_DUTCH} "Associate QupZilla with http(s) and ftp protocols"
LangString DESC_SecProtocols ${LANG_GREEK} "Associate QupZilla with http(s) and ftp protocols"
LangString DESC_SecProtocols ${LANG_ITALIAN} "Associate QupZilla with http(s) and ftp protocols"
LangString DESC_SecProtocols ${LANG_ROMANIAN} "Associate QupZilla with http(s) and ftp protocols"
LangString DESC_SecProtocols ${LANG_INDONESIAN} "Associate QupZilla with http(s) and ftp protocols"
LangString DESC_SecProtocols ${LANG_GEORGIAN} "Associate QupZilla with http(s) and ftp protocols"
LangString DESC_SecProtocols ${LANG_SWEDISH} "Associate QupZilla with http(s) and ftp protocols"
LangString DESC_SecProtocols ${LANG_UKRAINIAN} "Associate QupZilla with http(s) and ftp protocols"

LangString MSG_RunningInstance ${LANG_DUTCH} "QupZilla is already running! Do you want the installer try to terminate it?"
LangString MSG_RunningInstance ${LANG_GREEK} "QupZilla is already running! Do you want the installer try to terminate it?"
LangString MSG_RunningInstance ${LANG_ITALIAN} "QupZilla is already running! Do you want the installer try to terminate it?"
LangString MSG_RunningInstance ${LANG_ROMANIAN} "QupZilla is already running! Do you want the installer try to terminate it?"
LangString MSG_RunningInstance ${LANG_INDONESIAN} "QupZilla is already running! Do you want the installer try to terminate it?"
LangString MSG_RunningInstance ${LANG_GEORGIAN} "QupZilla is already running! Do you want the installer try to terminate it?"
LangString MSG_RunningInstance ${LANG_SWEDISH} "QupZilla is already running! Do you want the installer try to terminate it?"
LangString MSG_RunningInstance ${LANG_UKRAINIAN} "QupZilla is already running! Do you want the installer try to terminate it?"

LangString MSG_InstallationCanceled ${LANG_DUTCH} "Process cancelled by user."
LangString MSG_InstallationCanceled ${LANG_GREEK} "Process cancelled by user."
LangString MSG_InstallationCanceled ${LANG_ITALIAN} "Process cancelled by user."
LangString MSG_InstallationCanceled ${LANG_ROMANIAN} "Process cancelled by user."
LangString MSG_InstallationCanceled ${LANG_INDONESIAN} "Process cancelled by user."
LangString MSG_InstallationCanceled ${LANG_GEORGIAN} "Process cancelled by user."
LangString MSG_InstallationCanceled ${LANG_SWEDISH} "Process cancelled by user."
LangString MSG_InstallationCanceled ${LANG_UKRAINIAN} "Process cancelled by user."
