Changes for QuantLib 1.35:
==========================

QuantLib 1.35 includes 32 pull requests from several contributors.

Some of the most notable changes are included below.
A detailed list of changes is available in ChangeLog.txt and at
<https://github.com/lballabio/QuantLib/milestone/33?closed=1>.


Portability
-----------

- **Future end of support:** as announced since release 1.32, this
  release is the last to support Visual C++ 2015, g++ up to version
  6.x, and clang up to version 4; support for those compilers will be
  dropped in next release, 1.36, about three months from now.  From
  that point onwards, this will allows us to enable the use of C++17
  in the code base.  Also, given the testing environments available on
  GitHub actions, clang 5 and 6 are no longer available to us for
  testing, and the same holds for g++ 7.  Therefore, it is suggested
  to upgrade to a newer version if possible.

- **Future end of support:** at the same time as the above, we'll also
  remove the configure switch that allows to use `boost::tuple`,
  `boost::function` and `boost::bind` instead of their `std`
  counterparts; the `std` classes are already the default since
  release 1.32.

- The `config.hpp` generated by cmake now behaves like the one
  generated by autotools and provides values for the defines so that
  they can be used in `static_assert` (@lballabio).  Thanks to Tom
  Anderson (@tomwhoiscontrary) for the heads-up.


Calendars
---------

- Some fixes for the Chilean calendar; thanks to Eugene Toder
  (@eltoder).

- Better NFP/SIFMA rule for Good Friday in U.S. government bond
  calendar; thanks to Eugene Toder (@eltoder).

- Updated Indian NSE holidays for 2024; thanks to Fredrik Gerdin
  Börjesson (@gbfredrik).

- Some fixes for the Mexican calendar; thanks to Lucas Dias (@lukedays).


Cash flows
----------

- Added lookback days, lockout days and observation shift to
  overnight-indexed coupons; thanks to Marcin Rybacki
  (@marcin-rybacki).  The same parameters were propagated to
  overnight-indexed swaps and to the corresponding helpers.

- Added the `hasFixed` method to IBOR coupons that detects whether
  they have fixed or still need to be forecast; thanks to Tom Anderson
  (@tomwhoiscontrary).


Instruments
-----------

- Overnight index futures didn't manage a start date falling on a
  holiday; this is now fixed (@lballabio).  Thanks to GitHub user
  @JustCallMeDavid for the heads-up.

- Callable bonds didn't account for nominal when calculating OAS; this
  is now fixed.  Thanks to Hristo Raykov (@HristoRaykov).

- For European swaption, sometimes the price is quoted as a forward
  price to be paid at exercise time.  Such a quoted price can now be
  used for implied-volatility calculation. The forward price is also
  returned by the Black and Bachelier swaption engines as an
  additional result (@lballabio).


Random numbers
--------------

- Added the fast `ZigguratGaussianRng` generator; thanks to Ralf
  Konrad Eckel (@ralfkonrad).


Term structures
---------------

- Fix treatment of custom end date in `FuturesRateHelper` (@lballabio).

- Add possibility to reset guess in fitted bond curves (@lballabio).
  Thanks to GitHub user @klin333 for the suggestion.


Utilities
---------

- Overloaded `Handle` and `RelinkableHandle` constructors on lvalue
  and rvalue references for performance; thanks to Jonathan Sweemer
  (@sweemer).


Tools
-----

- Better benchmark utility; thanks to Jacques du Toit (@amd-jadutoit).


Examples
--------

- Reworked bond example (@lballabio).


Deprecated features
-------------------

- **Removed** features deprecated in version 1.30:
  - the `DividendVanillaOption` and `DividendBarrierOption` classes;
  - the constructor of `AnalyticDividendEuropeanEngine` taking only a
    process and no dividends;
  - the `SwaptionVolCube1`, `SwaptionVolCube1a`, `SwaptionVolCube1x`
    and `SwaptionVolCube2` typedefs and the empty headers
    `ql/experimental/volatility/swaptionvolcube1.hpp`,
    `ql/experimental/volatility/swaptionvolcube1a.hpp` and
    `ql/experimental/volatility/swaptionvolcube2.hpp`;
  - the `setCommon` method of `CappedFlooredYoYInflationCoupon`.

- Deprecated the constructor of `DatedOISRateHelper` taking a forward
  start; use the other overload instead.

- Deprecated the specialized `Bibor9M`, `Euribor2W`, `Euribor3W`,
  `Euribor2M`, `Euribor4M`, `Euribor5M`, `Euribor7M`, `Euribor8M`,
  `Euribor9M`, `Euribor10M`, `Euribor11M`, `Euribor365_SW`,
  `Euribor365_2W`, `Euribor365_3W`, `Euribor365_1M`, `Euribor365_2M`,
  `Euribor365_3M`, `Euribor365_4M`, `Euribor365_5M`, `Euribor365_6M`,
  `Euribor365_7M`, `Euribor365_8M`, `Euribor365_9M`, `Euribor365_10M`,
  `Euribor365_11M`, `Euribor365_1Y`, `EURLiborSW`, `EURLibor2W`,
  `EURLibor2M`, `EURLibor4M`, `EURLibor5M`, `EURLibor7M`,
  `EURLibor8M`, `EURLibor9M`, `EURLibor10M`, `EURLibor11M`; if needed,
  use the corresponding generic class and pass the tenor (for
  instance, `Euribor(4 * Months)`).

- Renamed `EuriborSW` to `Euribor1W` and deprecated the old name.

- Deprecated the constructor of `RelinkableHandle` taking a raw
  pointer.


**Thanks go also** to Dmitri Goloubentsev (@DmitriGoloubentsev),
 Eleanor Green (@eleanorTurintech), Tom Anderson (@tomwhoiscontrary),
 Peter Caspers (@pcaspers), Jonghee Lee (@nistick21), Ralf Konrad
 Eckel (@ralfkonrad) and the XAD team (@auto-differentiation-dev) for
 miscellaneous fixes, improvements or reports.
