/*
    ApplicationProjectType.h

    Interface declaration of the ApplicationProjectType class for the
    ProjectManager application.

    Copyright (C) 2005, 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>
#import "../../ProjectType.h"

#import "../../ProjectModules/MakeBuilder/MakeBuilderDelegate.h"
#import "../../ProjectModules/GNUstepAppLauncher/GNUstepAppLauncherDelegate.h"
#import "../../ProjectModules/FileManager/FileManagerDelegate.h"
#import "../../ProjectModules/ProjectAttributes/ProjectAttributesDelegate.h"
#import "../../ProjectModules/SubprojectsManager/SubprojectsManagerDelegate.h"

@class NSString,
       NSDictionary,
       NSArray,
       NSMutableArray,
       NSNotification;

@class ProjectDocument,
       FileManager,
       MakeBuilder,
       GNUstepAppLauncher;

@class ApplicationGeneralAttributes,
       ApplicationTypeAttributes;

@interface ApplicationProjectType : NSObject <ProjectType,
                                              ProjectAttributesDelegate,
                                              FileManagerDelegate,
                                              MakeBuilderDelegate,
                                              GNUstepAppLauncherDelegate,
                                              SubprojectsManagerDelegate>
{
  // weak reference
  ProjectDocument * owner;

  NSString * appName;
  NSString * mainNibFile;
  NSString * principalClass;
  NSArray  * authors;
  NSString * appRelease;
  NSString * appDescription;
  NSString * copyright;
  NSString * copyrightDescription;
  NSString * iconName;

  NSMutableArray * types;

  ApplicationGeneralAttributes * generalAttributes;
  ApplicationTypeAttributes * typeAttributes;

  FileManager * fileManager;
  MakeBuilder * builder;
  GNUstepAppLauncher * launcher;

  // YES while we're delaying a launch until a build is complete, NO
  // in the case of a normal build
  BOOL waitingForBuildCompletion;

  unsigned int oldMakeHash;
}

- (void) setApplicationName: (NSString *) aName;
- (NSString *) applicationName;

- (void) setMainNibFile: (NSString *) aFile;
- (NSString *) mainNibFile;

- (void) setPrincipalClass: (NSString *) aClass;
- (NSString *) principalClass;

- (void) setAuthors: (NSArray *) anArray;
- (NSArray *) authors;

- (void) setApplicationRelease: (NSString *) aRelease;
- (NSString *) applicationRelease;

- (void) setApplicationDescription: (NSString *) aDescription;
- (NSString *) applicationDescription;

- (void) setCopyright: (NSString *) aCopyright;
- (NSString *) copyright;

- (void) setCopyrightDescription: (NSString *) aCopyrightDescription;
- (NSString *) copyrightDescription;

- (void) setIconName: (NSString *) iconName;
- (NSString *) iconName;

- (void) buildEnded: (NSNotification *) notif;

@end
