/*
    ProjectDocument.h

    Interface declaration of the ProjectDocument class for the
    ProjectManager application.

    Copyright (C) 2005, 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <AppKit/NSDocument.h>

@class NSString,
       NSArray,
       NSMutableArray,
       NSMutableDictionary,
       NSError;

@class ProjectWindowController;

@protocol ProjectType, ProjectModule;

extern NSString * const ProjectNameDidChangeNotification;

extern NSString * const ProjectDocumentErrorDomain;
enum {
  ProjectNameInvalidError
};

@interface ProjectDocument : NSDocument
{
  NSString * projectDirectory;
  NSString * projectName;
  NSString * projectTypeID;
  id <ProjectType> projectType;

  NSArray * projectModules;

  /**
   * An array of menu items of project modules which are to appear
   * in the Modules menu.
   */
  NSArray * moduleMenuEntries;

  ProjectWindowController * wc;
}

+ (BOOL) validateProjectName: (NSString *) aProjectName
                       error: (NSError **) error;

- (NSArray *) projectMenuEntries;

- (NSString *) projectName;
- (void) setProjectName: (NSString *) aName;

- (NSString *) projectDirectory;
- (void) setProjectName: (NSString *) projectName;

- (NSString *) projectTypeID;
- (id <ProjectType>) projectType;

- (NSArray *) projectModules;
- (id <ProjectModule>) projectModuleWithName: (NSString *) moduleName;

- (void) setCurrentProjectModule: (id <ProjectModule>) aModule;
- (id <ProjectModule>) currentProjectModule;

- (BOOL) openFile: (NSString *) aPath inCodeEditorOnLine: (int) aLine;

- (void) logMessage: (NSString *) aMessage;

@end
