/*
    EditorGuide.h

    Interface declaration of the EditorGuide class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>
#import <Foundation/NSGeometry.h>

typedef enum {
  DottedGuideStyle,     // default style
  DashedGuideStyle,     // dashed with dashes of length 5 and skips of length 4
  SolidGuideStyle,      // solid colored line
  AnyGuideStyle         // use the user-preferred style
} EditorGuideStyle;

@class NSColor;

@interface EditorGuide : NSObject
{
  float offset;
  BOOL isHorizontal;
  BOOL isSelected;

  EditorGuideStyle style;
  NSColor * color, * selectedColor;
}

- (void) drawRect: (NSRect) r;

- (void) setOffset: (float) anOffset;
- (float) offset;

- (void) setHorizontal: (BOOL) flag;
- (BOOL) isHorizontal;

- (void) setSelected: (BOOL) flag;
- (BOOL) isSelected;

- (void) setGuideStyle: (EditorGuideStyle) aStyle;
- (EditorGuideStyle) guideStyle;

- (void) setColor: (NSColor *) aColor;
- (NSColor *) color;

@end
