/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.internal.ui.common.JRichTooltipPanel;
import org.pushingpixels.flamingo.internal.ui.common.RichTooltipPanelUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class BasicRichTooltipPanelUI
extends RichTooltipPanelUI {
    protected JRichTooltipPanel richTooltipPanel;
    protected List<JLabel> titleLabels = new ArrayList<JLabel>();
    protected List<JLabel> descriptionLabels = new ArrayList<JLabel>();
    protected JLabel mainImageLabel;
    protected JSeparator footerSeparator;
    protected JLabel footerImageLabel;
    protected List<JLabel> footerLabels = new ArrayList<JLabel>();

    public static ComponentUI createUI(JComponent c) {
        return new BasicRichTooltipPanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.richTooltipPanel = (JRichTooltipPanel)c;
        super.installUI(this.richTooltipPanel);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.richTooltipPanel.setLayout(this.createLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(this.richTooltipPanel);
    }

    protected void installDefaults() {
        Border b = this.richTooltipPanel.getBorder();
        if (b == null || b instanceof UIResource) {
            Border toSet = UIManager.getBorder("RichTooltipPanel.border");
            if (toSet == null) {
                toSet = new BorderUIResource.CompoundBorderUIResource(new LineBorder(FlamingoUtilities.getBorderColor()), new EmptyBorder(2, 4, 3, 4));
            }
            this.richTooltipPanel.setBorder(toSet);
        }
        LookAndFeel.installProperty(this.richTooltipPanel, "opaque", Boolean.TRUE);
    }

    protected void installListeners() {
    }

    protected void installComponents() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.richTooltipPanel);
    }

    protected void uninstallListeners() {
    }

    protected void uninstallComponents() {
        this.removeExistingComponents();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paintBackground(g);
        this.paint(g, c);
    }

    protected void paintBackground(Graphics g) {
        Color main = FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground").brighter();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getLighterColor(main, 0.9), 0.0f, this.richTooltipPanel.getHeight(), FlamingoUtilities.getLighterColor(main, 0.4)));
        g2d.fillRect(0, 0, this.richTooltipPanel.getWidth(), this.richTooltipPanel.getHeight());
        g2d.setFont(FlamingoUtilities.getFont(this.richTooltipPanel, "Ribbon.font", "Button.font", "Panel.font"));
        g2d.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
    }

    protected LayoutManager createLayoutManager() {
        return new RichTooltipPanelLayout();
    }

    protected int getDescriptionTextWidth() {
        return 200;
    }

    protected int getLayoutGap() {
        return 4;
    }

    protected void removeExistingComponents() {
        for (JLabel label : this.titleLabels) {
            this.richTooltipPanel.remove(label);
        }
        if (this.mainImageLabel != null) {
            this.richTooltipPanel.remove(this.mainImageLabel);
        }
        for (JLabel label : this.descriptionLabels) {
            this.richTooltipPanel.remove(label);
        }
        if (this.footerSeparator != null) {
            this.richTooltipPanel.remove(this.footerSeparator);
        }
        if (this.footerImageLabel != null) {
            this.richTooltipPanel.remove(this.footerImageLabel);
        }
        for (JLabel label : this.footerLabels) {
            this.richTooltipPanel.remove(label);
        }
    }

    protected class RichTooltipPanelLayout
    implements LayoutManager {
        protected RichTooltipPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            TextLayout tl;
            Insets ins = parent.getInsets();
            int gap = BasicRichTooltipPanelUI.this.getLayoutGap();
            FontUIResource font = FlamingoUtilities.getFont(parent, "Ribbon.font", "Button.font", "Panel.font");
            Font titleFont = font.deriveFont(1);
            int descTextWidth = BasicRichTooltipPanelUI.this.getDescriptionTextWidth();
            int width = ins.left + 2 * gap + descTextWidth + ins.right;
            RichTooltip tooltipInfo = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipInfo();
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, false);
            if (tooltipInfo.getMainImage() != null) {
                width += tooltipInfo.getMainImage().getWidth(null);
            }
            int fontHeight = parent.getFontMetrics(font).getHeight();
            int height = ins.top;
            int titleTextHeight = 0;
            AttributedString titleAttributedDescription = new AttributedString(tooltipInfo.getTitle());
            titleAttributedDescription.addAttribute(TextAttribute.FONT, titleFont);
            LineBreakMeasurer titleLineBreakMeasurer = new LineBreakMeasurer(titleAttributedDescription.getIterator(), frc);
            int maxTitleLineWidth = 0;
            while ((tl = titleLineBreakMeasurer.nextLayout(descTextWidth)) != null) {
                titleTextHeight += fontHeight;
                int lineWidth = (int)Math.ceil(tl.getBounds().getWidth());
                maxTitleLineWidth = Math.max(maxTitleLineWidth, lineWidth);
            }
            height += titleTextHeight;
            int descriptionTextHeight = 0;
            for (String descText : tooltipInfo.getDescriptionSections()) {
                TextLayout tl2;
                AttributedString descAttributedDescription = new AttributedString(descText);
                descAttributedDescription.addAttribute(TextAttribute.FONT, font);
                LineBreakMeasurer descLineBreakMeasurer = new LineBreakMeasurer(descAttributedDescription.getIterator(), frc);
                while ((tl2 = descLineBreakMeasurer.nextLayout(descTextWidth)) != null) {
                    descriptionTextHeight += fontHeight;
                }
                descriptionTextHeight += fontHeight;
            }
            if (!tooltipInfo.getDescriptionSections().isEmpty()) {
                descriptionTextHeight -= fontHeight;
                descriptionTextHeight += gap;
            }
            height = tooltipInfo.getMainImage() != null ? (height += Math.max(descriptionTextHeight, new JLabel((Icon)new ImageIcon((Image)tooltipInfo.getMainImage())).getPreferredSize().height)) : (height += descriptionTextHeight);
            if (tooltipInfo.getFooterImage() != null || tooltipInfo.getFooterSections().size() > 0) {
                height += gap;
                height += new JSeparator((int)0).getPreferredSize().height;
                height += gap;
                int footerTextHeight = 0;
                int availableWidth = descTextWidth;
                if (tooltipInfo.getFooterImage() != null) {
                    availableWidth -= tooltipInfo.getFooterImage().getWidth(null);
                }
                if (tooltipInfo.getMainImage() != null) {
                    availableWidth += tooltipInfo.getMainImage().getWidth(null);
                }
                for (String footerText : tooltipInfo.getFooterSections()) {
                    TextLayout tl3;
                    AttributedString footerAttributedDescription = new AttributedString(footerText);
                    footerAttributedDescription.addAttribute(TextAttribute.FONT, font);
                    LineBreakMeasurer footerLineBreakMeasurer = new LineBreakMeasurer(footerAttributedDescription.getIterator(), frc);
                    while ((tl3 = footerLineBreakMeasurer.nextLayout(availableWidth)) != null) {
                        footerTextHeight += fontHeight;
                    }
                    footerTextHeight += fontHeight;
                }
                height = tooltipInfo.getFooterImage() != null ? (height += Math.max(footerTextHeight, new JLabel((Icon)new ImageIcon((Image)tooltipInfo.getFooterImage())).getPreferredSize().height)) : (height += (footerTextHeight -= fontHeight));
            }
            height += ins.bottom;
            if (tooltipInfo.getDescriptionSections().isEmpty() && tooltipInfo.getMainImage() == null && tooltipInfo.getFooterSections().isEmpty() && tooltipInfo.getFooterImage() == null) {
                width = maxTitleLineWidth + 1 + ins.left + ins.right;
            }
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            int x;
            TextLayout tl;
            BasicRichTooltipPanelUI.this.removeExistingComponents();
            FontUIResource font = FlamingoUtilities.getFont(parent, "Ribbon.font", "Button.font", "Panel.font");
            Insets ins = BasicRichTooltipPanelUI.this.richTooltipPanel.getInsets();
            int y = ins.top;
            RichTooltip tooltipInfo = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipInfo();
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, false);
            int gap = BasicRichTooltipPanelUI.this.getLayoutGap();
            int fontHeight = parent.getFontMetrics(font).getHeight();
            Font titleFont = font.deriveFont(1);
            boolean ltr = BasicRichTooltipPanelUI.this.richTooltipPanel.getComponentOrientation().isLeftToRight();
            int titleLabelWidth = parent.getWidth() - ins.left - ins.right;
            AttributedString titleAtributedDescription = new AttributedString(tooltipInfo.getTitle());
            titleAtributedDescription.addAttribute(TextAttribute.FONT, titleFont);
            LineBreakMeasurer titleLineBreakMeasurer = new LineBreakMeasurer(titleAtributedDescription.getIterator(), frc);
            int titleCurrOffset = 0;
            while ((tl = titleLineBreakMeasurer.nextLayout(titleLabelWidth)) != null) {
                int charCount = tl.getCharacterCount();
                String line = tooltipInfo.getTitle().substring(titleCurrOffset, titleCurrOffset + charCount);
                JLabel titleLabel = new JLabel(line);
                titleLabel.setFont(titleFont);
                BasicRichTooltipPanelUI.this.titleLabels.add(titleLabel);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(titleLabel);
                int currLabelWidth = titleLabel.getPreferredSize().width;
                if (ltr) {
                    titleLabel.setBounds(ins.left, y, currLabelWidth, fontHeight);
                } else {
                    titleLabel.setBounds(parent.getWidth() - ins.right - currLabelWidth, y, currLabelWidth, fontHeight);
                }
                y += titleLabel.getHeight();
                titleCurrOffset += charCount;
            }
            y += gap;
            int n = x = ltr ? ins.left : parent.getWidth() - ins.right;
            if (tooltipInfo.getMainImage() != null) {
                BasicRichTooltipPanelUI.this.mainImageLabel = new JLabel(new ImageIcon(tooltipInfo.getMainImage()));
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.mainImageLabel);
                int mainImageWidth = BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().width;
                if (ltr) {
                    BasicRichTooltipPanelUI.this.mainImageLabel.setBounds(x, y, mainImageWidth, BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().height);
                    x += mainImageWidth;
                } else {
                    BasicRichTooltipPanelUI.this.mainImageLabel.setBounds(x - mainImageWidth, y, mainImageWidth, BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().height);
                    x -= mainImageWidth;
                }
            }
            x = ltr ? (x += 2 * gap) : (x -= 2 * gap);
            int descLabelWidth = ltr ? parent.getWidth() - x - ins.right : x - ins.left;
            for (String descText : tooltipInfo.getDescriptionSections()) {
                TextLayout tl2;
                AttributedString attributedDescription = new AttributedString(descText);
                attributedDescription.addAttribute(TextAttribute.FONT, font);
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), frc);
                int currOffset = 0;
                while ((tl2 = lineBreakMeasurer.nextLayout(descLabelWidth)) != null) {
                    int charCount = tl2.getCharacterCount();
                    String line = descText.substring(currOffset, currOffset + charCount);
                    JLabel descLabel = new JLabel(line);
                    BasicRichTooltipPanelUI.this.descriptionLabels.add(descLabel);
                    BasicRichTooltipPanelUI.this.richTooltipPanel.add(descLabel);
                    int currDescWidth = descLabel.getPreferredSize().width;
                    if (ltr) {
                        descLabel.setBounds(x, y, currDescWidth, fontHeight);
                    } else {
                        descLabel.setBounds(x - currDescWidth, y, currDescWidth, fontHeight);
                    }
                    y += descLabel.getHeight();
                    currOffset += charCount;
                }
                y += fontHeight;
            }
            y -= fontHeight;
            if (BasicRichTooltipPanelUI.this.mainImageLabel != null) {
                y = Math.max(y, BasicRichTooltipPanelUI.this.mainImageLabel.getY() + BasicRichTooltipPanelUI.this.mainImageLabel.getHeight());
            }
            if (tooltipInfo.getFooterImage() != null || tooltipInfo.getFooterSections().size() > 0) {
                BasicRichTooltipPanelUI.this.footerSeparator = new JSeparator(0);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.footerSeparator);
                BasicRichTooltipPanelUI.this.footerSeparator.setBounds(ins.left, y += gap, parent.getWidth() - ins.left - ins.right, BasicRichTooltipPanelUI.this.footerSeparator.getPreferredSize().height);
                y += BasicRichTooltipPanelUI.this.footerSeparator.getHeight() + gap;
                int n2 = x = ltr ? ins.left : parent.getWidth() - ins.right;
                if (tooltipInfo.getFooterImage() != null) {
                    BasicRichTooltipPanelUI.this.footerImageLabel = new JLabel(new ImageIcon(tooltipInfo.getFooterImage()));
                    BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.footerImageLabel);
                    int footerImageWidth = BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().width;
                    if (ltr) {
                        BasicRichTooltipPanelUI.this.footerImageLabel.setBounds(x, y, footerImageWidth, BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().height);
                        x += footerImageWidth + 2 * gap;
                    } else {
                        BasicRichTooltipPanelUI.this.footerImageLabel.setBounds(x - footerImageWidth, y, footerImageWidth, BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().height);
                        x -= footerImageWidth + 2 * gap;
                    }
                }
                int footerLabelWidth = ltr ? parent.getWidth() - x - ins.right : x - ins.left;
                for (String footerText : tooltipInfo.getFooterSections()) {
                    TextLayout tl3;
                    AttributedString attributedDescription = new AttributedString(footerText);
                    attributedDescription.addAttribute(TextAttribute.FONT, font);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), frc);
                    int currOffset = 0;
                    while ((tl3 = lineBreakMeasurer.nextLayout(footerLabelWidth)) != null) {
                        int charCount = tl3.getCharacterCount();
                        String line = footerText.substring(currOffset, currOffset + charCount);
                        JLabel footerLabel = new JLabel(line);
                        BasicRichTooltipPanelUI.this.footerLabels.add(footerLabel);
                        BasicRichTooltipPanelUI.this.richTooltipPanel.add(footerLabel);
                        int currLabelWidth = footerLabel.getPreferredSize().width;
                        if (ltr) {
                            footerLabel.setBounds(x, y, currLabelWidth, fontHeight);
                        } else {
                            footerLabel.setBounds(x - currLabelWidth, y, currLabelWidth, fontHeight);
                        }
                        y += footerLabel.getHeight();
                        currOffset += charCount;
                    }
                    y += fontHeight;
                }
                y -= fontHeight;
            }
        }
    }
}

