/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.core.util.IntQueue;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.StreamException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XppReader
implements HierarchicalStreamReader {
    private final XmlPullParser parser;
    private final FastStack elementStack = new FastStack(16);
    private final IntQueue lookaheadQueue = new IntQueue(4);
    private final BufferedReader reader;
    private boolean hasMoreChildrenCached;
    private boolean hasMoreChildrenResult;

    public XppReader(Reader reader) {
        try {
            this.parser = this.createParser();
            this.reader = new BufferedReader(reader);
            this.parser.setInput((Reader)this.reader);
            this.moveDown();
        }
        catch (XmlPullParserException e) {
            throw new StreamException(e);
        }
    }

    protected XmlPullParser createParser() {
        return new MXParser();
    }

    public boolean hasMoreChildren() {
        if (this.hasMoreChildrenCached) {
            return this.hasMoreChildrenResult;
        }
        while (true) {
            switch (this.lookahead()) {
                case 2: {
                    this.hasMoreChildrenCached = true;
                    this.hasMoreChildrenResult = true;
                    return true;
                }
                case 1: 
                case 3: {
                    this.hasMoreChildrenCached = true;
                    this.hasMoreChildrenResult = false;
                    return false;
                }
            }
        }
    }

    private int lookahead() {
        try {
            int event = this.parser.next();
            this.lookaheadQueue.write(event);
            return event;
        }
        catch (XmlPullParserException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    private int next() {
        if (!this.lookaheadQueue.isEmpty()) {
            return this.lookaheadQueue.read();
        }
        try {
            return this.parser.next();
        }
        catch (XmlPullParserException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public void moveDown() {
        this.hasMoreChildrenCached = false;
        int currentDepth = this.elementStack.size();
        while (this.elementStack.size() <= currentDepth) {
            this.read();
            if (this.elementStack.size() >= currentDepth) continue;
            throw new RuntimeException();
        }
    }

    public void moveUp() {
        this.hasMoreChildrenCached = false;
        int currentDepth = this.elementStack.size();
        while (this.elementStack.size() >= currentDepth) {
            this.read();
        }
    }

    public String getNodeName() {
        return (String)this.elementStack.peek();
    }

    public String getValue() {
        if (this.lookahead() == 4) {
            String text = this.parser.getText();
            return text == null ? "" : text;
        }
        return "";
    }

    public String getAttribute(String name) {
        return this.parser.getAttributeValue(null, name);
    }

    public Object peekUnderlyingNode() {
        throw new UnsupportedOperationException();
    }

    private void read() {
        switch (this.next()) {
            case 2: {
                this.elementStack.push(this.parser.getName());
                break;
            }
            case 1: 
            case 3: {
                this.elementStack.pop();
            }
        }
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("line number", String.valueOf(this.parser.getLineNumber()));
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public HierarchicalStreamReader underlyingReader() {
        return this;
    }
}

