/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Date;
import java.util.GregorianCalendar;

public class GregorianCalendarConverter
implements Converter {
    private static final boolean isTimeInMillisAvailable = JVM.is14();
    static /* synthetic */ Class class$java$util$GregorianCalendar;

    public boolean canConvert(Class type) {
        return type.equals(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = GregorianCalendarConverter.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        GregorianCalendar calendar = (GregorianCalendar)source;
        writer.startNode("time");
        long timeInMillis = isTimeInMillisAvailable ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        writer.setValue(String.valueOf(timeInMillis));
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        long timeInMillis = Long.parseLong(reader.getValue());
        reader.moveUp();
        GregorianCalendar result = new GregorianCalendar();
        if (isTimeInMillisAvailable) {
            result.setTimeInMillis(timeInMillis);
        } else {
            result.setTime(new Date(timeInMillis));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

