/*
 * Decompiled with CFR 0.152.
 */
package com.rtfparserkit.converter.text;

import com.rtfparserkit.converter.text.StreamTextConverter;
import com.rtfparserkit.parser.RtfStreamSource;
import com.rtfparserkit.utils.TestUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class StreamTextConverterTest {
    @Test
    public void testTextConversion() throws IOException {
        StreamTextConverter tc = new StreamTextConverter();
        File tempFile = File.createTempFile("testTextConversion", ".rtf");
        tempFile.deleteOnExit();
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = StreamTextConverterTest.class.getResourceAsStream("data/testTextConversion.rtf");
            os = new FileOutputStream(tempFile);
            tc.convert(new RtfStreamSource(is), os, "UTF-8");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception exception) {}
            }
        }
        FileInputStream actualStream = null;
        InputStream expectedStream = null;
        try {
            actualStream = new FileInputStream(tempFile);
            expectedStream = StreamTextConverterTest.class.getResourceAsStream("data/testTextConversion.txt");
            String expectedText = TestUtilities.readStreamToString(expectedStream);
            String actualText = TestUtilities.readStreamToString(actualStream);
            Assert.assertEquals((Object)expectedText, (Object)actualText);
        }
        finally {
            try {
                ((InputStream)actualStream).close();
            }
            catch (Exception exception) {}
            try {
                expectedStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

