/*
**  io.c
**
**  Copyright (c) 2004
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Pantomime/io.h>

#include <errno.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <unistd.h>	// For read() and write() and close()

#ifdef MACOSX
#include <sys/uio.h>	// For read() and write() on OS X
#endif

#ifndef FIONBIO
#include <sys/filio.h>  // For FIONBIO on Solaris
#endif


//
//
//
ssize_t read_block(int fd, void *buf, size_t count)
{
  ssize_t tot, bytes;
  
  tot = bytes = 0;

  while (tot < count)
    {
      if ((bytes = read(fd, buf+tot, count-tot)) == -1)
        {
	  if (errno != EINTR)
	    {
	      return -1;
	    }
	}
      else
	{
	  tot += bytes;
	}
    }
  
  return tot;
}


//
//
//
int safe_close(int fd)
{
  int value;
  while (value = close(fd), value == -1 && errno == EINTR);
  return value;
}


//
//
//
ssize_t safe_read(int fd, void *buf, size_t count)
{
  ssize_t value;
  while (value = read(fd, buf, count), value == -1 && errno == EINTR);
  return value;
}
