/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 1.1.1.1 $   $State: Exp $
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *      Bill Pemberton, Elm Coordinator
 *      flash@virginia.edu
 *
 *******************************************************************************
 * $Log: getword.c,v $
 * Revision 1.1.1.1  2004/11/27 21:21:06  ludo
 * Pantomime import
 *
 * Revision 1.2  2002/07/05 14:31:12  ludo
 * see changelog
 *
 * Revision 1.1.1.1  2001/11/21 18:25:34  ludo
 * Imported Sources
 *
 * Revision 1.2  2001/11/18 23:10:25  ludo
 * See ChangeLog
 *
 * Revision 1.1.1.1  2001/09/28 13:06:57  ludo
 * Import of sources
 *
 * Revision 1.1.1.1  2001/07/28 00:06:35  ludovic
 * Imported Sources
 *
 * Revision 1.3  1996/03/14  17:27:37  wfp5p
 * Alpha 9
 *
 * Revision 1.2  1995/09/29  17:41:12  wfp5p
 * Alpha 8 (Chip's big changes)
 *
 * Revision 1.1.1.1  1995/04/19  20:38:32  wfp5p
 * Initial import of elm 2.4 PL0 as base for elm 2.5.
 *
 ******************************************************************************/

#include <Pantomime/elm_defs.h>

int get_word(buffer, start, word, wordlen)
const char *buffer;
int start;
char *word;
int wordlen;
{
    /*
     * Extracts the next white-space delimited word from the "buffer"
     * starting at "start" characters into the buffer and skipping any
     * leading white-space there.  Handles backslash-quoted characters,
     * (parenthesized comments) and "quoted strings" as an atomic unit.
     * The resulting word, up to "wordlen" bytes long, is saved in "word".
     * Returns the buffer index where extraction terminated, e.g. the next
     * word can be extracted by starting at start+<return-val>.  If no words
     * are found in the buffer then -1 is returned.
     */

    register int len;
    register const char *p;

    for (p = buffer+start ; isspace(*p) ; ++p)
	;

    if (*p == '\0')
	return (-1);		/* nothing IN buffer! */

    if (*p == '(') { /*(*/	/* parenthesized comment */
	len = rfc822_toklen(p);
	if (len < wordlen) {
	    (void) strncpy(word, p, len);
	    word[len] = '\0';
	} else {
	    (void) strfcpy(word, p, wordlen);
	}
	return (p+len - buffer);
    }

    while (*p != '\0') {
	len = len_next_part(p);
	if (len == 1 && isspace(*p))
	    break;
	while (--len >= 0) {
	    if (--wordlen > 0)
		*word++ = *p;
	    ++p;
	}
    }

    *word = '\0';
    return (p - buffer);
}
