"""
The Python Integrated Development Application IDE Framework
"""

try:
    version = __import__('pkg_resources') \
            .get_distribution('pida').version
except Exception:  # DistributionNotFound
    try:
        import hgdistver
        version = hgdistver.get_version()
    except ImportError:
        version = 'unknown'

copyright = 'Copyright (c) 2005-2009 The PIDA Project'

website = 'http://pida.co.uk/'

author = 'Ali Afshar <aafshar@gmail.com>'

maintainer = 'Ronny Pfannschmidt <Ronny.Pfannschmidt@gmx.de>'

dev_core = [
    author,
    maintainer,
    'Daniel Poelzleithner <pida@poelzi.org>'
]

dev_contrib = [
    'Tiago Cogumbreiro <cogumbreiro@users.sf.net>',
    'Alejandro Mery <amery@geeks.cl>',
    'Bernard Pratz <guyzmo@m0g.net>',
    'Mathieu Virbel <tito@bankiz.org>',
    'Anders Conbere <aconbere@gmail.com>',
    'David Soulayrol <david.soulayrol@gmail.com>',
    'Alexander Gabriel <Alexander.Gabriel@TU-Harburg.de>',
    'Tobias Eberle <info@tobiaseberle.de>',
    #XXX: khiraly
]

authors = dev_core + dev_contrib

short_description = 'An integrated development environment that reuses tools such as Vim, and all version control systems.'

