/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.omegat.core.data.ITMXEntry;
import org.omegat.util.TMXProp;

public class TMXEntry
implements ITMXEntry {
    private static final String PROP_ORIGIN = "origin";
    public final String source;
    public final String translation;
    public final String changer;
    public final long changeDate;
    public final String creator;
    public final long creationDate;
    public final String note;
    public final boolean defaultTranslation;
    public final ExternalLinked linked;
    public final String origin;

    TMXEntry(ITMXEntry from, boolean defaultTranslation, ExternalLinked linked) {
        this.source = from.getSourceText();
        this.translation = from.getTranslationText();
        this.changer = from.getChanger();
        this.changeDate = from.getChangeDate();
        this.creator = from.getCreator();
        this.creationDate = from.getCreationDate();
        this.note = from.getNote();
        this.defaultTranslation = defaultTranslation;
        this.linked = linked;
        this.origin = from.getPropValue(PROP_ORIGIN);
    }

    @Override
    public String getSourceText() {
        return this.source;
    }

    @Override
    public String getTranslationText() {
        return this.translation;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public long getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String getChanger() {
        return this.changer;
    }

    @Override
    public long getChangeDate() {
        return this.changeDate;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TMXEntry other = (TMXEntry)obj;
        if (this.changeDate / 1000L != other.changeDate / 1000L) {
            return false;
        }
        if (this.creationDate / 1000L != other.creationDate / 1000L) {
            return false;
        }
        if (!this.equalsTranslation(other)) {
            return false;
        }
        if (!Objects.equals(this.changer, other.changer)) {
            return false;
        }
        if (!Objects.equals(this.creator, other.creator)) {
            return false;
        }
        if (this.defaultTranslation != other.defaultTranslation) {
            return false;
        }
        return Objects.equals(this.source, other.source);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeDate / 1000L, this.creationDate / 1000L, this.translation, this.note, this.linked, this.changer, this.creator, this.defaultTranslation, this.source});
    }

    public boolean equalsTranslation(TMXEntry other) {
        if (other == null) {
            return false;
        }
        if (!Objects.equals(this.translation, other.translation)) {
            return false;
        }
        if (!Objects.equals(this.note, other.note)) {
            return false;
        }
        return Objects.equals((Object)this.linked, (Object)other.linked);
    }

    @Override
    public boolean hasProperties() {
        return this.origin != null;
    }

    @Override
    public String getPropValue(String propType) {
        if (this.origin != null && propType.equals(PROP_ORIGIN)) {
            return this.origin;
        }
        return null;
    }

    @Override
    public boolean hasPropValue(String propType, String propValue) {
        if (this.origin != null && propType.equals(PROP_ORIGIN)) {
            return this.origin.equals(propValue);
        }
        return false;
    }

    @Override
    public List<TMXProp> getProperties() {
        if (this.origin != null) {
            return Collections.singletonList(new TMXProp(PROP_ORIGIN, this.origin));
        }
        return null;
    }

    public static enum ExternalLinked {
        xICE,
        x100PC,
        xAUTO,
        xENFORCED;

    }
}

