/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import gen.core.project.RepositoryDefinition;
import gen.core.project.RepositoryMapping;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.omegat.convert.ConvertProject;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.KnownException;
import org.omegat.core.data.ProjectFactory;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.core.team2.IRemoteRepository2;
import org.omegat.core.team2.RemoteRepositoryProvider;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.dialogs.ChooseMedProject;
import org.omegat.gui.dialogs.FileCollisionDialog;
import org.omegat.gui.dialogs.NewProjectFileChooser;
import org.omegat.gui.dialogs.NewTeamProjectController;
import org.omegat.gui.dialogs.ProjectPropertiesDialog;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectMedProcessing;
import org.omegat.util.FileUtil;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RecentProjects;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.WikiGet;
import org.omegat.util.gui.OmegaTFileChooser;
import org.omegat.util.gui.OpenProjectFileChooser;
import org.omegat.util.gui.UIThreadsUtil;

public final class ProjectUICommands {
    private ProjectUICommands() {
    }

    public static void projectCreate() {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        NewProjectFileChooser ndc = new NewProjectFileChooser();
        int ndcResult = ndc.showSaveDialog(Core.getMainWindow().getApplicationFrame());
        if (ndcResult != 0) {
            return;
        }
        final File dir = ndc.getSelectedFile();
        if (!ProjectUICommands.ensureProjectDir(dir)) {
            return;
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ProjectProperties props = new ProjectProperties(dir);
                props.setSourceLanguage(Preferences.getPreferenceDefault("source_lang", "AR-LB"));
                props.setTargetLanguage(Preferences.getPreferenceDefault("target_lang", "UK-UA"));
                ProjectPropertiesDialog newProjDialog = new ProjectPropertiesDialog((Frame)Core.getMainWindow().getApplicationFrame(), props, dir.getAbsolutePath(), ProjectPropertiesDialog.Mode.NEW_PROJECT);
                newProjDialog.setVisible(true);
                newProjDialog.dispose();
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                ProjectProperties newProps = newProjDialog.getResult();
                if (newProps == null) {
                    dir.delete();
                    mainWindow.setCursor(oldCursor);
                    return null;
                }
                String projectRoot = newProps.getProjectRoot();
                if (!StringUtil.isEmpty(projectRoot)) {
                    try {
                        ProjectFactory.createProject(newProps);
                        RecentProjects.add(dir.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                        Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    }
                }
                mainWindow.setCursor(oldCursor);
                return null;
            }
        }.execute();
    }

    public static void projectOpenMED() {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        ChooseMedProject ndm = new ChooseMedProject();
        int ndmResult = ndm.showOpenDialog(Core.getMainWindow().getApplicationFrame());
        if (ndmResult != 0) {
            return;
        }
        final File med = ndm.getSelectedFile();
        NewProjectFileChooser ndc = new NewProjectFileChooser();
        int ndcResult = ndc.showSaveDialog(Core.getMainWindow().getApplicationFrame());
        if (ndcResult != 0) {
            return;
        }
        final File dir = ndc.getSelectedFile();
        if (!ProjectUICommands.ensureProjectDir(dir)) {
            return;
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ProjectProperties newProps = new ProjectProperties(dir);
                ProjectMedProcessing.extractFromMed(med, newProps);
                try {
                    ProjectFactory.createProject(newProps);
                    RecentProjects.add(dir.getAbsolutePath());
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(Core.getEditor()::requestFocus);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public static void projectCreateMED() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        ChooseMedProject ndm = new ChooseMedProject();
        Object zipName = null;
        try {
            File origin = ProjectMedProcessing.getOriginMedFile(Core.getProject().getProjectProperties());
            if (origin != null) {
                zipName = origin.getName();
            }
        }
        catch (Exception origin) {
            // empty catch block
        }
        if (zipName == null) {
            zipName = Core.getProject().getProjectProperties().getProjectName() + "-MED.zip";
        }
        ndm.setSelectedFile(new File(Core.getProject().getProjectProperties().getProjectRootDir().getParentFile(), (String)zipName));
        int ndmResult = ndm.showSaveDialog(Core.getMainWindow().getApplicationFrame());
        if (ndmResult != 0) {
            return;
        }
        final File med = ndm.getSelectedFile().getName().toLowerCase(Locale.ENGLISH).endsWith(".zip") ? ndm.getSelectedFile() : new File(ndm.getSelectedFile().getAbsolutePath() + ".zip");
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                mainWindow.showStatusMessageRB("MW_STATUS_SAVING", new Object[0]);
                Core.executeExclusively(true, () -> {
                    Core.getProject().saveProject(true);
                    try {
                        Core.getProject().compileProject(".*");
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                });
                ProjectMedProcessing.createMed(med, Core.getProject().getProjectProperties());
                mainWindow.showStatusMessageRB("MW_STATUS_SAVED", new Object[0]);
                mainWindow.setCursor(oldCursor);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(Core.getEditor()::requestFocus);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public static void projectTeamCreate() {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        new SwingWorker<Void, Void>(){
            File projectRoot;
            IMainWindow mainWindow;
            Cursor oldCursor;

            @Override
            protected Void doInBackground() throws Exception {
                this.mainWindow = Core.getMainWindow();
                this.mainWindow.showStatusMessageRB(null, new Object[0]);
                NewTeamProjectController newTeamProjectController = new NewTeamProjectController(this.mainWindow);
                File dir = newTeamProjectController.show();
                if (dir == null || !ProjectUICommands.ensureProjectDir(dir)) {
                    return null;
                }
                Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
                this.oldCursor = this.mainWindow.getCursor();
                this.mainWindow.setCursor(hourglassCursor);
                Core.getMainWindow().showStatusMessageRB("CT_DOWNLOADING_PROJECT", new Object[0]);
                this.projectRoot = dir;
                ArrayList<RepositoryDefinition> repos = new ArrayList<RepositoryDefinition>();
                RepositoryDefinition repo = newTeamProjectController.getRepo();
                repos.add(repo);
                RepositoryMapping mapping = new RepositoryMapping();
                mapping.setLocal("");
                mapping.setRepository("");
                repo.getMapping().add(mapping);
                RemoteRepositoryProvider remoteRepositoryProvider = new RemoteRepositoryProvider(this.projectRoot, repos);
                remoteRepositoryProvider.switchAllToLatest();
                for (String file : new String[]{"omegat.project", "omegat/filters.xml", "omegat/segmentation.conf"}) {
                    remoteRepositoryProvider.copyFilesFromReposToProject(file);
                }
                ProjectProperties props = ProjectFileStorage.loadProjectProperties(this.projectRoot);
                if (props.getRepositories() == null) {
                    props.setRepositories(repos);
                } else {
                    RepositoryDefinition remoteRepo = ProjectUICommands.getRootGitRepositoryMapping(props.getRepositories());
                    if (ProjectUICommands.isRepositoryEquals(remoteRepo, repo)) {
                        ProjectUICommands.setRootGitRepositoryMapping(props.getRepositories(), repo);
                    }
                }
                ProjectFileStorage.writeProjectFile(props);
                this.mainWindow.setCursor(this.oldCursor);
                this.oldCursor = null;
                return null;
            }

            @Override
            protected void done() {
                block3: {
                    Core.getMainWindow().showProgressMessage(" ");
                    try {
                        this.get();
                        if (this.projectRoot != null) {
                            SwingUtilities.invokeLater(() -> {
                                Core.getEditor().requestFocus();
                                ProjectUICommands.projectOpen(this.projectRoot);
                            });
                        }
                    }
                    catch (Exception ex) {
                        Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_DOWNLOAD_TEAM_PROJECT", new Object[0]);
                        Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_DOWNLOAD_TEAM_PROJECT", new Object[0]);
                        if (this.oldCursor == null) break block3;
                        this.mainWindow.setCursor(this.oldCursor);
                    }
                }
            }
        }.execute();
    }

    public static void projectOpen(File projectDirectory) {
        ProjectUICommands.projectOpen(projectDirectory, false);
    }

    public static void projectOpen(final File projectDirectory, boolean closeCurrent) {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            if (closeCurrent) {
                CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

                    @Override
                    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                        if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                            ProjectUICommands.projectOpen(projectDirectory, false);
                            CoreEvents.unregisterProjectChangeListener(this);
                        }
                    }
                });
                ProjectUICommands.projectClose();
            }
            return;
        }
        final File projectRootFolder = ProjectUICommands.selectProjectRootFolder(projectDirectory);
        if (projectRootFolder == null) {
            return;
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                if (ProjectUICommands.convertOldProjectIfNeed(projectRootFolder)) {
                    ProjectUICommands.projectOpenImpl(projectRootFolder);
                }
                mainWindow.setCursor(oldCursor);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(Core.getEditor()::requestFocus);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    private static File selectProjectRootFolder(File projectDirectory) {
        File projectRootFolder;
        if (projectDirectory == null) {
            OpenProjectFileChooser pfc = new OpenProjectFileChooser();
            if (0 != pfc.showOpenDialog(Core.getMainWindow().getApplicationFrame())) {
                return null;
            }
            projectRootFolder = pfc.getSelectedFile();
        } else {
            projectRootFolder = projectDirectory;
        }
        return projectRootFolder;
    }

    private static boolean convertOldProjectIfNeed(File projectRootFolder) {
        try {
            ConvertProject.convert(projectRootFolder);
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_CONVERT_PROJECT", new Object[0]);
            Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_CONVERT_PROJECT", new Object[0]);
            return false;
        }
        return true;
    }

    private static ProjectProperties checkProjectProperties(File projectRootFolder) {
        ProjectProperties props;
        try {
            props = ProjectFileStorage.loadProjectProperties(projectRootFolder.getAbsoluteFile());
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE_BACK", new Object[0]);
            Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE_BACK", new Object[0]);
            return null;
        }
        return props;
    }

    private static void projectOpenImpl(File projectRootFolder) {
        IMainWindow mainWindow = Core.getMainWindow();
        try {
            ProjectProperties props = ProjectUICommands.checkProjectProperties(projectRootFolder);
            if (props == null) {
                File backupProjectFile = FileUtil.getRecentBackup(new File(projectRootFolder.getAbsoluteFile(), "omegat.project"));
                if (backupProjectFile == null) {
                    throw new KnownException("PROJECT_INVALID", new Object[0]);
                }
                props = ProjectFileStorage.loadPropertiesFile(projectRootFolder.getAbsoluteFile(), backupProjectFile);
            }
            boolean needToSaveProperties = false;
            File newProjectFile = null;
            if (props.hasRepositories()) {
                if (!Core.getParams().containsKey("no-team")) {
                    ProjectProperties localProps = props;
                    List<RepositoryDefinition> localRepos = props.getRepositories();
                    mainWindow.showStatusMessageRB("TEAM_OPEN", new Object[0]);
                    try {
                        RemoteRepositoryProvider remoteRepositoryProvider = new RemoteRepositoryProvider(props.getProjectRootDir(), props.getRepositories(), props);
                        remoteRepositoryProvider.switchToVersion("omegat.project", null);
                        remoteRepositoryProvider.copyFilesFromReposToProject("omegat.project", ".NEW", false);
                        newProjectFile = new File(projectRootFolder.getAbsoluteFile(), "omegat.project.NEW");
                        props = ProjectFileStorage.loadPropertiesFile(projectRootFolder.getAbsoluteFile(), new File(projectRootFolder.getAbsoluteFile(), "omegat.project.NEW"));
                        if (props.getRepositories() == null) {
                            Log.logInfoRB("TF_REMOTE_PROJECT_LACKS_GIT_SETTING", new Object[0]);
                            props.setRepositories(localRepos);
                        } else {
                            RepositoryDefinition newRepository;
                            RepositoryDefinition localRootRepository = ProjectUICommands.getRootGitRepositoryMapping(localRepos);
                            if (!ProjectUICommands.isRepositoryEquals(localRootRepository, newRepository = ProjectUICommands.getRootGitRepositoryMapping(props.getRepositories()))) {
                                ProjectUICommands.setRootGitRepositoryMapping(props.getRepositories(), localRootRepository);
                            }
                        }
                        needToSaveProperties = !ProjectUICommands.isIdenticalOmegatProjectProperties(props, localProps);
                    }
                    catch (IRemoteRepository2.NetworkException remoteRepositoryProvider) {
                    }
                    catch (Exception e) {
                        Log.logErrorRB(e, "TF_PROJECT_PROPERTIES_ERROR", new Object[0]);
                        throw e;
                    }
                }
                props.autocreateDirectories();
            } else {
                File projectFile = new File(projectRootFolder, "omegat.project");
                props.autocreateDirectories();
                while (!props.isProjectValid()) {
                    ProjectPropertiesDialog prj = new ProjectPropertiesDialog((Frame)Core.getMainWindow().getApplicationFrame(), props, projectFile.getAbsolutePath(), ProjectPropertiesDialog.Mode.RESOLVE_DIRS);
                    prj.setVisible(true);
                    props = prj.getResult();
                    prj.dispose();
                    if (props == null) {
                        return;
                    }
                    needToSaveProperties = true;
                }
            }
            ProjectProperties propsP = props;
            boolean finalNeedToSaveProperties = needToSaveProperties;
            File finalNewProjectFile = newProjectFile;
            boolean onlineMode = true;
            Core.executeExclusively(true, () -> {
                boolean succeeded = ProjectFactory.loadProject(propsP, true);
                if (!succeeded) {
                    return;
                }
                File projectFile = new File(projectRootFolder, "omegat.project");
                if (finalNeedToSaveProperties) {
                    File backup = FileUtil.backupFile(projectFile);
                    FileUtil.removeOldBackups(projectFile, 11);
                    Log.logWarningRB("PP_REMOTE_PROJECT_CONTENT_OVERRIDES_THE_CURRENT_PROJECT", backup.getName());
                    Core.getProject().saveProjectProperties();
                } else if (FileUtil.getRecentBackup(projectFile) == null) {
                    FileUtil.backupFile(projectFile);
                } else if (finalNewProjectFile != null) {
                    FileUtils.deleteQuietly((File)finalNewProjectFile);
                }
            });
            RecentProjects.add(projectRootFolder.getAbsolutePath());
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
            Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
        }
    }

    private static boolean isIdenticalOmegatProjectProperties(ProjectProperties that, ProjectProperties my) {
        int i;
        if (my == that) {
            return true;
        }
        if (that == null || my == null) {
            return false;
        }
        for (i = 0; i < my.getSourceRootExcludes().size(); ++i) {
            if (my.getSourceRootExcludes().get(i).equals(that.getSourceRootExcludes().get(i))) continue;
            return false;
        }
        if (my.getRepositories().size() != that.getRepositories().size()) {
            return false;
        }
        for (i = 0; i < my.getRepositories().size(); ++i) {
            if (!new EqualsBuilder().append((Object)my.getRepositories().get(i).getType(), (Object)that.getRepositories().get(i).getType()).append((Object)my.getRepositories().get(i).getUrl(), (Object)that.getRepositories().get(i).getUrl()).append((Object)my.getRepositories().get(i).getBranch(), (Object)that.getRepositories().get(i).getBranch()).append(my.getRepositories().get(i).getMapping().size(), that.getRepositories().get(i).getMapping().size()).isEquals()) {
                return false;
            }
            if (my.getRepositories().get(i).getMapping().size() != that.getRepositories().get(i).getMapping().size()) {
                return false;
            }
            for (int j = 0; j < my.getRepositories().get(i).getMapping().size(); ++j) {
                RepositoryMapping thisMap = my.getRepositories().get(i).getMapping().get(j);
                RepositoryMapping thatMap = that.getRepositories().get(i).getMapping().get(j);
                if (new EqualsBuilder().append((Object)thisMap.getLocal(), (Object)thatMap.getLocal()).append((Object)thisMap.getRepository(), (Object)thatMap.getRepository()).isEquals()) continue;
                return false;
            }
        }
        return new EqualsBuilder().append(my.isSentenceSegmentingEnabled(), that.isSentenceSegmentingEnabled()).append(my.isSupportDefaultTranslations(), that.isSupportDefaultTranslations()).append(my.isRemoveTags(), that.isRemoveTags()).append((Object)my.getProjectName(), (Object)that.getProjectName()).append((Object)my.getSourceLanguage().getLocaleCode(), (Object)that.getSourceLanguage().getLocaleCode()).append((Object)my.getTargetLanguage().getLocaleCode(), (Object)that.getTargetLanguage().getLocaleCode()).append((Object)my.getSourceTokenizer().getCanonicalName(), (Object)that.getSourceTokenizer().getCanonicalName()).append((Object)my.getTargetTokenizer().getCanonicalName(), (Object)that.getTargetTokenizer().getCanonicalName()).append(my.getExportTmLevels(), that.getExportTmLevels()).append((Object)my.getExternalCommand(), (Object)that.getExternalCommand()).append((Object)my.getProjectRootDir(), (Object)that.getProjectRootDir()).append((Object)my.getSourceDir().getUnderRoot(), (Object)that.getSourceDir().getUnderRoot()).append((Object)my.getTargetDir().getUnderRoot(), (Object)that.getTargetDir().getUnderRoot()).append((Object)my.getGlossaryDir().getUnderRoot(), (Object)that.getGlossaryDir().getUnderRoot()).append((Object)my.getWritableGlossaryFile().getUnderRoot(), (Object)that.getWritableGlossaryFile().getUnderRoot()).append((Object)my.getTmDir().getUnderRoot(), (Object)that.getTmDir().getUnderRoot()).append((Object)my.getExportTMRoot(), (Object)that.getExportTMRoot()).append((Object)my.getDictRoot(), (Object)that.getDictRoot()).isEquals();
    }

    private static RepositoryDefinition getRootGitRepositoryMapping(List<RepositoryDefinition> repos) {
        RepositoryDefinition repositoryDefinition = null;
        for (RepositoryDefinition definition : repos) {
            if (!definition.getMapping().get(0).getLocal().equals("/") || !definition.getMapping().get(0).getRepository().equals("/") || !definition.getType().equals("git")) continue;
            repositoryDefinition = definition;
            break;
        }
        return repositoryDefinition;
    }

    private static void setRootGitRepositoryMapping(List<RepositoryDefinition> repos, RepositoryDefinition repositoryDefinition) {
        if (repositoryDefinition == null) {
            return;
        }
        RepositoryDefinition originalRepositoryDefinition = ProjectUICommands.getRootGitRepositoryMapping(repos);
        if (originalRepositoryDefinition == null) {
            return;
        }
        originalRepositoryDefinition.setType(repositoryDefinition.getType());
        originalRepositoryDefinition.setUrl(repositoryDefinition.getUrl());
        originalRepositoryDefinition.setBranch(repositoryDefinition.getBranch());
    }

    private static boolean isRepositoryEquals(RepositoryDefinition a, RepositoryDefinition b) {
        if (a == null || b == null) {
            return false;
        }
        return new EqualsBuilder().append((Object)a.getType(), (Object)b.getType()).append((Object)a.getUrl(), (Object)b.getUrl()).append((Object)a.getBranch(), (Object)b.getBranch()).isEquals();
    }

    public static void promptReload() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        int res = JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
        if (res == 0) {
            ProjectUICommands.projectReload();
        }
    }

    public static void projectReload() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        if (Core.getProject().getProjectProperties().isTeamProject()) {
            ProjectUICommands.projectReloadRemote();
        } else {
            ProjectUICommands.projectReloadLocal();
        }
    }

    private static void projectReloadRemote() {
        ProjectProperties props = Core.getProject().getProjectProperties();
        final File projectDirectory = props.getProjectRootDir();
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            @Override
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                    ProjectUICommands.projectOpen(projectDirectory, false);
                    CoreEvents.unregisterProjectChangeListener(this);
                }
            }
        });
        ProjectUICommands.projectClose();
    }

    private static void projectReloadLocal() {
        final ProjectProperties props = Core.getProject().getProjectProperties();
        new SwingWorker<Void, Void>(){
            final int previousCurEntryNum = Core.getEditor().getCurrentEntryNumber();

            @Override
            protected Void doInBackground() throws Exception {
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                Core.executeExclusively(true, () -> {
                    Core.getProject().saveProject(true);
                    ProjectFactory.closeProject();
                    ProjectFactory.loadProject(props, true);
                });
                mainWindow.setCursor(oldCursor);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(() -> {
                        Core.getEditor().gotoEntry(this.previousCurEntryNum);
                        Core.getEditor().requestFocus();
                    });
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectSave() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                mainWindow.showStatusMessageRB("MW_STATUS_SAVING", new Object[0]);
                Core.executeExclusively(true, () -> Core.getProject().saveProject(true));
                mainWindow.showStatusMessageRB("MW_STATUS_SAVED", new Object[0]);
                mainWindow.setCursor(oldCursor);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectClose() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Core.getMainWindow().showStatusMessageRB("MW_STATUS_SAVING", new Object[0]);
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                Preferences.save();
                Core.executeExclusively(true, () -> {
                    Core.getProject().saveProject(true);
                    ProjectFactory.closeProject();
                });
                Core.getMainWindow().showStatusMessageRB("MW_STATUS_SAVED", new Object[0]);
                mainWindow.setCursor(oldCursor);
                Core.getMainWindow().showLengthMessage(OStrings.getString("MW_SEGMENT_LENGTH_DEFAULT"));
                Core.getMainWindow().showProgressMessage(Preferences.getPreferenceEnumDefault("sb_progress_mode", MainWindowUI.StatusBarMode.DEFAULT) == MainWindowUI.StatusBarMode.DEFAULT ? OStrings.getString("MW_PROGRESS_DEFAULT") : OStrings.getProgressBarDefaultPrecentageText());
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
                Core.setFilterMaster(new FilterMaster(Preferences.getFilters()));
                Core.setSegmenter(new Segmenter(Preferences.getSRX()));
            }
        }.execute();
    }

    public static void projectEditProperties() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        ProjectPropertiesDialog prj = new ProjectPropertiesDialog((Frame)Core.getMainWindow().getApplicationFrame(), Core.getProject().getProjectProperties(), Core.getProject().getProjectProperties().getProjectName(), ProjectPropertiesDialog.Mode.EDIT_PROJECT);
        prj.setVisible(true);
        final ProjectProperties newProps = prj.getResult();
        prj.dispose();
        if (newProps == null) {
            return;
        }
        int res = JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
        if (res != 0) {
            return;
        }
        new SwingWorker<Void, Void>(){
            final int previousCurEntryNum = Core.getEditor().getCurrentEntryNumber();

            @Override
            protected Void doInBackground() throws Exception {
                Core.executeExclusively(true, () -> {
                    Core.getProject().saveProject(true);
                    ProjectFactory.closeProject();
                    ProjectFactory.loadProject(newProps, true);
                });
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(() -> {
                        Core.getEditor().gotoEntry(this.previousCurEntryNum);
                        Core.getEditor().requestFocus();
                    });
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectCompile() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Core.executeExclusively(true, () -> {
                    Core.getProject().saveProject(true);
                    try {
                        Core.getProject().compileProject(".*");
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                });
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "TF_COMPILE_ERROR");
                }
            }
        }.execute();
    }

    public static void projectSingleCompile(final String sourcePattern) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Core.executeExclusively(true, () -> {
                    Core.getProject().saveProject(false);
                    try {
                        Core.getProject().compileProject(sourcePattern);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                });
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "TF_COMPILE_ERROR");
                }
            }
        }.execute();
    }

    public static void projectCompileAndCommit() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Core.executeExclusively(true, () -> {
                    Core.getProject().saveProject(true);
                    try {
                        Core.getProject().compileProjectAndCommit(".*", true, true);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                });
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "TF_COMPILE_ERROR");
                }
            }
        }.execute();
    }

    public static void projectCommitSourceFiles() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Core.executeExclusively(true, () -> {
                    try {
                        Core.getProject().commitSourceFiles();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                });
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "TF_COMMIT_ERROR");
                }
            }
        }.execute();
    }

    public static void projectRemote(String url) {
        File projectDir;
        try {
            projectDir = ProjectUICommands.projectRemoteOpen(url);
        }
        catch (IOException ex) {
            Log.logErrorRB(ex, "TEAM_REMOTE_RETRIEVE_ERROR", url);
            Core.getMainWindow().displayErrorRB(ex, "TEAM_REMOTE_RETRIEVE_ERROR", url);
            return;
        }
        ProjectUICommands.projectOpen(projectDir);
    }

    private static File projectRemoteOpen(String url) throws IOException {
        String dir = url.replace("/", "_").replace(':', '_');
        File projectDir = new File(StaticUtils.getConfigDir() + "/remoteProjects/" + dir);
        File projectFile = new File(projectDir, "omegat.project");
        boolean res = projectDir.mkdirs();
        if (!res) {
            throw new IOException("Failed to create project directory.");
        }
        byte[] data = HttpConnectionUtils.getURLasByteArray(url);
        if (data == null) {
            throw new IOException("Data retrieval error");
        }
        FileUtils.writeByteArrayToFile((File)projectFile, (byte[])data);
        return projectDir;
    }

    public static void projectImportFiles(String destination, File[] toImport) {
        ProjectUICommands.projectImportFiles(destination, toImport, true);
    }

    public static void projectImportFiles(String destination, File[] toImport, boolean doReload) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        try {
            FileUtil.copyFilesTo(new File(destination), toImport, new CollisionCallback());
            if (doReload) {
                ProjectUICommands.projectReload();
            }
        }
        catch (IOException ioe) {
            Core.getMainWindow().displayErrorRB(ioe, "MAIN_ERROR_File_Import_Failed", new Object[0]);
        }
    }

    public static void doPromptImportSourceFiles() {
        OmegaTFileChooser chooser = new OmegaTFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        chooser.setDialogTitle(OStrings.getString("TF_FILE_IMPORT_TITLE"));
        int result = chooser.showOpenDialog(Core.getMainWindow().getApplicationFrame());
        if (result == 0) {
            File[] selFiles = chooser.getSelectedFiles();
            ProjectUICommands.projectImportFiles(Core.getProject().getProjectProperties().getSourceRoot(), selFiles);
        }
    }

    public static void doWikiImport() {
        String remoteUrl = JOptionPane.showInputDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("TF_WIKI_IMPORT_PROMPT"), OStrings.getString("TF_WIKI_IMPORT_TITLE"), 2);
        String projectsource = Core.getProject().getProjectProperties().getSourceRoot();
        if (remoteUrl == null || remoteUrl.trim().isEmpty()) {
            return;
        }
        try {
            WikiGet.doWikiGet(remoteUrl, projectsource);
            ProjectUICommands.projectReload();
        }
        catch (Exception ex) {
            Log.log(ex);
            Core.getMainWindow().displayErrorRB(ex, "TF_WIKI_IMPORT_FAILED", new Object[0]);
        }
    }

    private static boolean ensureProjectDir(File dir) {
        if (!dir.isDirectory() && !dir.mkdirs()) {
            Log.logErrorRB("CT_ERROR_CREATING_PROJECT_DIR", dir);
            Core.getMainWindow().displayWarningRB("CT_ERROR_CREATING_PROJECT", new Object[0]);
            return false;
        }
        Path path = dir.toPath();
        if (!Files.isWritable(path) || !Files.isReadable(path)) {
            Log.logErrorRB("CT_ERROR_PROJECT_DIR_PERMISSIONS", path);
            Core.getMainWindow().displayWarningRB("CT_ERROR_CREATING_PROJECT", new Object[0]);
            return false;
        }
        return true;
    }

    private static void processSwingWorkerException(Exception ex, String errorCode) {
        if (ex instanceof ExecutionException) {
            Log.logErrorRB(ex.getCause(), errorCode, new Object[0]);
            if (ex.getCause() instanceof KnownException) {
                KnownException e = (KnownException)ex.getCause();
                Core.getMainWindow().displayErrorRB(e.getCause(), e.getMessage(), e.getParams());
            } else {
                Core.getMainWindow().displayErrorRB(ex.getCause(), errorCode, new Object[0]);
            }
        } else {
            Log.logErrorRB(ex, errorCode, new Object[0]);
            Core.getMainWindow().displayErrorRB(ex, errorCode, new Object[0]);
        }
    }

    private static class CollisionCallback
    implements FileUtil.ICollisionCallback {
        private boolean isCanceled = false;
        private boolean yesToAll = false;

        private CollisionCallback() {
        }

        @Override
        public boolean shouldReplace(File file, int index, int total) {
            if (this.isCanceled) {
                return false;
            }
            if (this.yesToAll) {
                return true;
            }
            FileCollisionDialog dialog = new FileCollisionDialog(Core.getMainWindow().getApplicationFrame());
            dialog.setFilename(file.getName());
            dialog.enableApplyToAll(total - index > 1);
            dialog.pack();
            dialog.setVisible(true);
            this.isCanceled = dialog.userDidCancel();
            if (this.isCanceled) {
                return false;
            }
            this.yesToAll = dialog.isApplyToAll() && dialog.shouldReplace();
            return this.yesToAll || dialog.shouldReplace();
        }

        @Override
        public boolean isCanceled() {
            return this.isCanceled;
        }
    }
}

