/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.util;

import difflib.Chunk;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class CharDiff {
    private static final AttributeSet STYLE_INSERTED;
    private static final AttributeSet STYLE_INSERTED_ALT;
    private static final AttributeSet STYLE_DELETED;
    private static final AttributeSet STYLE_DELETED_ALT;

    private static Patch makePatch(String from, String to) {
        if (from == null || to == null || from.equals(to) || from.equals("") && to.equals("")) {
            return null;
        }
        List<Character> fromList = CharDiff.toList(from);
        List<Character> toList = CharDiff.toList(to);
        return DiffUtils.diff(fromList, toList);
    }

    private static List<Character> toList(String string) {
        if (string == null || string.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Character> result = new ArrayList<Character>();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            result.add(c);
        }
        return result;
    }

    public static void applyStyling(String from, String to, JTextPane deleteComponent, JTextPane insertComponent, boolean alternateColors) {
        Patch patch = CharDiff.makePatch(from, to);
        if (patch == null) {
            return;
        }
        for (Delta d : patch.getDeltas()) {
            Delta.TYPE type = d.getType();
            if (deleteComponent != null && (type == Delta.TYPE.DELETE || type == Delta.TYPE.CHANGE)) {
                Chunk original = d.getOriginal();
                deleteComponent.setSelectionStart(original.getPosition());
                deleteComponent.setSelectionEnd(original.getPosition() + original.size());
                deleteComponent.setCharacterAttributes(alternateColors ? STYLE_DELETED_ALT : STYLE_DELETED, false);
            }
            if (insertComponent == null || type != Delta.TYPE.INSERT && type != Delta.TYPE.CHANGE) continue;
            Chunk revised = d.getRevised();
            insertComponent.setSelectionStart(revised.getPosition());
            insertComponent.setSelectionEnd(revised.getPosition() + revised.size());
            insertComponent.setCharacterAttributes(alternateColors ? STYLE_INSERTED_ALT : STYLE_INSERTED, false);
        }
    }

    public static void applyStyling(String from, String to, JTextPane deleteComponent, JTextPane insertComponent) {
        CharDiff.applyStyling(from, to, deleteComponent, insertComponent, false);
    }

    static {
        SimpleAttributeSet inserted = new SimpleAttributeSet();
        StyleConstants.setUnderline(inserted, true);
        StyleConstants.setForeground(inserted, Color.GREEN);
        STYLE_INSERTED = inserted;
        SimpleAttributeSet insertedAlt = new SimpleAttributeSet();
        StyleConstants.setUnderline(insertedAlt, true);
        StyleConstants.setForeground(insertedAlt, Color.BLUE);
        STYLE_INSERTED_ALT = insertedAlt;
        SimpleAttributeSet deleted = new SimpleAttributeSet();
        StyleConstants.setStrikeThrough(deleted, true);
        StyleConstants.setForeground(deleted, Color.RED);
        STYLE_DELETED = deleted;
        SimpleAttributeSet deletedAlt = new SimpleAttributeSet();
        StyleConstants.setStrikeThrough(deletedAlt, true);
        StyleConstants.setForeground(deletedAlt, Color.ORANGE);
        STYLE_DELETED_ALT = deletedAlt;
    }
}

