/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import javax.swing.text.AttributeSet;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.mark.AbstractMarker;
import org.omegat.gui.editor.mark.TransparentHighlightPainter;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.gui.Styles;

public class RemoveTagMarker
extends AbstractMarker {
    private final Highlighter.HighlightPainter painterRtl = new TransparentHighlightPainter(Styles.EditorColor.COLOR_REMOVETEXT_TARGET.getColor(), 0.2f);
    private final AttributeSet attributesLtrSource;
    private final AttributeSet attributesLtrTranslation;

    public RemoveTagMarker() throws Exception {
        this.toolTip = OStrings.getString("MARKER_REMOVETAG");
        this.attributesLtrSource = Styles.createAttributeSet(null, null, null, true);
        this.attributesLtrTranslation = Styles.createAttributeSet(Styles.EditorColor.COLOR_REMOVETEXT_TARGET.getColor(), null, null, null);
        CoreEvents.registerProjectChangeListener(e -> {
            this.pattern = PatternConsts.getRemovePattern();
        });
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    @Override
    protected void initDrawers(boolean isSource, boolean isActive) {
        if (((EditorController)Core.getEditor()).getOrientation() == Document3.ORIENTATION.ALL_LTR) {
            this.attributes = isSource ? this.attributesLtrSource : this.attributesLtrTranslation;
            this.painter = null;
        } else {
            this.attributes = null;
            this.painter = this.painterRtl;
        }
    }
}

