/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect;

import com.optimaize.langdetect.i18n.LdLocale;
import org.jetbrains.annotations.NotNull;

public class DetectedLanguage
implements Comparable<DetectedLanguage> {
    @NotNull
    private final LdLocale locale;
    private final double probability;

    public DetectedLanguage(@NotNull LdLocale locale, double probability) {
        if (probability < 0.0) {
            throw new IllegalArgumentException("Probability must be >= 0 but was " + probability);
        }
        if (probability > 1.0) {
            throw new IllegalArgumentException("Probability must be <= 1 but was " + probability);
        }
        this.locale = locale;
        this.probability = probability;
    }

    @NotNull
    public LdLocale getLocale() {
        return this.locale;
    }

    public double getProbability() {
        return this.probability;
    }

    public String toString() {
        return "DetectedLanguage[" + this.locale + ":" + this.probability + "]";
    }

    @Override
    public int compareTo(DetectedLanguage o) {
        int compare = Double.compare(o.probability, this.probability);
        if (compare != 0) {
            return compare;
        }
        return this.locale.toString().compareTo(o.locale.toString());
    }
}

