/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2.impl;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.omegat.core.Core;
import org.omegat.core.KnownException;
import org.omegat.core.team2.ProjectTeamSettings;
import org.omegat.core.team2.TeamSettings;
import org.omegat.core.team2.impl.GITUserPassDialog;
import org.omegat.core.team2.impl.TeamUtils;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class GITCredentialsProvider
extends CredentialsProvider {
    static final String KEY_USERNAME_SUFFIX = "username";
    static final String KEY_PASSWORD_SUFFIX = "password";
    static final String KEY_FINGERPRINT_SUFFIX = "fingerprint";
    private final Map<String, String> predefined = Collections.synchronizedMap(new HashMap());

    public void setTeamSettings(ProjectTeamSettings teamSettings) {
    }

    public void setPredefinedCredentials(String url, String predefinedUser, String predefinedPass, String predefinedFingerprint) {
        this.predefined.put("user." + url, predefinedUser);
        this.predefined.put("pass." + url, predefinedPass);
        this.predefined.put("fingerprint." + url, predefinedFingerprint);
    }

    private Credentials loadCredentials(URIish uri) {
        String url = uri.toString();
        Credentials credentials = new Credentials();
        credentials.username = TeamSettings.get(url + "!" + KEY_USERNAME_SUFFIX);
        credentials.password = TeamUtils.decodePassword(TeamSettings.get(url + "!" + KEY_PASSWORD_SUFFIX));
        return credentials;
    }

    private void saveCredentials(URIish uri, Credentials credentials) {
        String url = uri.toString();
        try {
            TeamSettings.set(url + "!" + KEY_USERNAME_SUFFIX, credentials.username);
            TeamSettings.set(url + "!" + KEY_PASSWORD_SUFFIX, TeamUtils.encodePassword(credentials.password));
        }
        catch (Exception e) {
            Core.getMainWindow().displayErrorRB(e, "TEAM_ERROR_SAVE_CREDENTIALS", null, "TF_ERROR");
        }
    }

    private String loadFingerprint(URIish uri) {
        String url = uri.toString();
        return TeamSettings.get(url + "!" + KEY_FINGERPRINT_SUFFIX);
    }

    private void saveFingerprint(URIish uri, String fingerprint) {
        String url = uri.toString();
        try {
            TeamSettings.set(url + "!" + KEY_FINGERPRINT_SUFFIX, fingerprint);
        }
        catch (Exception e) {
            Core.getMainWindow().displayErrorRB(e, "TEAM_ERROR_SAVE_CREDENTIALS", null, "TF_ERROR");
        }
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        String url = uri.toString();
        String predefinedUser = this.predefined.get("user." + url);
        String predefinedPass = this.predefined.get("pass." + url);
        String predefinedFingerprint = this.predefined.get("fingerprint." + url);
        Credentials credentials = this.loadCredentials(uri);
        boolean ok = false;
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username) {
                if (predefinedUser != null && predefinedPass != null) {
                    ((CredentialItem.Username)i).setValue(predefinedUser);
                    continue;
                }
                if (credentials.username == null) {
                    if ((credentials = this.askCredentials(uri, credentials)) == null) {
                        throw new UnsupportedCredentialItem(uri, OStrings.getString("TEAM_CREDENTIALS_DENIED"));
                    }
                    this.saveCredentials(uri, credentials);
                    ok = true;
                }
                ((CredentialItem.Username)i).setValue(credentials.username);
                continue;
            }
            if (i instanceof CredentialItem.Password) {
                if (predefinedUser != null && predefinedPass != null) {
                    ((CredentialItem.Password)i).setValue(predefinedPass.toCharArray());
                    continue;
                }
                if (credentials.password == null) {
                    if ((credentials = this.askCredentials(uri, credentials)) == null) {
                        throw new UnsupportedCredentialItem(uri, OStrings.getString("TEAM_CREDENTIALS_DENIED"));
                    }
                    this.saveCredentials(uri, credentials);
                    ok = true;
                }
                ((CredentialItem.Password)i).setValue(credentials.password.toCharArray());
                continue;
            }
            if (i instanceof CredentialItem.StringType) {
                if (i.getPromptText().equals("Password: ")) {
                    if (predefinedUser != null && predefinedPass != null) {
                        ((CredentialItem.StringType)i).setValue(predefinedPass);
                        continue;
                    }
                    if (credentials.password == null && !ok) {
                        if ((credentials = this.askCredentials(uri, credentials)) == null) {
                            throw new UnsupportedCredentialItem(uri, OStrings.getString("TEAM_CREDENTIALS_DENIED"));
                        }
                        this.saveCredentials(uri, credentials);
                    }
                    ((CredentialItem.StringType)i).setValue(credentials.password);
                    continue;
                }
                if (i.getPromptText().startsWith("Passphrase for ") && !ok) {
                    String passphrase = this.askPassphrase(i.getPromptText());
                    if (passphrase == null) {
                        throw new UnsupportedCredentialItem(uri, OStrings.getString("TEAM_CREDENTIALS_DENIED"));
                    }
                    ((CredentialItem.StringType)i).setValue(passphrase);
                    continue;
                }
            } else {
                if (i instanceof CredentialItem.YesNoType) {
                    String storedFingerprint = this.loadFingerprint(uri);
                    String promptText = i.getPromptText();
                    String promptedFingerprint = GITCredentialsProvider.extractFingerprint(promptText);
                    if (promptedFingerprint == null) {
                        throw new UnsupportedCredentialItem(uri, "Wrong fingerprint pattern");
                    }
                    if (predefinedFingerprint != null) {
                        if (promptedFingerprint.equals(predefinedFingerprint)) {
                            ((CredentialItem.YesNoType)i).setValue(true);
                            continue;
                        }
                        ((CredentialItem.YesNoType)i).setValue(false);
                        continue;
                    }
                    if (promptedFingerprint.equals(storedFingerprint)) {
                        ((CredentialItem.YesNoType)i).setValue(true);
                        continue;
                    }
                    int choice = Core.getMainWindow().showConfirmDialog(promptText, null, 0, 2);
                    if (choice == 0) {
                        ((CredentialItem.YesNoType)i).setValue(true);
                        this.saveFingerprint(uri, promptedFingerprint);
                        continue;
                    }
                    ((CredentialItem.YesNoType)i).setValue(false);
                    continue;
                }
                if (i instanceof CredentialItem.InformationalMessage) {
                    Core.getMainWindow().showMessageDialog(i.getPromptText());
                    continue;
                }
            }
            throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
        }
        return true;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username || i instanceof CredentialItem.Password) continue;
            return false;
        }
        return true;
    }

    private Credentials askCredentials(URIish uri, Credentials credentials) {
        GITUserPassDialog userPassDialog = new GITUserPassDialog(Core.getMainWindow().getApplicationFrame());
        userPassDialog.setLocationRelativeTo(Core.getMainWindow().getApplicationFrame());
        userPassDialog.descriptionTextArea.setText(OStrings.getString(credentials.username == null ? "TEAM_USERPASS_FIRST" : "TEAM_USERPASS_WRONG"));
        if (uri.getUser() != null && !"".equals(uri.getUser())) {
            userPassDialog.userText.setText(uri.getUser());
            userPassDialog.userText.setEditable(false);
            userPassDialog.userText.setEnabled(false);
        }
        if (credentials.username != null) {
            userPassDialog.userText.setText(credentials.username);
        }
        userPassDialog.setVisible(true);
        if (userPassDialog.getReturnStatus() == 1) {
            credentials.username = userPassDialog.userText.getText();
            credentials.password = new String(userPassDialog.passwordField.getPassword());
            return credentials;
        }
        return null;
    }

    private String askPassphrase(String prompt) {
        GITUserPassDialog userPassDialog = new GITUserPassDialog(Core.getMainWindow().getApplicationFrame());
        userPassDialog.setLocationRelativeTo(Core.getMainWindow().getApplicationFrame());
        userPassDialog.descriptionTextArea.setText(prompt);
        userPassDialog.userText.setVisible(false);
        userPassDialog.userLabel.setVisible(false);
        userPassDialog.passwordField.requestFocusInWindow();
        userPassDialog.setVisible(true);
        if (userPassDialog.getReturnStatus() == 1) {
            return new String(userPassDialog.passwordField.getPassword());
        }
        return null;
    }

    public void reset(URIish uri) {
        String url = uri.toString();
        String predefinedUser = this.predefined.get("user." + url);
        String predefinedPass = this.predefined.get("pass." + url);
        if (predefinedUser != null && predefinedPass != null) {
            throw new KnownException("TEAM_PREDEFINED_CREDENTIALS_ERROR", new Object[0]);
        }
        Credentials credentials = this.loadCredentials(uri);
        credentials.username = null;
        credentials.password = null;
        this.saveCredentials(uri, credentials);
    }

    private static String extractFingerprint(String text) {
        Pattern p = Pattern.compile("The authenticity of host '.*' can't be established\\.\\nRSA key fingerprint is (([0-9a-f]{2}:){15}[0-9a-f]{2})\\.\\nAre you sure you want to continue connecting\\?");
        Matcher fingerprintMatcher = p.matcher(text);
        if (fingerprintMatcher.find()) {
            int start = fingerprintMatcher.start(1);
            int end = fingerprintMatcher.end(1);
            return text.substring(start, end);
        }
        return null;
    }

    static {
        JschConfigSessionFactory sessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setConfig("StrictHostKeyChecking", "true");
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                Connector con = null;
                try {
                    if (SSHAgentConnector.isConnectorAvailable()) {
                        JNAUSocketFactory usf = new JNAUSocketFactory();
                        con = new SSHAgentConnector((USocketFactory)usf);
                    } else {
                        ConnectorFactory cf = ConnectorFactory.getDefault();
                        con = cf.createConnector();
                    }
                }
                catch (AgentProxyException e) {
                    Log.log(e);
                }
                JSch jsch = super.createDefaultJSch(fs);
                if (con != null) {
                    JSch.setConfig((String)"PreferredAuthentications", (String)"publickey");
                    RemoteIdentityRepository irepo = new RemoteIdentityRepository(con);
                    jsch.setIdentityRepository((IdentityRepository)irepo);
                }
                return jsch;
            }
        };
        SshSessionFactory.setInstance((SshSessionFactory)sessionFactory);
    }

    public static class Credentials {
        public String username = null;
        public String password = null;
    }
}

