/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSSampleEventStream;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;

public class POSSampleSequenceStream
implements SequenceStream {
    private POSContextGenerator pcg;
    private ObjectStream<POSSample> psi;

    public POSSampleSequenceStream(ObjectStream<POSSample> psi) throws IOException {
        this(psi, new DefaultPOSContextGenerator(null));
    }

    public POSSampleSequenceStream(ObjectStream<POSSample> psi, POSContextGenerator pcg) throws IOException {
        this.psi = psi;
        this.pcg = pcg;
    }

    @Override
    public Event[] updateContext(Sequence sequence, AbstractModel model) {
        Sequence pss = sequence;
        POSTaggerME tagger = new POSTaggerME(new POSModel("x-unspecified", (MaxentModel)model, null, new POSTaggerFactory()));
        String[] sentence = ((POSSample)pss.getSource()).getSentence();
        String[][] ac = ((POSSample)pss.getSource()).getAddictionalContext();
        String[] tags = tagger.tag(((POSSample)pss.getSource()).getSentence());
        Event[] events = new Event[sentence.length];
        POSSampleEventStream.generateEvents(sentence, tags, (Object[])ac, this.pcg).toArray(events);
        return events;
    }

    @Override
    public Sequence read() throws IOException {
        POSSample sample = this.psi.read();
        if (sample != null) {
            String[] sentence = sample.getSentence();
            String[] tags = sample.getTags();
            Event[] events = new Event[sentence.length];
            for (int i = 0; i < sentence.length; ++i) {
                String[] context = this.pcg.getContext(i, sentence, tags, (Object[])null);
                events[i] = new Event(tags[i], context);
            }
            Sequence<POSSample> sequence = new Sequence<POSSample>(events, sample);
            return sequence;
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.psi.reset();
    }

    @Override
    public void close() throws IOException {
        this.psi.close();
    }
}

