/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm;

import edu.berkeley.nlp.lm.AbstractArrayEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.ArrayEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.ConfigOptions;
import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.map.ContextEncodedNgramMap;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.values.ProbBackoffPair;
import edu.berkeley.nlp.lm.values.ProbBackoffValueContainer;
import java.io.Serializable;
import java.util.List;

public class ArrayEncodedProbBackoffLm<W>
extends AbstractArrayEncodedNgramLanguageModel<W>
implements ArrayEncodedNgramLanguageModel<W>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final NgramMap<ProbBackoffPair> map;
    private final ProbBackoffValueContainer values;
    private final boolean useScratchValues;
    private final long numWords;

    public ArrayEncodedProbBackoffLm(int lmOrder, WordIndexer<W> wordIndexer, NgramMap<ProbBackoffPair> map, ConfigOptions opts) {
        super(lmOrder, wordIndexer, (float)opts.unknownWordLogProb);
        this.map = map;
        this.values = (ProbBackoffValueContainer)map.getValues();
        this.useScratchValues = !(map instanceof ContextEncodedNgramMap);
        this.numWords = map.getNumNgrams(0);
    }

    @Override
    public float getLogProb(int[] ngram, int startPos, int endPos) {
        float logProb;
        int probContextOrder;
        long probContext;
        NgramMap<ProbBackoffPair> localMap = this.map;
        if (endPos - startPos < 1) {
            return 0.0f;
        }
        ProbBackoffPair scratch = !this.useScratchValues ? null : new ProbBackoffPair(Float.NaN, Float.NaN);
        int unigramWord = ngram[endPos - 1];
        if (unigramWord < 0 || (long)unigramWord >= this.numWords) {
            return this.oovWordLogProb;
        }
        long matchedProbContext = unigramWord;
        int matchedProbContextOrder = -1;
        for (int i = endPos - 2; i >= startPos && (probContext = localMap.getValueAndOffset(matchedProbContext, probContextOrder = endPos - i - 2, ngram[i], scratch)) >= 0L; --i) {
            matchedProbContext = probContext;
            matchedProbContextOrder = probContextOrder;
        }
        float f = logProb = scratch == null ? this.values.getProb(matchedProbContextOrder + 1, matchedProbContext) : scratch.prob;
        if (Float.isNaN(logProb)) {
            int probContextOrder2;
            long probContext2;
            matchedProbContext = 0L;
            matchedProbContextOrder = -1;
            for (int i = endPos - 1; i >= startPos && (probContext2 = localMap.getValueAndOffset(matchedProbContext, probContextOrder2 = endPos - i - 2, ngram[i], scratch)) >= 0L; --i) {
                float tmpProb;
                float f2 = tmpProb = scratch == null ? this.values.getProb(probContextOrder2 + 1, probContext2) : scratch.prob;
                if (Float.isNaN(tmpProb)) continue;
                logProb = tmpProb;
                matchedProbContext = probContext2;
                matchedProbContextOrder = probContextOrder2;
            }
        }
        float backoff = matchedProbContextOrder == endPos - startPos - 2 || endPos - startPos <= 1 ? 0.0f : this.getBackoffSum(ngram, startPos, endPos, localMap, matchedProbContextOrder, scratch);
        return logProb + backoff;
    }

    private float getBackoffSum(int[] ngram, int startPos, int endPos, NgramMap<ProbBackoffPair> localMap, int matchedProbContextOrder, ProbBackoffPair scratch) {
        int backoffContextOrder;
        int i;
        long unigramWord = ngram[endPos - 2];
        if (unigramWord < 0L || unigramWord >= this.numWords) {
            return 0.0f;
        }
        long backoffContext = unigramWord;
        float backoff = 0.0f;
        if (matchedProbContextOrder < 0) {
            if (scratch != null) {
                localMap.getValueAndOffset(0L, -1, ngram[endPos - 2], scratch);
                backoff = scratch.backoff;
            } else {
                backoff = this.values.getBackoff(0, backoffContext);
            }
        }
        for (i = 1; i <= matchedProbContextOrder && backoffContext >= 0L; ++i) {
            backoffContext = localMap.getValueAndOffset(backoffContext, i - 1, ngram[endPos - i - 2], null);
        }
        while (i < endPos - startPos - 1 && backoffContext >= 0L && (backoffContext = localMap.getValueAndOffset(backoffContext, backoffContextOrder = i - 1, ngram[endPos - i - 2], scratch)) >= 0L) {
            assert (i > matchedProbContextOrder);
            float currBackoff = scratch == null ? this.values.getBackoff(backoffContextOrder + 1, backoffContext) : scratch.backoff;
            backoff += Float.isNaN(currBackoff) ? 0.0f : currBackoff;
            ++i;
        }
        return backoff;
    }

    @Override
    public float getLogProb(int[] ngram) {
        return ArrayEncodedNgramLanguageModel.DefaultImplementations.getLogProb(ngram, this);
    }

    @Override
    public float getLogProb(List<W> ngram) {
        return ArrayEncodedNgramLanguageModel.DefaultImplementations.getLogProb(ngram, this);
    }

    public NgramMap<ProbBackoffPair> getNgramMap() {
        return this.map;
    }
}

