/*
 * Decompiled with CFR 0.152.
 */
package org.ictclas4j.bean;

import java.util.ArrayList;
import org.ictclas4j.bean.MidResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegResult {
    private long startTime;
    private String rawContent;
    private ArrayList<MidResult> mrList;
    private String finalResult;

    public SegResult(String rawContent) {
        this.rawContent = rawContent;
        this.startTime = System.currentTimeMillis();
    }

    public String getFinalResult() {
        return this.finalResult;
    }

    public void setFinalResult(String finalResult) {
        this.finalResult = finalResult;
    }

    public ArrayList<MidResult> getMrList() {
        return this.mrList;
    }

    public void setMrList(ArrayList<MidResult> mrList) {
        this.mrList = mrList;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    public long getSpendTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void addMidResult(MidResult mr) {
        if (this.mrList == null) {
            this.mrList = new ArrayList();
        }
        if (mr != null) {
            this.mrList.add(mr);
        }
    }

    public String toHTML() {
        StringBuffer html = new StringBuffer();
        if (this.rawContent != null) {
            html.append("\u539f\u6587\u5185\u5bb9\uff1a");
            html.append("<table border=\"1\" width=\"100%\"><tr><td width=\"100%\">");
            html.append(this.rawContent);
            html.append("</td></tr></table>");
            if (this.mrList != null) {
                for (MidResult mr : this.mrList) {
                    html.append(mr.toHTML());
                }
            }
            if (this.finalResult != null) {
                html.append("<p>\u6700\u7ec8\u5206\u8bcd\u7ed3\u679c\uff1a");
                html.append("<table border=\"1\" width=\"100%\"><tr><td width=\"100%\">");
                html.append("<font color=\"blue\" size=6><b>" + this.finalResult + "</b></font>");
                html.append("</td></tr></table>");
            }
        }
        return html.toString();
    }
}

