/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.matrix;

import java.util.NoSuchElementException;
import net.loomchild.maligna.matrix.FullMatrix;
import net.loomchild.maligna.matrix.MatrixIterator;

public class FullMatrixIterator<T>
implements MatrixIterator<T> {
    private FullMatrix<T> matrix;
    private int x;
    private int y;

    public FullMatrixIterator(FullMatrix<T> matrix) {
        this.matrix = matrix;
        this.beforeFirst();
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void beforeFirst() {
        this.x = -1;
        this.y = 0;
    }

    @Override
    public boolean hasNext() {
        return this.y < this.matrix.getHeight() - 1 || this.x < this.matrix.getWidth() - 1;
    }

    @Override
    public void next() {
        ++this.x;
        if (this.x >= this.matrix.getWidth()) {
            ++this.y;
            this.x = 0;
            if (this.y >= this.matrix.getHeight()) {
                throw new NoSuchElementException();
            }
        }
    }

    @Override
    public void afterLast() {
        this.x = this.matrix.getWidth();
        this.y = this.matrix.getHeight() - 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.y > 0 || this.x > 0;
    }

    @Override
    public void previous() {
        --this.x;
        if (this.x < 0) {
            --this.y;
            this.x = this.matrix.getWidth() - 1;
            if (this.y < 0) {
                throw new NoSuchElementException();
            }
        }
    }
}

