/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.featuregen.GeneratorFactory;

public class TokenNameFinderFactory
extends BaseToolFactory {
    private byte[] featureGeneratorBytes;
    private Map<String, Object> resources;
    private SequenceCodec<String> seqCodec;

    public TokenNameFinderFactory() {
        this.seqCodec = new BioCodec();
    }

    public TokenNameFinderFactory(byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceCodec<String> seqCodec) {
        this.init(featureGeneratorBytes, resources, seqCodec);
    }

    void init(byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceCodec<String> seqCodec) {
        this.featureGeneratorBytes = featureGeneratorBytes;
        this.resources = resources;
        this.seqCodec = seqCodec;
    }

    protected SequenceCodec<String> getSequenceCodec() {
        return this.seqCodec;
    }

    protected Map<String, Object> getResources() {
        return this.resources;
    }

    protected byte[] getFeatureGenerator() {
        return this.featureGeneratorBytes;
    }

    public static TokenNameFinderFactory create(String subclassName, byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceCodec<String> seqCodec) throws InvalidFormatException {
        TokenNameFinderFactory theFactory;
        if (subclassName == null) {
            theFactory = new TokenNameFinderFactory();
        } else {
            try {
                theFactory = ExtensionLoader.instantiateExtension(TokenNameFinderFactory.class, subclassName);
            }
            catch (Exception e) {
                String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
                System.err.println(msg);
                e.printStackTrace();
                throw new InvalidFormatException(msg, e);
            }
        }
        theFactory.init(featureGeneratorBytes, resources, seqCodec);
        return theFactory;
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
    }

    public SequenceCodec<String> createSequenceCodec() {
        if (this.artifactProvider != null) {
            String sequeceCodecImplName = this.artifactProvider.getManifestProperty("sequenceCodecImplName");
            return TokenNameFinderFactory.instantiateSequenceCodec(sequeceCodecImplName);
        }
        return this.seqCodec;
    }

    public NameContextGenerator createContextGenerator() {
        AdaptiveFeatureGenerator featureGenerator = this.createFeatureGenerators();
        if (featureGenerator == null) {
            featureGenerator = NameFinderME.createFeatureGenerator();
        }
        return new DefaultNameContextGenerator(featureGenerator);
    }

    public AdaptiveFeatureGenerator createFeatureGenerators() {
        byte[] descriptorBytes = null;
        descriptorBytes = this.featureGeneratorBytes == null && this.artifactProvider != null ? (byte[])this.artifactProvider.getArtifact("generator.featuregen") : this.featureGeneratorBytes;
        if (descriptorBytes != null) {
            ByteArrayInputStream descriptorIn = new ByteArrayInputStream(descriptorBytes);
            AdaptiveFeatureGenerator generator = null;
            try {
                generator = GeneratorFactory.create(descriptorIn, new FeatureGeneratorResourceProvider(){

                    @Override
                    public Object getResource(String key) {
                        if (TokenNameFinderFactory.this.artifactProvider != null) {
                            return TokenNameFinderFactory.this.artifactProvider.getArtifact(key);
                        }
                        return TokenNameFinderFactory.this.resources.get(key);
                    }
                });
            }
            catch (InvalidFormatException e) {
                throw new TokenNameFinderModel.FeatureGeneratorCreationError(e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Reading from mem cannot result in an I/O error", e);
            }
            return generator;
        }
        return null;
    }

    public static SequenceCodec<String> instantiateSequenceCodec(String sequenceCodecImplName) {
        if (sequenceCodecImplName != null) {
            return ExtensionLoader.instantiateExtension(SequenceCodec.class, sequenceCodecImplName);
        }
        return new BioCodec();
    }
}

