/*
 * Decompiled with CFR 0.152.
 */
package org.dict.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dict.zip.DictZipInputStream;
import org.dict.zip.RandomAccessInputStream;

public final class DictZipFileUtils {
    static final int CHECK_BUF_LEN = 65536;

    static int readUByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    static long readUInt(InputStream in) throws IOException {
        long s = DictZipFileUtils.readUShort(in);
        return (long)DictZipFileUtils.readUShort(in) << 16 | s;
    }

    static int readUShort(InputStream in) throws IOException {
        int b = DictZipFileUtils.readUByte(in);
        return DictZipFileUtils.readUByte(in) << 8 | b;
    }

    static void writeInt(OutputStream out, int i) throws IOException {
        DictZipFileUtils.writeShort(out, i & 0xFFFF);
        DictZipFileUtils.writeShort(out, i >> 16 & 0xFFFF);
    }

    static void writeShort(OutputStream out, int s) throws IOException {
        out.write(s & 0xFF);
        out.write(s >> 8 & 0xFF);
    }

    public static boolean checkDictZipInputStream(String filename) throws IOException {
        boolean result;
        try (DictZipInputStream dzin = new DictZipInputStream(new RandomAccessInputStream(filename, "r"));){
            result = DictZipFileUtils.checkDictZipInputStream(dzin);
            dzin.close();
        }
        return result;
    }

    public static boolean checkDictZipInputStream(DictZipInputStream in) throws IOException {
        long readLen;
        int len;
        byte[] tmpBuf = new byte[65536];
        in.seek(0L);
        for (readLen = 0L; readLen < in.getLength() && (len = in.read(tmpBuf, 0, 65536)) >= 0; readLen += (long)len) {
        }
        return readLen == in.getLength();
    }

    private DictZipFileUtils() {
    }
}

