/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;

public final class SqlJetMemoryPointer
implements ISqlJetMemoryPointer {
    private ISqlJetMemoryBuffer buffer;
    private int pointer;
    private int limit;

    public SqlJetMemoryPointer(ISqlJetMemoryBuffer buffer, int pointer) {
        assert (buffer != null);
        assert (buffer.isAllocated());
        assert (pointer >= 0);
        assert (pointer <= buffer.getSize());
        this.buffer = buffer;
        this.pointer = pointer;
        this.limit = buffer.getSize();
    }

    public SqlJetMemoryPointer(ISqlJetMemoryBuffer buffer, int pointer, int limit) {
        assert (buffer != null);
        assert (buffer.isAllocated());
        assert (pointer >= 0);
        assert (pointer <= buffer.getSize());
        this.buffer = buffer;
        this.pointer = pointer;
        this.limit = limit;
    }

    public final ISqlJetMemoryBuffer getBuffer() {
        return this.buffer;
    }

    public final int getPointer() {
        return this.pointer;
    }

    public final void setPointer(int pointer) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.pointer = pointer;
    }

    public final void movePointer(int count) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        assert (this.pointer + count >= 0);
        assert (this.pointer + count <= this.buffer.getSize());
        this.pointer += count;
    }

    public final byte getByte() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getByte(this.pointer);
    }

    public final int getInt() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getInt(this.pointer);
    }

    public final long getLong() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getLong(this.pointer);
    }

    public final short getShort() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getShort(this.pointer);
    }

    public final int getByteUnsigned() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getByteUnsigned(this.pointer);
    }

    public final long getIntUnsigned() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getIntUnsigned(this.pointer);
    }

    public final int getShortUnsigned() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getShortUnsigned(this.pointer);
    }

    public final void putByte(byte value) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putByte(this.pointer, value);
    }

    public final void putInt(int value) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putInt(this.pointer, value);
    }

    public final void putLong(long value) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putLong(this.pointer, value);
    }

    public final void putShort(short value) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putShort(this.pointer, value);
    }

    public final void putByteUnsigned(int value) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putByteUnsigned(this.pointer, value);
    }

    public final void putIntUnsigned(long value) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putIntUnsigned(this.pointer, value);
    }

    public final void putShortUnsigned(int value) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putShortUnsigned(this.pointer, value);
    }

    public final int readFromFile(RandomAccessFile file, long position, int count) throws IOException {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        assert (file != null);
        assert (position >= 0L);
        assert (count > 0);
        assert (this.pointer + count <= this.buffer.getSize());
        return this.buffer.readFromFile(this.pointer, file, position, count);
    }

    public final int writeToFile(RandomAccessFile file, long position, int count) throws IOException {
        assert (this.buffer != null);
        assert (file != null);
        assert (position >= 0L);
        assert (count > 0);
        assert (this.pointer + count <= this.buffer.getSize());
        return this.buffer.writeToFile(this.pointer, file, position, count);
    }

    public final int getAbsolute(int pointer) {
        return this.pointer + pointer;
    }

    public final byte getByte(int pointer) {
        return this.buffer.getByte(this.getAbsolute(pointer));
    }

    public final int getByteUnsigned(int pointer) {
        return this.buffer.getByteUnsigned(this.getAbsolute(pointer));
    }

    public final int getInt(int pointer) {
        return this.buffer.getInt(this.getAbsolute(pointer));
    }

    public final long getIntUnsigned(int pointer) {
        return this.buffer.getIntUnsigned(this.getAbsolute(pointer));
    }

    public final long getLong(int pointer) {
        return this.buffer.getLong(this.getAbsolute(pointer));
    }

    public final short getShort(int pointer) {
        return this.buffer.getShort(this.getAbsolute(pointer));
    }

    public final int getShortUnsigned(int pointer) {
        return this.buffer.getShortUnsigned(this.getAbsolute(pointer));
    }

    public final void putByte(int pointer, byte value) {
        this.buffer.putByte(this.getAbsolute(pointer), value);
    }

    public final void putByteUnsigned(int pointer, int value) {
        this.buffer.putByteUnsigned(this.getAbsolute(pointer), value);
    }

    public final void putInt(int pointer, int value) {
        this.buffer.putInt(this.getAbsolute(pointer), value);
    }

    public final void putIntUnsigned(int pointer, long value) {
        this.buffer.putIntUnsigned(this.getAbsolute(pointer), value);
    }

    public final void putLong(int pointer, long value) {
        this.buffer.putLong(this.getAbsolute(pointer), value);
    }

    public final void putShort(int pointer, short value) {
        this.buffer.putShort(this.getAbsolute(pointer), value);
    }

    public final void putShortUnsigned(int pointer, int value) {
        this.buffer.putShortUnsigned(this.getAbsolute(pointer), value);
    }

    public final int readFromFile(int pointer, RandomAccessFile file, long position, int count) throws IOException {
        return this.buffer.readFromFile(this.getAbsolute(pointer), file, position, count);
    }

    public final int writeToFile(int pointer, RandomAccessFile file, long position, int count) throws IOException {
        return this.buffer.writeToFile(this.getAbsolute(pointer), file, position, count);
    }

    public final int remaining() {
        return this.limit - this.pointer;
    }

    public final void copyFrom(int dstPos, ISqlJetMemoryPointer src, int srcPos, int length) {
        this.buffer.copyFrom(this.getAbsolute(dstPos), src.getBuffer(), src.getAbsolute(srcPos), length);
    }

    public final void copyFrom(ISqlJetMemoryPointer src, int srcPos, int length) {
        this.buffer.copyFrom(this.pointer, src.getBuffer(), src.getAbsolute(srcPos), length);
    }

    public final void copyFrom(ISqlJetMemoryPointer src, int length) {
        this.buffer.copyFrom(this.pointer, src.getBuffer(), src.getPointer(), length);
    }

    public final void fill(int count, byte value) {
        this.buffer.fill(this.pointer, count, value);
    }

    public final void fill(int from, int count, byte value) {
        this.buffer.fill(this.getAbsolute(from), count, value);
    }

    public final void getBytes(byte[] bytes) {
        this.buffer.getBytes(this.pointer, bytes, 0, bytes.length);
    }

    public final void getBytes(int pointer, byte[] bytes) {
        this.buffer.getBytes(this.getAbsolute(pointer), bytes, 0, bytes.length);
    }

    public final void getBytes(int pointer, byte[] bytes, int count) {
        this.buffer.getBytes(this.getAbsolute(pointer), bytes, 0, count);
    }

    public final void getBytes(int pointer, byte[] bytes, int to, int count) {
        this.buffer.getBytes(this.getAbsolute(pointer), bytes, to, count);
    }

    public final void putBytes(byte[] bytes) {
        this.buffer.putBytes(this.pointer, bytes, 0, bytes.length);
    }

    public final void putBytes(int pointer, byte[] bytes) {
        this.buffer.putBytes(this.getAbsolute(pointer), bytes, 0, bytes.length);
    }

    public final void putBytes(int pointer, byte[] bytes, int count) {
        this.buffer.putBytes(this.getAbsolute(pointer), bytes, 0, count);
    }

    public final void putBytes(int pointer, byte[] bytes, int to, int count) {
        this.buffer.putBytes(this.getAbsolute(pointer), bytes, to, count);
    }

    public final int compareTo(ISqlJetMemoryPointer ptr) {
        return this.buffer.compareTo(this.pointer, ptr.getBuffer(), ptr.getPointer());
    }

    public final void limit(int n) {
        this.limit = n;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final ISqlJetMemoryPointer getIdentic() {
        return new SqlJetMemoryPointer(this.buffer, this.pointer);
    }

    public ISqlJetMemoryPointer getMoved(int count) {
        return new SqlJetMemoryPointer(this.buffer, this.pointer + count, this.limit);
    }
}

