/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCat;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnRemoteCat
extends SvnRemoteOperationRunner<SVNProperties, SvnCat> {
    @Override
    protected SVNProperties run() throws SVNException {
        SVNRevision revision = ((SvnCat)this.getOperation()).getRevision() == null || !((SvnCat)this.getOperation()).getRevision().isValid() ? SVNRevision.HEAD : ((SvnCat)this.getOperation()).getRevision();
        SvnTarget target = ((SvnCat)this.getOperation()).getFirstTarget();
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(target, revision, target.getResolvedPegRevision(), null);
        SVNRepository repos = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        repositoryInfo.release();
        this.checkCancelled();
        long revNumber = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
        this.checkCancelled();
        SVNNodeKind nodeKind = repos.checkPath("", revNumber);
        this.checkCancelled();
        if (nodeKind == SVNNodeKind.DIR) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "URL ''{0}'' refers to a directory", (Object)((SvnCat)this.getOperation()).getFirstTarget().getURL());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.checkCancelled();
        SVNProperties properties = new SVNProperties();
        if (!((SvnCat)this.getOperation()).isExpandKeywords()) {
            repos.getFile("", revNumber, properties, new SVNCancellableOutputStream(((SvnCat)this.getOperation()).getOutput(), this));
        } else {
            repos.getFile("", revNumber, properties, null);
            this.checkCancelled();
            String mimeType = properties.getStringValue("svn:mime-type");
            String charset = SVNTranslator.getCharset(properties.getStringValue("svnkit:charset"), mimeType, repos.getLocation().toString(), ((SvnCat)this.getOperation()).getOptions());
            String keywords = properties.getStringValue("svn:keywords");
            String eol = properties.getStringValue("svn:eol-style");
            if (charset != null || keywords != null || eol != null) {
                String cmtRev = properties.getStringValue("svn:entry:committed-rev");
                String cmtDate = properties.getStringValue("svn:entry:committed-date");
                String author = properties.getStringValue("svn:entry:last-author");
                Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, ((SvnCat)this.getOperation()).isExpandKeywords() ? repos.getLocation().toString() : null, ((SvnCat)this.getOperation()).isExpandKeywords() ? repos.getRepositoryRoot(true).toString() : null, author, cmtDate, cmtRev, ((SvnCat)this.getOperation()).getOptions());
                OutputStream translatingStream = SVNTranslator.getTranslatingOutputStream(((SvnCat)this.getOperation()).getOutput(), charset, SVNTranslator.getEOL(eol, ((SvnCat)this.getOperation()).getOptions()), false, keywordsMap, ((SvnCat)this.getOperation()).isExpandKeywords());
                repos.getFile("", revNumber, null, new SVNCancellableOutputStream(translatingStream, ((SvnCat)this.getOperation()).getEventHandler()));
                try {
                    translatingStream.flush();
                }
                catch (IOExceptionWrapper ioew) {
                    throw ioew.getOriginalException();
                }
                catch (IOException e) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()), SVNLogType.WC);
                }
            } else {
                repos.getFile("", revNumber, properties, new SVNCancellableOutputStream(((SvnCat)this.getOperation()).getOutput(), ((SvnCat)this.getOperation()).getEventHandler()));
            }
        }
        try {
            ((SvnCat)this.getOperation()).getOutput().flush();
        }
        catch (IOException e) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()), SVNLogType.WC);
        }
        return properties;
    }
}

