/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.progress;

import net.loomchild.maligna.progress.ProgressManager;

public class ProgressMeter {
    private static final int DEFAULT_STEPS = 1000;
    private String name;
    private int totalTasks;
    private int completedTasks;
    private int reportedSteps;
    private float tasksPerStep;

    public ProgressMeter(String name, int totalTasks) {
        this(name, totalTasks, 1000);
    }

    public ProgressMeter(String name, int totalTasks, int steps) {
        this.name = name;
        this.totalTasks = totalTasks;
        this.tasksPerStep = steps <= totalTasks ? (float)(totalTasks / steps) : 1.0f;
    }

    public void completeTask() {
        this.completeTasks(1);
    }

    public void completeTasks(int tasks) {
        this.completedTasks += tasks;
        int currentSteps = (int)((float)this.completedTasks / this.tasksPerStep);
        if (currentSteps > this.reportedSteps || this.completedTasks >= this.totalTasks) {
            this.reportedSteps = currentSteps;
            ProgressManager.getInstance().completeTask(this);
        }
    }

    public int getTotalTasks() {
        return this.totalTasks;
    }

    public int getCompletedTasks() {
        return this.completedTasks;
    }

    public float getProgress() {
        float result = 0.0f;
        if (this.totalTasks > 0) {
            result = (float)this.completedTasks / (float)this.totalTasks;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }
}

