/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.omegat.gui.editor.chartable.CharTableModel;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.CharTableAutoCompleterOptionsPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.StaticUIUtils;

public class CharTableAutoCompleterOptionsController
extends BasePreferencesController {
    private static final int MAX_ROW_COUNT = 10;
    private static final int COL_WIDTH = 16;
    private final CharTableModel allCharModel = new CharTableModel(null);
    private final CharTableModel selCharModel = new CharTableModel("");
    private CharTableAutoCompleterOptionsPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_AUTOCOMPLETER_CHAR_TABLE");
    }

    private void initGui() {
        this.panel = new CharTableAutoCompleterOptionsPanel();
        this.panel.allCharTable.setModel(this.allCharModel);
        this.panel.allCharTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (evt.getKeyCode() == 155) {
                    int col = ((CharTableAutoCompleterOptionsController)CharTableAutoCompleterOptionsController.this).panel.allCharTable.getSelectedColumn();
                    int row = ((CharTableAutoCompleterOptionsController)CharTableAutoCompleterOptionsController.this).panel.allCharTable.getSelectedRow();
                    CharTableAutoCompleterOptionsController.this.selCharModel.appendChar((Character)CharTableAutoCompleterOptionsController.this.allCharModel.getValueAt(row, col), ((CharTableAutoCompleterOptionsController)CharTableAutoCompleterOptionsController.this).panel.uniqueCheckBox.isSelected());
                }
            }
        });
        this.panel.allCharTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (((CharTableAutoCompleterOptionsController)CharTableAutoCompleterOptionsController.this).panel.allCharTable.isEnabled() && evt.getClickCount() == 2) {
                    JTable target = (JTable)evt.getSource();
                    int row = target.getSelectedRow();
                    int col = target.getSelectedColumn();
                    CharTableAutoCompleterOptionsController.this.selCharModel.appendChar((Character)CharTableAutoCompleterOptionsController.this.allCharModel.getValueAt(row, col), ((CharTableAutoCompleterOptionsController)CharTableAutoCompleterOptionsController.this).panel.uniqueCheckBox.isSelected());
                }
            }
        });
        this.panel.selCharTable.setModel(this.selCharModel);
        this.panel.selCharTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (evt.getKeyCode() == 127 || evt.getKeyCode() == 8) {
                    if (((CharTableAutoCompleterOptionsController)CharTableAutoCompleterOptionsController.this).panel.selCharTable.getSelectedColumnCount() < 1) {
                        return;
                    }
                    int row1 = ((CharTableAutoCompleterOptionsController)CharTableAutoCompleterOptionsController.this).panel.selCharTable.getSelectedRow();
                    int col1 = ((CharTableAutoCompleterOptionsController)CharTableAutoCompleterOptionsController.this).panel.selCharTable.getSelectedColumn();
                    int row2 = ((CharTableAutoCompleterOptionsController)CharTableAutoCompleterOptionsController.this).panel.selCharTable.getSelectedRowCount() + row1 - 1;
                    int col2 = ((CharTableAutoCompleterOptionsController)CharTableAutoCompleterOptionsController.this).panel.selCharTable.getSelectedColumnCount() + col1 - 1;
                    CharTableAutoCompleterOptionsController.this.selCharModel.removeSelection(row1, col1, row2, col2);
                }
            }
        });
        this.panel.clearButton.addActionListener(e -> this.selCharModel.setData(""));
        this.panel.uniqueCheckBox.addActionListener(e -> {
            if (this.panel.uniqueCheckBox.isSelected()) {
                this.selCharModel.allowOnlyUnique();
            }
        });
        this.panel.selectedCharsCheckBox.addActionListener(e -> StaticUIUtils.setHierarchyEnabled(this.panel.customPanel, this.panel.selectedCharsCheckBox.isSelected()));
        this.panel.enabledCheckBox.addActionListener(e -> this.updateEnabledness());
        this.panel.allCharTable.setPreferredScrollableViewportSize(new Dimension(this.panel.allCharTable.getColumnCount() * 16, this.panel.allCharTable.getRowHeight() * 10));
        this.panel.selCharTable.setPreferredScrollableViewportSize(new Dimension(this.panel.selCharTable.getColumnCount() * 16, this.panel.selCharTable.getRowHeight() * 10));
    }

    private void updateEnabledness() {
        StaticUIUtils.setHierarchyEnabled(this.panel.customPanel, this.panel.enabledCheckBox.isSelected() && this.panel.selectedCharsCheckBox.isSelected());
        this.panel.selectedCharsCheckBox.setEnabled(this.panel.enabledCheckBox.isSelected());
    }

    @Override
    protected void initFromPrefs() {
        this.panel.selectedCharsCheckBox.setSelected(Preferences.isPreference("ac_chartable_use_custom_chars"));
        this.panel.uniqueCheckBox.setSelected(Preferences.isPreference("ac_chartable_unique_custom_chars"));
        this.selCharModel.setData(Preferences.getPreference("ac_chartable_custom_char_string"));
        this.panel.enabledCheckBox.setSelected(Preferences.isPreferenceDefault("ac_chartable_enabled", true));
        this.updateEnabledness();
    }

    @Override
    public void restoreDefaults() {
        this.panel.selectedCharsCheckBox.setSelected(false);
        this.panel.uniqueCheckBox.setSelected(false);
        this.selCharModel.setData("");
        this.panel.enabledCheckBox.setSelected(true);
        this.updateEnabledness();
    }

    @Override
    public void persist() {
        Preferences.setPreference("ac_chartable_use_custom_chars", this.panel.selectedCharsCheckBox.isSelected());
        String customCharString = this.selCharModel.getData();
        Preferences.setPreference("ac_chartable_custom_char_string", customCharString);
        if (customCharString.isEmpty()) {
            Preferences.setPreference("ac_chartable_use_custom_chars", false);
        }
        Preferences.setPreference("ac_chartable_unique_custom_chars", this.panel.uniqueCheckBox.isSelected());
        Preferences.setPreference("ac_chartable_enabled", this.panel.enabledCheckBox.isSelected());
    }
}

