/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.SecureStorePanel;
import org.omegat.util.CredentialsManager;
import org.omegat.util.OStrings;

public class SecureStoreController
extends BasePreferencesController {
    private SecureStorePanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_SECURE_STORE");
    }

    private void initGui() {
        this.panel = new SecureStorePanel();
        this.panel.resetPasswordButton.addActionListener(e -> this.resetMasterPassword());
        this.panel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SecureStoreController.this.updateMasterPasswordStatus();
                }
            }
        });
    }

    private void resetMasterPassword() {
        if (0 == JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(this.panel), OStrings.getString("PREFS_SECURE_STORAGE_RESET_MASTER_PASSWORD_MESSAGE"), OStrings.getString("PREFS_SECURE_STORAGE_RESET_MASTER_PASSWORD_TITLE"), 0, 2)) {
            CredentialsManager.getInstance().clearMasterPassword();
            this.updateMasterPasswordStatus();
        }
    }

    @Override
    protected void initFromPrefs() {
        this.updateMasterPasswordStatus();
    }

    private void updateMasterPasswordStatus() {
        boolean isSet = CredentialsManager.getInstance().isMasterPasswordSet();
        boolean isStored = CredentialsManager.getInstance().isMasterPasswordStored();
        String status = isSet && isStored ? OStrings.getString("PREFS_SECURE_STORAGE_MASTER_PASSWORD_SET_STORED") : (isSet ? OStrings.getString("PREFS_SECURE_STORAGE_MASTER_PASSWORD_SET") : OStrings.getString("PREFS_SECURE_STORAGE_MASTER_PASSWORD_NOT_SET"));
        this.panel.masterPasswordStatusLabel.setText(status);
        this.panel.resetPasswordButton.setEnabled(isSet);
    }

    @Override
    public void restoreDefaults() {
    }

    @Override
    public void persist() {
    }
}

