/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDeleteStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.SvnRevertActualNodesTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.SvnRevertNodesTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbCreateSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.internal.wc17.db.statement17.SvnRevertActualNodesTrigger17;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnWcDbRevert
extends SvnWcDbShared {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revert(SVNWCDbRoot root, File localRelPath, boolean clearChangelists) throws SVNException {
        long affectedRows;
        boolean movedHere;
        File movedTo;
        long opDepth;
        SVNSqlJetDb sdb = root.getSDb();
        SvnRevertNodesTrigger nodesTableTrigger = new SvnRevertNodesTrigger(sdb);
        ISVNSqlJetTrigger actualNodesTableTrigger = root.getFormat() == 29 ? new SvnRevertActualNodesTrigger17(sdb) : new SvnRevertActualNodesTrigger(sdb);
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            if (!stmt.next()) {
                long affectedRows2;
                SvnWcDbStatementUtil.reset(stmt);
                stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE);
                try {
                    ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
                    stmt.bindf("is", root.getWcId(), localRelPath);
                    affectedRows2 = stmt.done();
                }
                finally {
                    stmt.reset();
                }
                if (affectedRows2 > 0L) {
                    stmt = root.getFormat() == 29 ? sdb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO_17) : sdb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO);
                    try {
                        stmt.bindf("is", root.getWcId(), localRelPath);
                        if (stmt.next()) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting children", (Object)root.getAbsPath(localRelPath));
                            SVNErrorManager.error(err, SVNLogType.WC);
                        }
                    }
                    finally {
                        SvnWcDbStatementUtil.reset(stmt);
                    }
                    return;
                }
                SvnWcDbRevert.nodeNotFound(root, localRelPath);
            }
            opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
            movedTo = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.moved_to);
            movedHere = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.NODES__Fields.moved_here);
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        if (movedTo != null) {
            SVNWCDb.ResolveBreakMovedAway resolveBreakMovedAway = new SVNWCDb.ResolveBreakMovedAway();
            resolveBreakMovedAway.wcRoot = root;
            resolveBreakMovedAway.localRelPath = localRelPath;
            try {
                resolveBreakMovedAway.transaction(sdb);
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
            }
        } else {
            SVNSkel conflict = root.getDb().readConflictInternal(root, localRelPath);
            if (conflict != null) {
                Structure<SvnWcDbConflicts.ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflict);
                boolean treeConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.treeConflicted);
                SVNOperation operation = (SVNOperation)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.conflictOperation);
                if (treeConflicted && (operation == SVNOperation.UPDATE || operation == SVNOperation.SWITCH)) {
                    Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(root.getDb(), root.getAbsPath(), conflict);
                    SVNConflictReason reason = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
                    SVNConflictAction action = (SVNConflictAction)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.incomingChange);
                    if (reason == SVNConflictReason.DELETED) {
                        root.getDb().resolveDeleteRaiseMovedAway(SVNFileUtil.createFilePath(root.getAbsPath(), localRelPath), null);
                    }
                }
            }
        }
        if (opDepth > 0L && opDepth == (long)SVNWCUtils.relpathDepth(localRelPath)) {
            SVNErrorMessage err;
            boolean haveRow;
            stmt = sdb.getStatement(SVNWCDbStatements.SELECT_GE_OP_DEPTH_CHILDREN);
            try {
                stmt.bindf("isi", root.getWcId(), localRelPath, opDepth);
                haveRow = stmt.next();
            }
            finally {
                SvnWcDbStatementUtil.reset(stmt);
            }
            if (haveRow) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting children", (Object)root.getAbsPath(localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            stmt = root.getFormat() == 29 ? sdb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO_17) : sdb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO);
            try {
                stmt.bindf("is", root.getWcId(), localRelPath);
                haveRow = stmt.next();
            }
            finally {
                SvnWcDbStatementUtil.reset(stmt);
            }
            if (haveRow) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting children", (Object)root.getAbsPath(localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            stmt = sdb.getStatement(SVNWCDbStatements.UPDATE_OP_DEPTH_INCREASE_RECURSIVE);
            try {
                ((SVNSqlJetTableStatement)stmt).addTrigger(nodesTableTrigger);
                stmt.bindf("isi", root.getWcId(), localRelPath, opDepth);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = sdb.getStatement(SVNWCDbStatements.DELETE_WORKING_NODE);
            try {
                ((SVNSqlJetTableStatement)stmt).addTrigger(nodesTableTrigger);
                stmt.bindf("is", root.getWcId(), localRelPath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = sdb.getStatement(SVNWCDbStatements.DELETE_WC_LOCK_ORPHAN);
            try {
                stmt.bindf("is", root.getWcId(), localRelPath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            if (movedHere) {
                SvnWcDbRevert.clearMovedTo(root, localRelPath, nodesTableTrigger);
            }
        }
        if (clearChangelists) {
            stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE);
            try {
                stmt.bindf("is", root.getWcId(), localRelPath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_LEAVING_CHANGELIST);
        try {
            ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
            stmt.bindf("is", root.getWcId(), localRelPath);
            affectedRows = stmt.done();
        }
        finally {
            stmt.reset();
        }
        if (affectedRows == 0L) {
            stmt = sdb.getStatement(SVNWCDbStatements.CLEAR_ACTUAL_NODE_LEAVING_CHANGELIST);
            try {
                ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
                stmt.bindf("is", root.getWcId(), localRelPath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearMovedTo(SVNWCDbRoot root, File localRelPath, SvnRevertNodesTrigger nodesTableTrigger) throws SVNException {
        SVNSqlJetStatement stmt = root.getSDb().getStatement(root.getFormat() == 29 ? SVNWCDbStatements.SELECT_MOVED_FROM_RELPATH_17 : SVNWCDbStatements.SELECT_MOVED_FROM_RELPATH);
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            if (!haveRow) {
                return;
            }
            File movedFromRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.local_relpath);
            stmt.reset();
            stmt = root.getSDb().getStatement(SVNWCDbStatements.CLEAR_MOVE_TO_RELPATH);
            stmt.bindf("isi", root.getWcId(), movedFromRelPath, SVNWCUtils.relpathDepth(movedFromRelPath));
            ((SVNSqlJetTableStatement)stmt).addTrigger(nodesTableTrigger);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertRecursive(SVNWCDbRoot root, File localRelPath, boolean clearChangelists) throws SVNException {
        boolean movedHere;
        long opDepth;
        SVNSqlJetDb sdb = root.getSDb();
        SvnRevertNodesTrigger nodesTableTrigger = new SvnRevertNodesTrigger(sdb);
        ISVNSqlJetTrigger actualNodesTableTrigger = root.getFormat() == 29 ? new SvnRevertActualNodesTrigger17(sdb) : new SvnRevertActualNodesTrigger(sdb);
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            if (!stmt.next()) {
                long affectedRows;
                SvnWcDbStatementUtil.reset(stmt);
                stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_RECURSIVE);
                try {
                    ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
                    stmt.bindf("is", root.getWcId(), localRelPath);
                    affectedRows = stmt.done();
                }
                finally {
                    stmt.reset();
                }
                if (affectedRows > 0L) {
                    return;
                }
                SvnWcDbRevert.nodeNotFound(root, localRelPath);
            }
            opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
            movedHere = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.NODES__Fields.moved_here);
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        if (opDepth > 0L && opDepth != (long)SVNWCUtils.relpathDepth(localRelPath)) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can't revert ''{0}'' without reverting parent", (Object)SVNFileUtil.createFilePath(root.getAbsPath(), localRelPath));
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        stmt = sdb.getStatement(SVNWCDbStatements.SELECT_MOVED_OUTSIDE);
        try {
            stmt.bindf("isi", root.getWcId(), localRelPath, opDepth);
            boolean haveRow = stmt.next();
            while (haveRow) {
                File moveSrcRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.local_relpath);
                SVNWCDb.ResolveBreakMovedAway resolveBreakMovedAway = new SVNWCDb.ResolveBreakMovedAway();
                resolveBreakMovedAway.wcRoot = root;
                resolveBreakMovedAway.localRelPath = moveSrcRelPath;
                try {
                    resolveBreakMovedAway.transaction(sdb);
                }
                catch (SqlJetException e) {
                    SVNSqlJetDb.createSqlJetError(e);
                }
                haveRow = stmt.next();
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        long selectOpDepth = opDepth != 0L ? opDepth : 1L;
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_NODES_ABOVE_DEPTH_RECURSIVE);
        try {
            stmt.bindf("isi", root.getWcId(), localRelPath, selectOpDepth);
            ((SVNSqlJetTableStatement)stmt).addTrigger(nodesTableTrigger);
            stmt.done();
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        if (opDepth > 0L && opDepth != (long)SVNWCUtils.relpathDepth(localRelPath)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting parent", (Object)root.getAbsPath(localRelPath));
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (clearChangelists) {
            stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_RECURSIVE);
            try {
                stmt.bindf("is", root.getWcId(), localRelPath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_LEAVING_CHANGELIST_RECURSIVE);
        try {
            ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
            stmt.bindf("is", root.getWcId(), localRelPath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        stmt = sdb.getStatement(SVNWCDbStatements.CLEAR_ACTUAL_NODE_LEAVING_CHANGELIST_RECURSIVE);
        try {
            ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
            stmt.bindf("is", root.getWcId(), localRelPath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_WC_LOCK_ORPHAN_RECURSIVE);
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        stmt = root.getFormat() == 29 ? sdb.getStatement(SVNWCDbStatements.SELECT_MOVED_HERE_CHILDREN17) : sdb.getStatement(SVNWCDbStatements.SELECT_MOVED_HERE_CHILDREN);
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            while (haveRow) {
                File movedHereChildRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.moved_to);
                SvnWcDbRevert.clearMovedTo(root, movedHereChildRelPath, nodesTableTrigger);
                haveRow = stmt.next();
            }
        }
        finally {
            stmt.reset();
        }
        if (opDepth > 0L && opDepth == (long)SVNWCUtils.relpathDepth(localRelPath) && movedHere) {
            SvnWcDbRevert.clearMovedTo(root, localRelPath, nodesTableTrigger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<File, ISVNWCDb.SVNWCDbKind> readRevertCopiedChildren(SVNWCContext context, File localAbsPath) throws SVNException {
        TreeMap<File, ISVNWCDb.SVNWCDbKind> result = new TreeMap<File, ISVNWCDb.SVNWCDbKind>(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String path1 = o1.getAbsolutePath();
                String path2 = o2.getAbsolutePath();
                return -SVNPathUtil.PATH_COMPARATOR.compare(path1, path2);
            }
        });
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        File localRelpath = dirInfo.localRelPath;
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        root.getSDb().getTemporaryDb().beginTransaction(SqlJetTransactionMode.READ_ONLY);
        SVNSqlJetStatement stmt = null;
        try {
            stmt = root.getSDb().getTemporaryDb().getStatement(SVNWCDbStatements.SELECT_REVERT_LIST_COPIED_CHILDREN);
            stmt.bindf("si", localRelpath, SVNWCUtils.relpathDepth(localRelpath));
            while (stmt.next()) {
                String relpath = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REVERT_LIST__Fields.local_relpath);
                File childFile = SVNFileUtil.createFilePath(root.getAbsPath(), relpath);
                result.put(childFile, SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.REVERT_LIST__Fields.kind));
            }
        }
        catch (Throwable throwable) {
            SvnWcDbStatementUtil.reset(stmt);
            root.getSDb().getTemporaryDb().commit();
            throw throwable;
        }
        SvnWcDbStatementUtil.reset(stmt);
        root.getSDb().getTemporaryDb().commit();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Structure<RevertInfo> readRevertInfo(SVNWCContext context, File localAbsPath) throws SVNException {
        Object result;
        block14: {
            SVNWCDb db = (SVNWCDb)context.getDb();
            SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
            File localRelpath = dirInfo.localRelPath;
            SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
            root.getSDb().getTemporaryDb().beginTransaction(SqlJetTransactionMode.WRITE);
            result = Structure.obtain(RevertInfo.class);
            ((Structure)result).set((RevertInfo)RevertInfo.kind, (Object)ISVNWCDb.SVNWCDbKind.Unknown);
            ((Structure)result).set((RevertInfo)RevertInfo.reverted, false);
            ((Structure)result).set((RevertInfo)RevertInfo.copiedHere, false);
            try {
                SVNSqlJetSelectStatement stmt = new SVNSqlJetSelectStatement(root.getSDb().getTemporaryDb(), (Enum)SVNWCDbSchema.REVERT_LIST){

                    @Override
                    protected ISqlJetCursor openCursor() throws SVNException {
                        try {
                            return super.openCursor().reverse();
                        }
                        catch (SqlJetException e) {
                            SVNSqlJetDb.createSqlJetError(e);
                            return null;
                        }
                    }

                    @Override
                    protected boolean isFilterPassed() throws SVNException {
                        return this.getBind(1).equals(this.getColumnString(SVNWCDbSchema.REVERT_LIST__Fields.local_relpath));
                    }

                    @Override
                    protected Object[] getWhere() throws SVNException {
                        return new Object[0];
                    }
                };
                stmt.bindf("s", localRelpath);
                boolean haveRow = ((SVNSqlJetStatement)stmt).next();
                if (haveRow) {
                    boolean isActual = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.REVERT_LIST__Fields.actual);
                    boolean anotherRow = false;
                    if (isActual) {
                        byte[] conflictData = SvnWcDbStatementUtil.getColumnBlob(stmt, SVNWCDbSchema.REVERT_LIST__Fields.conflict_data);
                        if (conflictData != null) {
                            SVNSkel conflicts = SVNSkel.parse(conflictData);
                            ((Structure)result).set((RevertInfo)RevertInfo.markerFiles, SvnWcDbConflicts.readConflictMarkers((SVNWCDb)context.getDb(), root.getAbsPath(), conflicts));
                        }
                        if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.REVERT_LIST__Fields.notify)) {
                            ((Structure)result).set((RevertInfo)RevertInfo.reverted, true);
                        }
                        anotherRow = ((SVNSqlJetStatement)stmt).next();
                    }
                    if (!isActual || anotherRow) {
                        ((Structure)result).set((RevertInfo)RevertInfo.reverted, true);
                        if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.REVERT_LIST__Fields.repos_id)) {
                            long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.REVERT_LIST__Fields.op_depth);
                            ((Structure)result).set((RevertInfo)RevertInfo.copiedHere, opDepth == (long)SVNWCUtils.relpathDepth(localRelpath));
                        }
                        ((Structure)result).set((RevertInfo)RevertInfo.kind, (Object)SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.REVERT_LIST__Fields.kind));
                    }
                }
                SvnWcDbStatementUtil.reset(stmt);
                if (!haveRow) break block14;
                stmt = new SVNSqlJetDeleteStatement(root.getSDb().getTemporaryDb(), (Enum)SVNWCDbSchema.REVERT_LIST){

                    @Override
                    protected boolean isFilterPassed() throws SVNException {
                        return this.getBind(1).equals(this.getColumnString(SVNWCDbSchema.REVERT_LIST__Fields.local_relpath));
                    }

                    @Override
                    protected Object[] getWhere() throws SVNException {
                        return new Object[0];
                    }
                };
                try {
                    stmt.bindf("s", localRelpath);
                    stmt.done();
                }
                finally {
                    ((SVNSqlJetStatement)stmt).reset();
                }
            }
            catch (SVNException e) {
                root.getSDb().getTemporaryDb().rollback();
                throw e;
            }
            finally {
                root.getSDb().getTemporaryDb().commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropRevertList(SVNWCContext context, File localAbsPath) throws SVNException {
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        SVNWCDbCreateSchema stmt = new SVNWCDbCreateSchema(root.getSDb().getTemporaryDb(), SVNWCDbCreateSchema.DROP_REVERT_LIST, -1, false);
        try {
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyRevert(SVNWCContext context, File localAbsPath, ISVNEventHandler eventHandler) throws SVNException {
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        File localRelpath = dirInfo.localRelPath;
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        SVNSqlJetSelectStatement stmt = new SVNSqlJetSelectStatement(root.getSDb().getTemporaryDb(), (Enum)SVNWCDbSchema.REVERT_LIST){

            @Override
            protected boolean isFilterPassed() throws SVNException {
                String rowPath = this.getColumnString(SVNWCDbSchema.REVERT_LIST__Fields.local_relpath);
                String selectPath = (String)this.getBind(1);
                if (selectPath.equals(rowPath) || "".equals(selectPath) || rowPath.startsWith(selectPath + "/")) {
                    return !this.isColumnNull(SVNWCDbSchema.REVERT_LIST__Fields.notify) || this.getColumnLong(SVNWCDbSchema.REVERT_LIST__Fields.actual) == 0L;
                }
                return false;
            }

            @Override
            protected Object[] getWhere() throws SVNException {
                return new Object[0];
            }
        };
        stmt.bindf("s", localRelpath);
        try {
            if (eventHandler != null) {
                File previousPath = null;
                while (((SVNSqlJetStatement)stmt).next()) {
                    File notifyRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.REVERT_LIST__Fields.local_relpath);
                    if (previousPath != null && notifyRelPath.equals(previousPath)) continue;
                    previousPath = notifyRelPath;
                    File notifyAbsPath = SVNFileUtil.createFilePath(root.getAbsPath(), notifyRelPath);
                    eventHandler.handleEvent(SVNEventFactory.createSVNEvent(notifyAbsPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.REVERT, SVNEventAction.REVERT, null, null, -1L, -1L), -1.0);
                }
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        stmt = new SVNSqlJetDeleteStatement(root.getSDb().getTemporaryDb(), (Enum)SVNWCDbSchema.REVERT_LIST){

            @Override
            protected Object[] getWhere() throws SVNException {
                return new Object[0];
            }

            @Override
            protected boolean isFilterPassed() throws SVNException {
                String selectPath = (String)this.getBind(1);
                if ("".equals(selectPath)) {
                    return true;
                }
                String rowPath = this.getColumnString(SVNWCDbSchema.REVERT_LIST__Fields.local_relpath);
                return rowPath.equals(selectPath) || rowPath.startsWith(selectPath + "/");
            }
        };
        try {
            stmt.bindf("s", localRelpath);
            stmt.done();
        }
        finally {
            ((SVNSqlJetStatement)stmt).reset();
        }
    }

    public static enum RevertInfo {
        reverted,
        conflictOld,
        conflictNew,
        conflictWorking,
        propReject,
        copiedHere,
        kind,
        markerFiles;

    }
}

