/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.AppearanceStyle;
import org.apache.pdfbox.pdmodel.interactive.form.PDDefaultAppearanceString;
import org.apache.pdfbox.pdmodel.interactive.form.PDListBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;
import org.apache.pdfbox.pdmodel.interactive.form.PlainText;
import org.apache.pdfbox.pdmodel.interactive.form.PlainTextFormatter;
import org.apache.pdfbox.util.Matrix;

class AppearanceGeneratorHelper {
    private static final Log LOG = LogFactory.getLog(AppearanceGeneratorHelper.class);
    private static final Operator BMC = Operator.getOperator("BMC");
    private static final Operator EMC = Operator.getOperator("EMC");
    private final PDVariableText field;
    private PDDefaultAppearanceString defaultAppearance;
    private String value;
    private static final int[] HIGHLIGHT_COLOR = new int[]{153, 193, 215};
    private static final int FONTSCALE = 1000;
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private static final float DEFAULT_PADDING = 0.5f;

    AppearanceGeneratorHelper(PDVariableText field) throws IOException {
        this.field = field;
        this.validateAndEnsureAcroFormResources();
        this.defaultAppearance = field.getDefaultAppearanceString();
    }

    private void validateAndEnsureAcroFormResources() {
        if (this.field.getAcroForm().getDefaultResources() == null) {
            return;
        }
        PDResources acroFormResources = this.field.getAcroForm().getDefaultResources();
        for (PDAnnotationWidget widget : this.field.getWidgets()) {
            if (widget.getNormalAppearanceStream() == null || widget.getNormalAppearanceStream().getResources() == null) continue;
            PDResources widgetResources = widget.getNormalAppearanceStream().getResources();
            for (COSName fontResourceName : widgetResources.getFontNames()) {
                try {
                    if (acroFormResources.getFont(fontResourceName) != null) continue;
                    LOG.debug((Object)("Adding font resource " + fontResourceName + " from widget to AcroForm"));
                    acroFormResources.put(fontResourceName, widgetResources.getFont(fontResourceName));
                }
                catch (IOException e) {
                    LOG.warn((Object)"Unable to match field level font with AcroForm font");
                }
            }
        }
    }

    public void setAppearanceValue(String apValue) throws IOException {
        this.value = apValue;
        if (this.field instanceof PDTextField && !((PDTextField)this.field).isMultiline()) {
            this.value = apValue.replaceAll("\\u000D\\u000A|[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029]", " ");
        }
        for (PDAnnotationWidget widget : this.field.getWidgets()) {
            PDRectangle rect;
            PDDefaultAppearanceString acroFormAppearance = this.defaultAppearance;
            if (widget.getCOSObject().getDictionaryObject(COSName.DA) != null) {
                this.defaultAppearance = this.getWidgetDefaultAppearanceString(widget);
            }
            if ((rect = widget.getRectangle()) == null) {
                widget.getCOSObject().removeItem(COSName.AP);
                LOG.warn((Object)("widget of field " + this.field.getFullyQualifiedName() + " has no rectangle, no appearance stream created"));
                continue;
            }
            PDFormFieldAdditionalActions actions = this.field.getActions();
            if (actions == null || actions.getF() == null || widget.getCOSObject().getDictionaryObject(COSName.AP) != null) {
                PDAppearanceStream appearanceStream;
                PDAppearanceEntry appearance;
                PDAppearanceDictionary appearanceDict = widget.getAppearance();
                if (appearanceDict == null) {
                    appearanceDict = new PDAppearanceDictionary();
                    widget.setAppearance(appearanceDict);
                }
                if ((appearance = appearanceDict.getNormalAppearance()) != null && appearance.isStream()) {
                    appearanceStream = appearance.getAppearanceStream();
                } else {
                    appearanceStream = new PDAppearanceStream(this.field.getAcroForm().getDocument());
                    int rotation = this.resolveRotation(widget);
                    Matrix matrix = Matrix.getRotateInstance(Math.toRadians(rotation), 0.0f, 0.0f);
                    Point2D.Float point2D = matrix.transformPoint(rect.getWidth(), rect.getHeight());
                    PDRectangle bbox = new PDRectangle(Math.abs((float)point2D.getX()), Math.abs((float)point2D.getY()));
                    appearanceStream.setBBox(bbox);
                    appearanceStream.setMatrix(this.calculateMatrix(bbox, rotation));
                    appearanceStream.setFormType(1);
                    appearanceStream.setResources(new PDResources());
                    appearanceDict.setNormalAppearance(appearanceStream);
                }
                if (widget.getAppearanceCharacteristics() != null || appearanceStream.getContentStream().getLength() == 0) {
                    this.initializeAppearanceContent(widget, appearanceStream);
                }
                this.setAppearanceContent(widget, appearanceStream);
            }
            this.defaultAppearance = acroFormAppearance;
        }
    }

    private PDDefaultAppearanceString getWidgetDefaultAppearanceString(PDAnnotationWidget widget) throws IOException {
        COSString da = (COSString)widget.getCOSObject().getDictionaryObject(COSName.DA);
        PDResources dr = this.field.getAcroForm().getDefaultResources();
        return new PDDefaultAppearanceString(da, dr);
    }

    private int resolveRotation(PDAnnotationWidget widget) {
        PDAppearanceCharacteristicsDictionary characteristicsDictionary = widget.getAppearanceCharacteristics();
        if (characteristicsDictionary != null) {
            return characteristicsDictionary.getRotation();
        }
        return 0;
    }

    private void initializeAppearanceContent(PDAnnotationWidget widget, PDAppearanceStream appearanceStream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PDPageContentStream contents = new PDPageContentStream(this.field.getAcroForm().getDocument(), appearanceStream, (OutputStream)output);
        PDAppearanceCharacteristicsDictionary appearanceCharacteristics = widget.getAppearanceCharacteristics();
        if (appearanceCharacteristics != null) {
            PDBorderStyleDictionary borderStyle;
            PDColor backgroundColour = appearanceCharacteristics.getBackground();
            if (backgroundColour != null) {
                contents.setNonStrokingColor(backgroundColour);
                PDRectangle bbox = this.resolveBoundingBox(widget, appearanceStream);
                contents.addRect(bbox.getLowerLeftX(), bbox.getLowerLeftY(), bbox.getWidth(), bbox.getHeight());
                contents.fill();
            }
            float lineWidth = 0.0f;
            PDColor borderColour = appearanceCharacteristics.getBorderColour();
            if (borderColour != null) {
                contents.setStrokingColor(borderColour);
                lineWidth = 1.0f;
            }
            if ((borderStyle = widget.getBorderStyle()) != null && borderStyle.getWidth() > 0.0f) {
                lineWidth = borderStyle.getWidth();
            }
            if (lineWidth > 0.0f && borderColour != null) {
                if (lineWidth != 1.0f) {
                    contents.setLineWidth(lineWidth);
                }
                PDRectangle bbox = this.resolveBoundingBox(widget, appearanceStream);
                PDRectangle clipRect = this.applyPadding(bbox, Math.max(0.5f, lineWidth / 2.0f));
                contents.addRect(clipRect.getLowerLeftX(), clipRect.getLowerLeftY(), clipRect.getWidth(), clipRect.getHeight());
                contents.closeAndStroke();
            }
        }
        contents.close();
        output.close();
        this.writeToStream(output.toByteArray(), appearanceStream);
    }

    private List<Object> tokenize(PDAppearanceStream appearanceStream) throws IOException {
        PDFStreamParser parser = new PDFStreamParser(appearanceStream);
        parser.parse();
        return parser.getTokens();
    }

    private void setAppearanceContent(PDAnnotationWidget widget, PDAppearanceStream appearanceStream) throws IOException {
        this.defaultAppearance.copyNeededResourcesTo(appearanceStream);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ContentStreamWriter writer = new ContentStreamWriter(output);
        List<Object> tokens = this.tokenize(appearanceStream);
        int bmcIndex = tokens.indexOf(BMC);
        if (bmcIndex == -1) {
            writer.writeTokens(tokens);
            writer.writeTokens(COSName.TX, BMC);
        } else {
            writer.writeTokens(tokens.subList(0, bmcIndex + 1));
        }
        this.insertGeneratedAppearance(widget, appearanceStream, output);
        int emcIndex = tokens.indexOf(EMC);
        if (emcIndex == -1) {
            writer.writeTokens(EMC);
        } else {
            writer.writeTokens(tokens.subList(emcIndex, tokens.size()));
        }
        output.close();
        this.writeToStream(output.toByteArray(), appearanceStream);
    }

    private void insertGeneratedAppearance(PDAnnotationWidget widget, PDAppearanceStream appearanceStream, OutputStream output) throws IOException {
        float y;
        PDPageContentStream contents = new PDPageContentStream(this.field.getAcroForm().getDocument(), appearanceStream, output);
        PDRectangle bbox = this.resolveBoundingBox(widget, appearanceStream);
        float borderWidth = 0.0f;
        if (widget.getBorderStyle() != null) {
            borderWidth = widget.getBorderStyle().getWidth();
        }
        PDRectangle clipRect = this.applyPadding(bbox, Math.max(1.0f, borderWidth));
        PDRectangle contentRect = this.applyPadding(clipRect, Math.max(1.0f, borderWidth));
        contents.saveGraphicsState();
        contents.addRect(clipRect.getLowerLeftX(), clipRect.getLowerLeftY(), clipRect.getWidth(), clipRect.getHeight());
        contents.clip();
        PDFont font = this.defaultAppearance.getFont();
        if (font == null) {
            throw new IllegalArgumentException("font is null, check whether /DA entry is incomplete or incorrect");
        }
        float fontSize = this.defaultAppearance.getFontSize();
        if (fontSize == 0.0f) {
            fontSize = this.calculateFontSize(font, contentRect);
        }
        if (this.field instanceof PDListBox) {
            this.insertGeneratedSelectionHighlight(contents, appearanceStream, font, fontSize);
        }
        contents.beginText();
        this.defaultAppearance.writeTo(contents, fontSize);
        float fontScaleY = fontSize / 1000.0f;
        float fontBoundingBoxAtSize = font.getBoundingBox().getHeight() * fontScaleY;
        float fontCapAtSize = font.getFontDescriptor().getCapHeight() * fontScaleY;
        float fontDescentAtSize = font.getFontDescriptor().getDescent() * fontScaleY;
        if (this.field instanceof PDTextField && ((PDTextField)this.field).isMultiline()) {
            y = contentRect.getUpperRightY() - fontBoundingBoxAtSize;
        } else if (fontCapAtSize > clipRect.getHeight()) {
            y = clipRect.getLowerLeftY() + -fontDescentAtSize;
        } else {
            y = clipRect.getLowerLeftY() + (clipRect.getHeight() - fontCapAtSize) / 2.0f;
            if (y - clipRect.getLowerLeftY() < -fontDescentAtSize) {
                float fontDescentBased = -fontDescentAtSize + contentRect.getLowerLeftY();
                float fontCapBased = contentRect.getHeight() - contentRect.getLowerLeftY() - fontCapAtSize;
                y = Math.min(fontDescentBased, Math.max(y, fontCapBased));
            }
        }
        float x = contentRect.getLowerLeftX();
        if (this.shallComb()) {
            this.insertGeneratedCombAppearance(contents, appearanceStream, font, fontSize);
        } else if (this.field instanceof PDListBox) {
            this.insertGeneratedListboxAppearance(contents, appearanceStream, contentRect, font, fontSize);
        } else {
            PlainText textContent = new PlainText(this.value);
            AppearanceStyle appearanceStyle = new AppearanceStyle();
            appearanceStyle.setFont(font);
            appearanceStyle.setFontSize(fontSize);
            appearanceStyle.setLeading(font.getBoundingBox().getHeight() * fontScaleY);
            PlainTextFormatter formatter = new PlainTextFormatter.Builder(contents).style(appearanceStyle).text(textContent).width(contentRect.getWidth()).wrapLines(this.isMultiLine()).initialOffset(x, y).textAlign(this.field.getQ()).build();
            formatter.format();
        }
        contents.endText();
        contents.restoreGraphicsState();
        contents.close();
    }

    private AffineTransform calculateMatrix(PDRectangle bbox, int rotation) {
        if (rotation == 0) {
            return new AffineTransform();
        }
        float tx = 0.0f;
        float ty = 0.0f;
        switch (rotation) {
            case 90: {
                tx = bbox.getUpperRightY();
                break;
            }
            case 180: {
                tx = bbox.getUpperRightY();
                ty = bbox.getUpperRightX();
                break;
            }
            case 270: {
                ty = bbox.getUpperRightX();
                break;
            }
        }
        Matrix matrix = Matrix.getRotateInstance(Math.toRadians(rotation), tx, ty);
        return matrix.createAffineTransform();
    }

    private boolean isMultiLine() {
        return this.field instanceof PDTextField && ((PDTextField)this.field).isMultiline();
    }

    private boolean shallComb() {
        return this.field instanceof PDTextField && ((PDTextField)this.field).isComb() && !((PDTextField)this.field).isMultiline() && !((PDTextField)this.field).isPassword() && !((PDTextField)this.field).isFileSelect();
    }

    private void insertGeneratedCombAppearance(PDPageContentStream contents, PDAppearanceStream appearanceStream, PDFont font, float fontSize) throws IOException {
        int maxLen = ((PDTextField)this.field).getMaxLen();
        int numChars = Math.min(this.value.length(), maxLen);
        PDRectangle paddingEdge = this.applyPadding(appearanceStream.getBBox(), 1.0f);
        float combWidth = appearanceStream.getBBox().getWidth() / (float)maxLen;
        float ascentAtFontSize = font.getFontDescriptor().getAscent() / 1000.0f * fontSize;
        float baselineOffset = paddingEdge.getLowerLeftY() + (appearanceStream.getBBox().getHeight() - ascentAtFontSize) / 2.0f;
        float prevCharWidth = 0.0f;
        float xOffset = combWidth / 2.0f;
        for (int i = 0; i < numChars; ++i) {
            String combString = this.value.substring(i, i + 1);
            float currCharWidth = font.getStringWidth(combString) / 1000.0f * fontSize / 2.0f;
            xOffset = xOffset + prevCharWidth / 2.0f - currCharWidth / 2.0f;
            contents.newLineAtOffset(xOffset, baselineOffset);
            contents.showText(combString);
            baselineOffset = 0.0f;
            prevCharWidth = currCharWidth;
            xOffset = combWidth;
        }
    }

    private void insertGeneratedSelectionHighlight(PDPageContentStream contents, PDAppearanceStream appearanceStream, PDFont font, float fontSize) throws IOException {
        List<Integer> indexEntries = ((PDListBox)this.field).getSelectedOptionsIndex();
        List<String> values = ((PDListBox)this.field).getValue();
        List<String> options = ((PDListBox)this.field).getOptionsExportValues();
        if (!values.isEmpty() && !options.isEmpty() && indexEntries.isEmpty()) {
            indexEntries = new ArrayList<Integer>();
            for (String v : values) {
                indexEntries.add(options.indexOf(v));
            }
        }
        int topIndex = ((PDListBox)this.field).getTopIndex();
        float highlightBoxHeight = font.getBoundingBox().getHeight() * fontSize / 1000.0f;
        PDRectangle paddingEdge = this.applyPadding(appearanceStream.getBBox(), 1.0f);
        for (int selectedIndex : indexEntries) {
            contents.setNonStrokingColor(HIGHLIGHT_COLOR[0], HIGHLIGHT_COLOR[1], HIGHLIGHT_COLOR[2]);
            contents.addRect(paddingEdge.getLowerLeftX(), paddingEdge.getUpperRightY() - highlightBoxHeight * (float)(selectedIndex - topIndex + 1) + 2.0f, paddingEdge.getWidth(), highlightBoxHeight);
            contents.fill();
        }
        contents.setNonStrokingColor(0);
    }

    private void insertGeneratedListboxAppearance(PDPageContentStream contents, PDAppearanceStream appearanceStream, PDRectangle contentRect, PDFont font, float fontSize) throws IOException {
        int topIndex;
        contents.setNonStrokingColor(0);
        int q = this.field.getQ();
        if (q == 1 || q == 2) {
            float fieldWidth = appearanceStream.getBBox().getWidth();
            float stringWidth = font.getStringWidth(this.value) / 1000.0f * fontSize;
            float adjustAmount = fieldWidth - stringWidth - 4.0f;
            if (q == 1) {
                adjustAmount /= 2.0f;
            }
            contents.newLineAtOffset(adjustAmount, 0.0f);
        } else if (q != 0) {
            throw new IOException("Error: Unknown justification value:" + q);
        }
        List<String> options = ((PDListBox)this.field).getOptionsDisplayValues();
        int numOptions = options.size();
        float yTextPos = contentRect.getUpperRightY();
        for (int i = topIndex = ((PDListBox)this.field).getTopIndex(); i < numOptions; ++i) {
            if (i == topIndex) {
                yTextPos -= font.getFontDescriptor().getAscent() / 1000.0f * fontSize;
            } else {
                yTextPos -= font.getBoundingBox().getHeight() / 1000.0f * fontSize;
                contents.beginText();
            }
            contents.newLineAtOffset(contentRect.getLowerLeftX(), yTextPos);
            contents.showText(options.get(i));
            if (i - topIndex == numOptions - 1) continue;
            contents.endText();
        }
    }

    private void writeToStream(byte[] data, PDAppearanceStream appearanceStream) throws IOException {
        OutputStream out = appearanceStream.getCOSObject().createOutputStream();
        out.write(data);
        out.close();
    }

    private float calculateFontSize(PDFont font, PDRectangle contentRect) throws IOException {
        float fontSize = this.defaultAppearance.getFontSize();
        if (fontSize == 0.0f) {
            if (this.isMultiLine()) {
                return 12.0f;
            }
            float yScalingFactor = 1000.0f * font.getFontMatrix().getScaleY();
            float xScalingFactor = 1000.0f * font.getFontMatrix().getScaleX();
            float width = font.getStringWidth(this.value) * font.getFontMatrix().getScaleX();
            float widthBasedFontSize = contentRect.getWidth() / width * xScalingFactor;
            float height = (font.getFontDescriptor().getCapHeight() + -font.getFontDescriptor().getDescent()) * font.getFontMatrix().getScaleY();
            if (height <= 0.0f) {
                height = font.getBoundingBox().getHeight() * font.getFontMatrix().getScaleY();
            }
            float heightBasedFontSize = contentRect.getHeight() / height * yScalingFactor;
            return Math.min(heightBasedFontSize, widthBasedFontSize);
        }
        return fontSize;
    }

    private PDRectangle resolveBoundingBox(PDAnnotationWidget fieldWidget, PDAppearanceStream appearanceStream) {
        PDRectangle boundingBox = appearanceStream.getBBox();
        if (boundingBox == null) {
            boundingBox = fieldWidget.getRectangle().createRetranslatedRectangle();
        }
        return boundingBox;
    }

    private PDRectangle applyPadding(PDRectangle box, float padding) {
        return new PDRectangle(box.getLowerLeftX() + padding, box.getLowerLeftY() + padding, box.getWidth() - 2.0f * padding, box.getHeight() - 2.0f * padding);
    }
}

