/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.util.Map;
import javax.swing.Icon;
import org.omegat.util.Log;

public final class MainMenuIcons {
    private static final Map<?, ?> DEFAULT_HINTS;
    private static final int ICON_SIZE = 12;

    private MainMenuIcons() {
    }

    static Icon newBlankIcon() {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }

            @Override
            public int getIconWidth() {
                return 12;
            }

            @Override
            public int getIconHeight() {
                return this.getIconWidth();
            }
        };
    }

    static Icon newColorIcon(final Color color) {
        return new BaseIcon(){

            @Override
            void doPaint(Graphics2D g2, int x, int y) {
                if (color != null) {
                    g2.setColor(color);
                }
                g2.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            }
        };
    }

    static Icon newTextIcon(Color color, char c) {
        return MainMenuIcons.newTextIcon(color, null, c);
    }

    static Icon newTextIcon(final Color color, final Font font, char c) {
        final char[] chars = new char[]{c};
        return new BaseIcon(){

            @Override
            void doPaint(Graphics2D g2, int x, int y) {
                if (color != null) {
                    g2.setColor(color);
                }
                if (font != null) {
                    g2.setFont(font);
                }
                GlyphVector gv = g2.getFont().layoutGlyphVector(g2.getFontRenderContext(), chars, 0, 1, 0);
                Rectangle r = gv.getPixelBounds(g2.getFontRenderContext(), x, y);
                int dx = x + (this.getIconWidth() - r.width) / 2;
                int dy = y + this.getIconHeight() - (this.getIconHeight() - r.height) / 2;
                g2.drawGlyphVector(gv, dx, dy);
            }
        };
    }

    static {
        Map<Object, Object> defaultHints = new RenderingHints(null);
        try {
            defaultHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        }
        catch (Throwable e) {
            Log.log(e);
        }
        DEFAULT_HINTS = defaultHints;
    }

    private static abstract class BaseIcon
    implements Icon {
        private BaseIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.addRenderingHints(DEFAULT_HINTS);
            g2.setClip(x, y, this.getIconWidth(), this.getIconHeight());
            this.doPaint(g2, x, y);
            g2.dispose();
        }

        abstract void doPaint(Graphics2D var1, int var2, int var3);

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return this.getIconWidth();
        }
    }
}

