/* ***** BEGIN LICENSE BLOCK *****
* Version: MPL 1.1/GPL 2.0/LGPL 2.1
*
* The contents of this file are subject to the Mozilla Public License Version
* 1.1 (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS" basis,
* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
* for the specific language governing rights and limitations under the
* License.
*
* The Original Code is CocoaScriptMenu.
*
* The Initial Developer of the Original Code is
* James Tuley.
* Portions created by the Initial Developer are Copyright (C) 2004-2005
* the Initial Developer. All Rights Reserved.
*
* Contributor(s):
*           James Tuley <jay+csm@tuley.name> (Original Author)
*
* Alternatively, the contents of this file may be used under the terms of
* either the GNU General Public License Version 2 or later (the "GPL"), or
* the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
* in which case the provisions of the GPL or the LGPL are applicable instead
* of those above. If you wish to allow use of your version of this file only
* under the terms of either the GPL or the LGPL, and not to allow others to
* use your version of this file under the terms of the MPL, indicate your
* decision by deleting the provisions above and replace them with the notice
* and other provisions required by the GPL or the LGPL. If you do not delete
* the provisions above, a recipient may use your version of this file under
* the terms of any one of the MPL, the GPL or the LGPL.
*
* ***** END LICENSE BLOCK ***** */


//
//  CSMMenuNameParser.h
//  CocoaScriptMenu
//
//  Created by James Tuley on 10/1/05.
//  Copyright 2005 James Tuley. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol CSMMenuNameParser <NSObject>
-(id)initWithPath:(NSString*) aPath;

-(NSString*)keyEquivalent;

-(unsigned int)keyEquivalentModifiers;

-(NSString*)name;

-(NSString*)sortName;

@end

@interface CSMMenuNameParser : NSObject {
    @protected
    NSString* theMenuName;
    unsigned int theModifier;
    NSString* theKeyEquivalent;
    NSString* thePrefix;
}

-(id)initWithPath:(NSString*) aPath;

-(NSString*)keyEquivalent;

-(unsigned int)keyEquivalentModifiers;

-(NSString*)name;

-(NSString*)sortName;

@end
