/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;

final class CompilerOptionsQueryImpl
implements CompilerOptionsQueryImplementation {
    private final PropertyEvaluator eval;
    private final String additionalCompilerOptionsProperty;
    private final AtomicReference<CompilerOptionsQueryImplementation.Result> result;

    CompilerOptionsQueryImpl(@NonNull PropertyEvaluator eval, @NonNull String additionalCompilerOptionsProperty) {
        Parameters.notNull((CharSequence)"eval", (Object)eval);
        Parameters.notNull((CharSequence)"additionalCompilerOptionsProperty", (Object)additionalCompilerOptionsProperty);
        this.eval = eval;
        this.additionalCompilerOptionsProperty = additionalCompilerOptionsProperty;
        this.result = new AtomicReference();
    }

    @CheckForNull
    public CompilerOptionsQueryImplementation.Result getOptions(FileObject file) {
        CompilerOptionsQueryImplementation.Result res = this.result.get();
        if (res == null) {
            res = new ResultImpl(this.eval, this.additionalCompilerOptionsProperty);
            if (!this.result.compareAndSet(null, res)) {
                res = this.result.get();
            }
            assert (res != null);
        }
        return res;
    }

    private static final class ResultImpl
    extends CompilerOptionsQueryImplementation.Result
    implements PropertyChangeListener {
        private final PropertyEvaluator eval;
        private final String additionalCompilerOptionsProperty;
        private final ChangeSupport listeners;
        private volatile List<String> cache;

        ResultImpl(@NonNull PropertyEvaluator eval, @NonNull String additionalCompilerOptionsProperty) {
            this.eval = eval;
            this.additionalCompilerOptionsProperty = additionalCompilerOptionsProperty;
            this.listeners = new ChangeSupport((Object)this);
            this.eval.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @NonNull
        public List<? extends String> getArguments() {
            List<String> res = this.cache;
            if (res == null) {
                String additionalCompilerOptions = this.eval.getProperty(this.additionalCompilerOptionsProperty);
                this.cache = res = additionalCompilerOptions == null || additionalCompilerOptions.isEmpty() ? Collections.emptyList() : this.parseLine(additionalCompilerOptions);
            }
            return res;
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.removeChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || this.additionalCompilerOptionsProperty.equals(propName)) {
                this.cache = null;
                this.listeners.fireChange();
            }
        }
    }
}

