/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooserPanel;
import org.openide.util.Exceptions;

public final class TransferFilesChangeSupport {
    final List<TransferFilesChooserPanel.TransferFilesChangeListener> listeners = new CopyOnWriteArrayList<TransferFilesChooserPanel.TransferFilesChangeListener>();
    private final Object source;

    public TransferFilesChangeSupport(Object source) {
        this.source = source;
    }

    public void addChangeListener(TransferFilesChooserPanel.TransferFilesChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeChangeListener(TransferFilesChooserPanel.TransferFilesChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void fireSelectedFilesChange() {
        for (TransferFilesChooserPanel.TransferFilesChangeListener listener : this.listeners) {
            try {
                listener.selectedFilesChanged();
            }
            catch (RuntimeException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    public void fireFilterChange() {
        for (TransferFilesChooserPanel.TransferFilesChangeListener listener : this.listeners) {
            try {
                listener.filterChanged();
            }
            catch (RuntimeException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }
}

