/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Dialog;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.ConnectUsingDriverAction;
import org.netbeans.modules.db.explorer.dlg.ChoosingConnectionNamePanel;
import org.netbeans.modules.db.explorer.dlg.ChoosingDriverPanel;
import org.netbeans.modules.db.explorer.dlg.ChoosingSchemaPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class AddConnectionWizard
extends ConnectionDialogMediator
implements WizardDescriptor.Iterator<AddConnectionWizard> {
    private String downloadFrom;
    private final Set<String> allPrivilegedFileNames = new HashSet<String>();
    private String privilegedFileName;
    private String[] steps;
    private WizardDescriptor.Panel<AddConnectionWizard>[] panels;
    private int index;
    private ChoosingDriverPanel driverPanel;
    private final String pwd;
    private final String databaseUrl;
    private final String user;
    private final WizardDescriptor wd;
    private DatabaseConnection connection;
    private List<String> schemas = null;
    private String currentSchema;
    private JDBCDriver jdbcDriver;

    private AddConnectionWizard(JDBCDriver driver, String databaseUrl, String user, String password) {
        this.databaseUrl = databaseUrl;
        this.user = user;
        this.pwd = password;
        this.wd = new WizardDescriptor((WizardDescriptor.Iterator)this, (Object)this);
        this.wd.setTitleFormat(new MessageFormat("{0}"));
        this.wd.setTitle(NbBundle.getMessage(AddConnectionWizard.class, (String)"PredefinedWizard.WizardTitle"));
        this.updateState(driver);
    }

    @Override
    protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection dbcon, String defaultSchema) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static DatabaseConnection showWizard(JDBCDriver driver, String databaseUrl, String user, String password) {
        AddConnectionWizard wiz = new AddConnectionWizard(driver, databaseUrl, user, password);
        wiz.showWizard();
        return wiz.getResult();
    }

    private void showWizard() {
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wd);
        dialog.setVisible(true);
    }

    private DatabaseConnection getResult() {
        boolean cancelled;
        boolean bl = cancelled = this.wd.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            assert (this.getDatabaseConnection() != null) : "DatabaseConnection found.";
            DatabaseConnection conn = this.getDatabaseConnection();
            if (this.getSchemas() != null) {
                conn.setSchema(this.getCurrentSchema());
            }
            try {
                ConnectionList.getDefault().add(this.getDatabaseConnection());
                return this.getDatabaseConnection();
            }
            catch (DatabaseException ex) {
                Logger.getLogger(AddConnectionWizard.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
                DbUtilities.reportError(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableToAddConnection"), ex.getMessage());
                this.closeConnection();
            }
        }
        return null;
    }

    private WizardDescriptor.Panel<AddConnectionWizard>[] getPanels() {
        if (this.panels == null) {
            FileObject jarFO;
            URL[] jars;
            boolean skipDriverSelection = false;
            if (this.jdbcDriver != null && (jars = this.jdbcDriver.getURLs()) != null && jars.length > 0 && (jarFO = URLMapper.findFileObject((URL)jars[0])) != null && jarFO.isValid()) {
                this.allPrivilegedFileNames.add(jarFO.getNameExt());
                skipDriverSelection = true;
            }
            ArrayList<Panel> toPanels = new ArrayList<Panel>();
            ArrayList<String> toSteps = new ArrayList<String>();
            int stepIndex = 0;
            if (!skipDriverSelection) {
                toPanels.add(new ChoosingDriverPanel(this.jdbcDriver, stepIndex));
                toSteps.add(NbBundle.getMessage(AddConnectionWizard.class, (String)"ChoosingDriverUI.Name"));
                ++stepIndex;
            }
            toPanels.add(new ConnectionPanel(stepIndex));
            toSteps.add(NbBundle.getMessage(AddConnectionWizard.class, (String)"ConnectionPanel.Name"));
            toPanels.add(new ChoosingSchemaPanel(++stepIndex));
            toSteps.add(NbBundle.getMessage(AddConnectionWizard.class, (String)"ChoosingSchemaPanel.Name"));
            toPanels.add(new ChoosingConnectionNamePanel(++stepIndex));
            toSteps.add(NbBundle.getMessage(AddConnectionWizard.class, (String)"ChooseConnectionNamePanel.Name"));
            this.panels = toPanels.toArray(new Panel[++stepIndex]);
            this.steps = toSteps.toArray(new String[stepIndex]);
        }
        return this.panels;
    }

    public WizardDescriptor.Panel<AddConnectionWizard> current() {
        this.getPanels();
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    void setDriver(JDBCDriver driver) {
        if (driver == null) {
            this.updateState(null);
        } else {
            this.updateState(driver);
        }
    }

    JDBCDriver getDriver() {
        return this.jdbcDriver;
    }

    String getDatabaseUrl() {
        return this.databaseUrl;
    }

    String getUser() {
        return this.user;
    }

    String getPassword() {
        return this.pwd;
    }

    String[] getSteps() {
        return this.steps;
    }

    void setDatabaseConnection(DatabaseConnection conn) {
        this.connection = conn;
    }

    DatabaseConnection getDatabaseConnection() {
        return this.connection;
    }

    void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    List<String> getSchemas() {
        return this.schemas;
    }

    void setCurrentSchema(String schema) {
        this.currentSchema = schema;
    }

    String getCurrentSchema() {
        return this.currentSchema;
    }

    String getDownloadFrom() {
        return this.downloadFrom;
    }

    Collection<String> getAllPrivilegedNames() {
        return this.allPrivilegedFileNames;
    }

    String getPrivilegedName() {
        return this.privilegedFileName;
    }

    @Override
    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    private void updateState(JDBCDriver driver) {
        if (driver != null) {
            if (driver.getName().contains("Oracle")) {
                this.downloadFrom = NbBundle.getMessage(AddConnectionWizard.class, (String)"oracle.from");
                this.allPrivilegedFileNames.clear();
                this.privilegedFileName = NbBundle.getMessage(AddConnectionWizard.class, (String)"oracle.driver.name");
                StringTokenizer st = new StringTokenizer(NbBundle.getMessage(AddConnectionWizard.class, (String)"oracle.driver.name.prefix"), ",");
                while (st.hasMoreTokens()) {
                    this.allPrivilegedFileNames.add(st.nextToken().trim());
                }
            } else if (driver.getName().contains("MySQL")) {
                this.downloadFrom = NbBundle.getMessage(AddConnectionWizard.class, (String)"mysql.from");
                this.allPrivilegedFileNames.clear();
                this.privilegedFileName = NbBundle.getMessage(AddConnectionWizard.class, (String)"mysql.driver.name");
                StringTokenizer st = new StringTokenizer(NbBundle.getMessage(AddConnectionWizard.class, (String)"mysql.driver.name.prefix"), ",");
                while (st.hasMoreTokens()) {
                    this.allPrivilegedFileNames.add(st.nextToken().trim());
                }
            } else {
                this.downloadFrom = null;
                this.privilegedFileName = "";
                this.allPrivilegedFileNames.clear();
            }
            this.jdbcDriver = driver;
        }
    }

    public NotificationLineSupport getNotificationLineSupport() {
        return this.wd.getNotificationLineSupport();
    }

    public static interface Panel
    extends WizardDescriptor.Panel<AddConnectionWizard> {
    }
}

